/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListObjectVersionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListObjectVersionsResponse.Builder, ListObjectVersionsResponse> {
    private final Boolean isTruncated;

    private final String keyMarker;

    private final String versionIdMarker;

    private final String nextKeyMarker;

    private final String nextVersionIdMarker;

    private final List<ObjectVersion> versions;

    private final List<DeleteMarkerEntry> deleteMarkers;

    private final String name;

    private final String prefix;

    private final String delimiter;

    private final Integer maxKeys;

    private final List<CommonPrefix> commonPrefixes;

    private final String encodingType;

    private ListObjectVersionsResponse(BuilderImpl builder) {
        this.isTruncated = builder.isTruncated;
        this.keyMarker = builder.keyMarker;
        this.versionIdMarker = builder.versionIdMarker;
        this.nextKeyMarker = builder.nextKeyMarker;
        this.nextVersionIdMarker = builder.nextVersionIdMarker;
        this.versions = builder.versions;
        this.deleteMarkers = builder.deleteMarkers;
        this.name = builder.name;
        this.prefix = builder.prefix;
        this.delimiter = builder.delimiter;
        this.maxKeys = builder.maxKeys;
        this.commonPrefixes = builder.commonPrefixes;
        this.encodingType = builder.encodingType;
    }

    /**
     * A flag that indicates whether or not Amazon S3 returned all of the results that satisfied the search criteria. If
     * your results were truncated, you can make a follow-up paginated request using the NextKeyMarker and
     * NextVersionIdMarker response parameters as a starting place in another request to return the rest of the results.
     * 
     * @return A flag that indicates whether or not Amazon S3 returned all of the results that satisfied the search
     *         criteria. If your results were truncated, you can make a follow-up paginated request using the
     *         NextKeyMarker and NextVersionIdMarker response parameters as a starting place in another request to
     *         return the rest of the results.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * Marks the last Key returned in a truncated response.
     * 
     * @return Marks the last Key returned in a truncated response.
     */
    public String keyMarker() {
        return keyMarker;
    }

    /**
     * Returns the value of the VersionIdMarker property for this object.
     * 
     * @return The value of the VersionIdMarker property for this object.
     */
    public String versionIdMarker() {
        return versionIdMarker;
    }

    /**
     * Use this value for the key marker request parameter in a subsequent request.
     * 
     * @return Use this value for the key marker request parameter in a subsequent request.
     */
    public String nextKeyMarker() {
        return nextKeyMarker;
    }

    /**
     * Use this value for the next version id marker parameter in a subsequent request.
     * 
     * @return Use this value for the next version id marker parameter in a subsequent request.
     */
    public String nextVersionIdMarker() {
        return nextVersionIdMarker;
    }

    /**
     * Returns the value of the Versions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Versions property for this object.
     */
    public List<ObjectVersion> versions() {
        return versions;
    }

    /**
     * Returns the value of the DeleteMarkers property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the DeleteMarkers property for this object.
     */
    public List<DeleteMarkerEntry> deleteMarkers() {
        return deleteMarkers;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public String name() {
        return name;
    }

    /**
     * Returns the value of the Prefix property for this object.
     * 
     * @return The value of the Prefix property for this object.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * Returns the value of the Delimiter property for this object.
     * 
     * @return The value of the Delimiter property for this object.
     */
    public String delimiter() {
        return delimiter;
    }

    /**
     * Returns the value of the MaxKeys property for this object.
     * 
     * @return The value of the MaxKeys property for this object.
     */
    public Integer maxKeys() {
        return maxKeys;
    }

    /**
     * Returns the value of the CommonPrefixes property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the CommonPrefixes property for this object.
     */
    public List<CommonPrefix> commonPrefixes() {
        return commonPrefixes;
    }

    /**
     * Encoding type used by Amazon S3 to encode object keys in the response.
     * 
     * @return Encoding type used by Amazon S3 to encode object keys in the response.
     * @see EncodingType
     */
    public String encodingType() {
        return encodingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((isTruncated() == null) ? 0 : isTruncated().hashCode());
        hashCode = 31 * hashCode + ((keyMarker() == null) ? 0 : keyMarker().hashCode());
        hashCode = 31 * hashCode + ((versionIdMarker() == null) ? 0 : versionIdMarker().hashCode());
        hashCode = 31 * hashCode + ((nextKeyMarker() == null) ? 0 : nextKeyMarker().hashCode());
        hashCode = 31 * hashCode + ((nextVersionIdMarker() == null) ? 0 : nextVersionIdMarker().hashCode());
        hashCode = 31 * hashCode + ((versions() == null) ? 0 : versions().hashCode());
        hashCode = 31 * hashCode + ((deleteMarkers() == null) ? 0 : deleteMarkers().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((delimiter() == null) ? 0 : delimiter().hashCode());
        hashCode = 31 * hashCode + ((maxKeys() == null) ? 0 : maxKeys().hashCode());
        hashCode = 31 * hashCode + ((commonPrefixes() == null) ? 0 : commonPrefixes().hashCode());
        hashCode = 31 * hashCode + ((encodingType() == null) ? 0 : encodingType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectVersionsResponse)) {
            return false;
        }
        ListObjectVersionsResponse other = (ListObjectVersionsResponse) obj;
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.keyMarker() == null ^ this.keyMarker() == null) {
            return false;
        }
        if (other.keyMarker() != null && !other.keyMarker().equals(this.keyMarker())) {
            return false;
        }
        if (other.versionIdMarker() == null ^ this.versionIdMarker() == null) {
            return false;
        }
        if (other.versionIdMarker() != null && !other.versionIdMarker().equals(this.versionIdMarker())) {
            return false;
        }
        if (other.nextKeyMarker() == null ^ this.nextKeyMarker() == null) {
            return false;
        }
        if (other.nextKeyMarker() != null && !other.nextKeyMarker().equals(this.nextKeyMarker())) {
            return false;
        }
        if (other.nextVersionIdMarker() == null ^ this.nextVersionIdMarker() == null) {
            return false;
        }
        if (other.nextVersionIdMarker() != null && !other.nextVersionIdMarker().equals(this.nextVersionIdMarker())) {
            return false;
        }
        if (other.versions() == null ^ this.versions() == null) {
            return false;
        }
        if (other.versions() != null && !other.versions().equals(this.versions())) {
            return false;
        }
        if (other.deleteMarkers() == null ^ this.deleteMarkers() == null) {
            return false;
        }
        if (other.deleteMarkers() != null && !other.deleteMarkers().equals(this.deleteMarkers())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.delimiter() == null ^ this.delimiter() == null) {
            return false;
        }
        if (other.delimiter() != null && !other.delimiter().equals(this.delimiter())) {
            return false;
        }
        if (other.maxKeys() == null ^ this.maxKeys() == null) {
            return false;
        }
        if (other.maxKeys() != null && !other.maxKeys().equals(this.maxKeys())) {
            return false;
        }
        if (other.commonPrefixes() == null ^ this.commonPrefixes() == null) {
            return false;
        }
        if (other.commonPrefixes() != null && !other.commonPrefixes().equals(this.commonPrefixes())) {
            return false;
        }
        if (other.encodingType() == null ^ this.encodingType() == null) {
            return false;
        }
        if (other.encodingType() != null && !other.encodingType().equals(this.encodingType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (keyMarker() != null) {
            sb.append("KeyMarker: ").append(keyMarker()).append(",");
        }
        if (versionIdMarker() != null) {
            sb.append("VersionIdMarker: ").append(versionIdMarker()).append(",");
        }
        if (nextKeyMarker() != null) {
            sb.append("NextKeyMarker: ").append(nextKeyMarker()).append(",");
        }
        if (nextVersionIdMarker() != null) {
            sb.append("NextVersionIdMarker: ").append(nextVersionIdMarker()).append(",");
        }
        if (versions() != null) {
            sb.append("Versions: ").append(versions()).append(",");
        }
        if (deleteMarkers() != null) {
            sb.append("DeleteMarkers: ").append(deleteMarkers()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (delimiter() != null) {
            sb.append("Delimiter: ").append(delimiter()).append(",");
        }
        if (maxKeys() != null) {
            sb.append("MaxKeys: ").append(maxKeys()).append(",");
        }
        if (commonPrefixes() != null) {
            sb.append("CommonPrefixes: ").append(commonPrefixes()).append(",");
        }
        if (encodingType() != null) {
            sb.append("EncodingType: ").append(encodingType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListObjectVersionsResponse> {
        /**
         * A flag that indicates whether or not Amazon S3 returned all of the results that satisfied the search
         * criteria. If your results were truncated, you can make a follow-up paginated request using the NextKeyMarker
         * and NextVersionIdMarker response parameters as a starting place in another request to return the rest of the
         * results.
         * 
         * @param isTruncated
         *        A flag that indicates whether or not Amazon S3 returned all of the results that satisfied the search
         *        criteria. If your results were truncated, you can make a follow-up paginated request using the
         *        NextKeyMarker and NextVersionIdMarker response parameters as a starting place in another request to
         *        return the rest of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * Marks the last Key returned in a truncated response.
         * 
         * @param keyMarker
         *        Marks the last Key returned in a truncated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyMarker(String keyMarker);

        /**
         * Sets the value of the VersionIdMarker property for this object.
         *
         * @param versionIdMarker
         *        The new value for the VersionIdMarker property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionIdMarker(String versionIdMarker);

        /**
         * Use this value for the key marker request parameter in a subsequent request.
         * 
         * @param nextKeyMarker
         *        Use this value for the key marker request parameter in a subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextKeyMarker(String nextKeyMarker);

        /**
         * Use this value for the next version id marker parameter in a subsequent request.
         * 
         * @param nextVersionIdMarker
         *        Use this value for the next version id marker parameter in a subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextVersionIdMarker(String nextVersionIdMarker);

        /**
         * Sets the value of the Versions property for this object.
         *
         * @param versions
         *        The new value for the Versions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(Collection<ObjectVersion> versions);

        /**
         * Sets the value of the Versions property for this object.
         *
         * @param versions
         *        The new value for the Versions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(ObjectVersion... versions);

        /**
         * Sets the value of the DeleteMarkers property for this object.
         *
         * @param deleteMarkers
         *        The new value for the DeleteMarkers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteMarkers(Collection<DeleteMarkerEntry> deleteMarkers);

        /**
         * Sets the value of the DeleteMarkers property for this object.
         *
         * @param deleteMarkers
         *        The new value for the DeleteMarkers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteMarkers(DeleteMarkerEntry... deleteMarkers);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Prefix property for this object.
         *
         * @param prefix
         *        The new value for the Prefix property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * Sets the value of the Delimiter property for this object.
         *
         * @param delimiter
         *        The new value for the Delimiter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimiter(String delimiter);

        /**
         * Sets the value of the MaxKeys property for this object.
         *
         * @param maxKeys
         *        The new value for the MaxKeys property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxKeys(Integer maxKeys);

        /**
         * Sets the value of the CommonPrefixes property for this object.
         *
         * @param commonPrefixes
         *        The new value for the CommonPrefixes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonPrefixes(Collection<CommonPrefix> commonPrefixes);

        /**
         * Sets the value of the CommonPrefixes property for this object.
         *
         * @param commonPrefixes
         *        The new value for the CommonPrefixes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonPrefixes(CommonPrefix... commonPrefixes);

        /**
         * Encoding type used by Amazon S3 to encode object keys in the response.
         * 
         * @param encodingType
         *        Encoding type used by Amazon S3 to encode object keys in the response.
         * @see EncodingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(String encodingType);

        /**
         * Encoding type used by Amazon S3 to encode object keys in the response.
         * 
         * @param encodingType
         *        Encoding type used by Amazon S3 to encode object keys in the response.
         * @see EncodingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(EncodingType encodingType);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean isTruncated;

        private String keyMarker;

        private String versionIdMarker;

        private String nextKeyMarker;

        private String nextVersionIdMarker;

        private List<ObjectVersion> versions;

        private List<DeleteMarkerEntry> deleteMarkers;

        private String name;

        private String prefix;

        private String delimiter;

        private Integer maxKeys;

        private List<CommonPrefix> commonPrefixes;

        private String encodingType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectVersionsResponse model) {
            setIsTruncated(model.isTruncated);
            setKeyMarker(model.keyMarker);
            setVersionIdMarker(model.versionIdMarker);
            setNextKeyMarker(model.nextKeyMarker);
            setNextVersionIdMarker(model.nextVersionIdMarker);
            setVersions(model.versions);
            setDeleteMarkers(model.deleteMarkers);
            setName(model.name);
            setPrefix(model.prefix);
            setDelimiter(model.delimiter);
            setMaxKeys(model.maxKeys);
            setCommonPrefixes(model.commonPrefixes);
            setEncodingType(model.encodingType);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getKeyMarker() {
            return keyMarker;
        }

        @Override
        public final Builder keyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
            return this;
        }

        public final void setKeyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
        }

        public final String getVersionIdMarker() {
            return versionIdMarker;
        }

        @Override
        public final Builder versionIdMarker(String versionIdMarker) {
            this.versionIdMarker = versionIdMarker;
            return this;
        }

        public final void setVersionIdMarker(String versionIdMarker) {
            this.versionIdMarker = versionIdMarker;
        }

        public final String getNextKeyMarker() {
            return nextKeyMarker;
        }

        @Override
        public final Builder nextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
            return this;
        }

        public final void setNextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
        }

        public final String getNextVersionIdMarker() {
            return nextVersionIdMarker;
        }

        @Override
        public final Builder nextVersionIdMarker(String nextVersionIdMarker) {
            this.nextVersionIdMarker = nextVersionIdMarker;
            return this;
        }

        public final void setNextVersionIdMarker(String nextVersionIdMarker) {
            this.nextVersionIdMarker = nextVersionIdMarker;
        }

        public final Collection<ObjectVersion> getVersions() {
            return versions;
        }

        @Override
        public final Builder versions(Collection<ObjectVersion> versions) {
            this.versions = ObjectVersionListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(ObjectVersion... versions) {
            versions(Arrays.asList(versions));
            return this;
        }

        public final void setVersions(Collection<ObjectVersion> versions) {
            this.versions = ObjectVersionListCopier.copy(versions);
        }

        public final Collection<DeleteMarkerEntry> getDeleteMarkers() {
            return deleteMarkers;
        }

        @Override
        public final Builder deleteMarkers(Collection<DeleteMarkerEntry> deleteMarkers) {
            this.deleteMarkers = DeleteMarkersCopier.copy(deleteMarkers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteMarkers(DeleteMarkerEntry... deleteMarkers) {
            deleteMarkers(Arrays.asList(deleteMarkers));
            return this;
        }

        public final void setDeleteMarkers(Collection<DeleteMarkerEntry> deleteMarkers) {
            this.deleteMarkers = DeleteMarkersCopier.copy(deleteMarkers);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getDelimiter() {
            return delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final Integer getMaxKeys() {
            return maxKeys;
        }

        @Override
        public final Builder maxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        public final void setMaxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
        }

        public final Collection<CommonPrefix> getCommonPrefixes() {
            return commonPrefixes;
        }

        @Override
        public final Builder commonPrefixes(Collection<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copy(commonPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonPrefixes(CommonPrefix... commonPrefixes) {
            commonPrefixes(Arrays.asList(commonPrefixes));
            return this;
        }

        public final void setCommonPrefixes(Collection<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copy(commonPrefixes);
        }

        public final String getEncodingType() {
            return encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        @Override
        public ListObjectVersionsResponse build() {
            return new ListObjectVersionsResponse(this);
        }
    }
}
