/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListObjectVersionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListObjectVersionsRequest.Builder, ListObjectVersionsRequest> {
    private final String bucket;

    private final String delimiter;

    private final String encodingType;

    private final String keyMarker;

    private final Integer maxKeys;

    private final String prefix;

    private final String versionIdMarker;

    private ListObjectVersionsRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.delimiter = builder.delimiter;
        this.encodingType = builder.encodingType;
        this.keyMarker = builder.keyMarker;
        this.maxKeys = builder.maxKeys;
        this.prefix = builder.prefix;
        this.versionIdMarker = builder.versionIdMarker;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * A delimiter is a character you use to group keys.
     * 
     * @return A delimiter is a character you use to group keys.
     */
    public String delimiter() {
        return delimiter;
    }

    /**
     * Returns the value of the EncodingType property for this object.
     * 
     * @return The value of the EncodingType property for this object.
     * @see EncodingType
     */
    public String encodingType() {
        return encodingType;
    }

    /**
     * Specifies the key to start with when listing objects in a bucket.
     * 
     * @return Specifies the key to start with when listing objects in a bucket.
     */
    public String keyMarker() {
        return keyMarker;
    }

    /**
     * Sets the maximum number of keys returned in the response. The response might contain fewer keys but will never
     * contain more.
     * 
     * @return Sets the maximum number of keys returned in the response. The response might contain fewer keys but will
     *         never contain more.
     */
    public Integer maxKeys() {
        return maxKeys;
    }

    /**
     * Limits the response to keys that begin with the specified prefix.
     * 
     * @return Limits the response to keys that begin with the specified prefix.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * Specifies the object version you want to start listing from.
     * 
     * @return Specifies the object version you want to start listing from.
     */
    public String versionIdMarker() {
        return versionIdMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((delimiter() == null) ? 0 : delimiter().hashCode());
        hashCode = 31 * hashCode + ((encodingType() == null) ? 0 : encodingType().hashCode());
        hashCode = 31 * hashCode + ((keyMarker() == null) ? 0 : keyMarker().hashCode());
        hashCode = 31 * hashCode + ((maxKeys() == null) ? 0 : maxKeys().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((versionIdMarker() == null) ? 0 : versionIdMarker().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectVersionsRequest)) {
            return false;
        }
        ListObjectVersionsRequest other = (ListObjectVersionsRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.delimiter() == null ^ this.delimiter() == null) {
            return false;
        }
        if (other.delimiter() != null && !other.delimiter().equals(this.delimiter())) {
            return false;
        }
        if (other.encodingType() == null ^ this.encodingType() == null) {
            return false;
        }
        if (other.encodingType() != null && !other.encodingType().equals(this.encodingType())) {
            return false;
        }
        if (other.keyMarker() == null ^ this.keyMarker() == null) {
            return false;
        }
        if (other.keyMarker() != null && !other.keyMarker().equals(this.keyMarker())) {
            return false;
        }
        if (other.maxKeys() == null ^ this.maxKeys() == null) {
            return false;
        }
        if (other.maxKeys() != null && !other.maxKeys().equals(this.maxKeys())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.versionIdMarker() == null ^ this.versionIdMarker() == null) {
            return false;
        }
        if (other.versionIdMarker() != null && !other.versionIdMarker().equals(this.versionIdMarker())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (delimiter() != null) {
            sb.append("Delimiter: ").append(delimiter()).append(",");
        }
        if (encodingType() != null) {
            sb.append("EncodingType: ").append(encodingType()).append(",");
        }
        if (keyMarker() != null) {
            sb.append("KeyMarker: ").append(keyMarker()).append(",");
        }
        if (maxKeys() != null) {
            sb.append("MaxKeys: ").append(maxKeys()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (versionIdMarker() != null) {
            sb.append("VersionIdMarker: ").append(versionIdMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListObjectVersionsRequest> {
        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * A delimiter is a character you use to group keys.
         * 
         * @param delimiter
         *        A delimiter is a character you use to group keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimiter(String delimiter);

        /**
         * Sets the value of the EncodingType property for this object.
         *
         * @param encodingType
         *        The new value for the EncodingType property for this object.
         * @see EncodingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(String encodingType);

        /**
         * Sets the value of the EncodingType property for this object.
         *
         * @param encodingType
         *        The new value for the EncodingType property for this object.
         * @see EncodingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(EncodingType encodingType);

        /**
         * Specifies the key to start with when listing objects in a bucket.
         * 
         * @param keyMarker
         *        Specifies the key to start with when listing objects in a bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyMarker(String keyMarker);

        /**
         * Sets the maximum number of keys returned in the response. The response might contain fewer keys but will
         * never contain more.
         * 
         * @param maxKeys
         *        Sets the maximum number of keys returned in the response. The response might contain fewer keys but
         *        will never contain more.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxKeys(Integer maxKeys);

        /**
         * Limits the response to keys that begin with the specified prefix.
         * 
         * @param prefix
         *        Limits the response to keys that begin with the specified prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * Specifies the object version you want to start listing from.
         * 
         * @param versionIdMarker
         *        Specifies the object version you want to start listing from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionIdMarker(String versionIdMarker);
    }

    private static final class BuilderImpl implements Builder {
        private String bucket;

        private String delimiter;

        private String encodingType;

        private String keyMarker;

        private Integer maxKeys;

        private String prefix;

        private String versionIdMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectVersionsRequest model) {
            setBucket(model.bucket);
            setDelimiter(model.delimiter);
            setEncodingType(model.encodingType);
            setKeyMarker(model.keyMarker);
            setMaxKeys(model.maxKeys);
            setPrefix(model.prefix);
            setVersionIdMarker(model.versionIdMarker);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getDelimiter() {
            return delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final String getEncodingType() {
            return encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        public final String getKeyMarker() {
            return keyMarker;
        }

        @Override
        public final Builder keyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
            return this;
        }

        public final void setKeyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
        }

        public final Integer getMaxKeys() {
            return maxKeys;
        }

        @Override
        public final Builder maxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        public final void setMaxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getVersionIdMarker() {
            return versionIdMarker;
        }

        @Override
        public final Builder versionIdMarker(String versionIdMarker) {
            this.versionIdMarker = versionIdMarker;
            return this;
        }

        public final void setVersionIdMarker(String versionIdMarker) {
            this.versionIdMarker = versionIdMarker;
        }

        @Override
        public ListObjectVersionsRequest build() {
            return new ListObjectVersionsRequest(this);
        }
    }
}
