/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListMultipartUploadsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListMultipartUploadsRequest.Builder, ListMultipartUploadsRequest> {
    private final String bucket;

    private final String delimiter;

    private final String encodingType;

    private final String keyMarker;

    private final Integer maxUploads;

    private final String prefix;

    private final String uploadIdMarker;

    private ListMultipartUploadsRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.delimiter = builder.delimiter;
        this.encodingType = builder.encodingType;
        this.keyMarker = builder.keyMarker;
        this.maxUploads = builder.maxUploads;
        this.prefix = builder.prefix;
        this.uploadIdMarker = builder.uploadIdMarker;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Character you use to group keys.
     * 
     * @return Character you use to group keys.
     */
    public String delimiter() {
        return delimiter;
    }

    /**
     * Returns the value of the EncodingType property for this object.
     * 
     * @return The value of the EncodingType property for this object.
     * @see EncodingType
     */
    public String encodingType() {
        return encodingType;
    }

    /**
     * Together with upload-id-marker, this parameter specifies the multipart upload after which listing should begin.
     * 
     * @return Together with upload-id-marker, this parameter specifies the multipart upload after which listing should
     *         begin.
     */
    public String keyMarker() {
        return keyMarker;
    }

    /**
     * Sets the maximum number of multipart uploads, from 1 to 1,000, to return in the response body. 1,000 is the
     * maximum number of uploads that can be returned in a response.
     * 
     * @return Sets the maximum number of multipart uploads, from 1 to 1,000, to return in the response body. 1,000 is
     *         the maximum number of uploads that can be returned in a response.
     */
    public Integer maxUploads() {
        return maxUploads;
    }

    /**
     * Lists in-progress uploads only for those keys that begin with the specified prefix.
     * 
     * @return Lists in-progress uploads only for those keys that begin with the specified prefix.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * Together with key-marker, specifies the multipart upload after which listing should begin. If key-marker is not
     * specified, the upload-id-marker parameter is ignored.
     * 
     * @return Together with key-marker, specifies the multipart upload after which listing should begin. If key-marker
     *         is not specified, the upload-id-marker parameter is ignored.
     */
    public String uploadIdMarker() {
        return uploadIdMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((delimiter() == null) ? 0 : delimiter().hashCode());
        hashCode = 31 * hashCode + ((encodingType() == null) ? 0 : encodingType().hashCode());
        hashCode = 31 * hashCode + ((keyMarker() == null) ? 0 : keyMarker().hashCode());
        hashCode = 31 * hashCode + ((maxUploads() == null) ? 0 : maxUploads().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((uploadIdMarker() == null) ? 0 : uploadIdMarker().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultipartUploadsRequest)) {
            return false;
        }
        ListMultipartUploadsRequest other = (ListMultipartUploadsRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.delimiter() == null ^ this.delimiter() == null) {
            return false;
        }
        if (other.delimiter() != null && !other.delimiter().equals(this.delimiter())) {
            return false;
        }
        if (other.encodingType() == null ^ this.encodingType() == null) {
            return false;
        }
        if (other.encodingType() != null && !other.encodingType().equals(this.encodingType())) {
            return false;
        }
        if (other.keyMarker() == null ^ this.keyMarker() == null) {
            return false;
        }
        if (other.keyMarker() != null && !other.keyMarker().equals(this.keyMarker())) {
            return false;
        }
        if (other.maxUploads() == null ^ this.maxUploads() == null) {
            return false;
        }
        if (other.maxUploads() != null && !other.maxUploads().equals(this.maxUploads())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.uploadIdMarker() == null ^ this.uploadIdMarker() == null) {
            return false;
        }
        if (other.uploadIdMarker() != null && !other.uploadIdMarker().equals(this.uploadIdMarker())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (delimiter() != null) {
            sb.append("Delimiter: ").append(delimiter()).append(",");
        }
        if (encodingType() != null) {
            sb.append("EncodingType: ").append(encodingType()).append(",");
        }
        if (keyMarker() != null) {
            sb.append("KeyMarker: ").append(keyMarker()).append(",");
        }
        if (maxUploads() != null) {
            sb.append("MaxUploads: ").append(maxUploads()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (uploadIdMarker() != null) {
            sb.append("UploadIdMarker: ").append(uploadIdMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListMultipartUploadsRequest> {
        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Character you use to group keys.
         * 
         * @param delimiter
         *        Character you use to group keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimiter(String delimiter);

        /**
         * Sets the value of the EncodingType property for this object.
         *
         * @param encodingType
         *        The new value for the EncodingType property for this object.
         * @see EncodingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(String encodingType);

        /**
         * Sets the value of the EncodingType property for this object.
         *
         * @param encodingType
         *        The new value for the EncodingType property for this object.
         * @see EncodingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(EncodingType encodingType);

        /**
         * Together with upload-id-marker, this parameter specifies the multipart upload after which listing should
         * begin.
         * 
         * @param keyMarker
         *        Together with upload-id-marker, this parameter specifies the multipart upload after which listing
         *        should begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyMarker(String keyMarker);

        /**
         * Sets the maximum number of multipart uploads, from 1 to 1,000, to return in the response body. 1,000 is the
         * maximum number of uploads that can be returned in a response.
         * 
         * @param maxUploads
         *        Sets the maximum number of multipart uploads, from 1 to 1,000, to return in the response body. 1,000
         *        is the maximum number of uploads that can be returned in a response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUploads(Integer maxUploads);

        /**
         * Lists in-progress uploads only for those keys that begin with the specified prefix.
         * 
         * @param prefix
         *        Lists in-progress uploads only for those keys that begin with the specified prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * Together with key-marker, specifies the multipart upload after which listing should begin. If key-marker is
         * not specified, the upload-id-marker parameter is ignored.
         * 
         * @param uploadIdMarker
         *        Together with key-marker, specifies the multipart upload after which listing should begin. If
         *        key-marker is not specified, the upload-id-marker parameter is ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadIdMarker(String uploadIdMarker);
    }

    private static final class BuilderImpl implements Builder {
        private String bucket;

        private String delimiter;

        private String encodingType;

        private String keyMarker;

        private Integer maxUploads;

        private String prefix;

        private String uploadIdMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultipartUploadsRequest model) {
            setBucket(model.bucket);
            setDelimiter(model.delimiter);
            setEncodingType(model.encodingType);
            setKeyMarker(model.keyMarker);
            setMaxUploads(model.maxUploads);
            setPrefix(model.prefix);
            setUploadIdMarker(model.uploadIdMarker);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getDelimiter() {
            return delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final String getEncodingType() {
            return encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        public final String getKeyMarker() {
            return keyMarker;
        }

        @Override
        public final Builder keyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
            return this;
        }

        public final void setKeyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
        }

        public final Integer getMaxUploads() {
            return maxUploads;
        }

        @Override
        public final Builder maxUploads(Integer maxUploads) {
            this.maxUploads = maxUploads;
            return this;
        }

        public final void setMaxUploads(Integer maxUploads) {
            this.maxUploads = maxUploads;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getUploadIdMarker() {
            return uploadIdMarker;
        }

        @Override
        public final Builder uploadIdMarker(String uploadIdMarker) {
            this.uploadIdMarker = uploadIdMarker;
            return this;
        }

        public final void setUploadIdMarker(String uploadIdMarker) {
            this.uploadIdMarker = uploadIdMarker;
        }

        @Override
        public ListMultipartUploadsRequest build() {
            return new ListMultipartUploadsRequest(this);
        }
    }
}
