/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListBucketsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListBucketsResponse.Builder, ListBucketsResponse> {
    private final List<Bucket> buckets;

    private final Owner owner;

    private ListBucketsResponse(BuilderImpl builder) {
        this.buckets = builder.buckets;
        this.owner = builder.owner;
    }

    /**
     * Returns the value of the Buckets property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Buckets property for this object.
     */
    public List<Bucket> buckets() {
        return buckets;
    }

    /**
     * Returns the value of the Owner property for this object.
     * 
     * @return The value of the Owner property for this object.
     */
    public Owner owner() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((buckets() == null) ? 0 : buckets().hashCode());
        hashCode = 31 * hashCode + ((owner() == null) ? 0 : owner().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketsResponse)) {
            return false;
        }
        ListBucketsResponse other = (ListBucketsResponse) obj;
        if (other.buckets() == null ^ this.buckets() == null) {
            return false;
        }
        if (other.buckets() != null && !other.buckets().equals(this.buckets())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (buckets() != null) {
            sb.append("Buckets: ").append(buckets()).append(",");
        }
        if (owner() != null) {
            sb.append("Owner: ").append(owner()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListBucketsResponse> {
        /**
         * Sets the value of the Buckets property for this object.
         *
         * @param buckets
         *        The new value for the Buckets property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buckets(Collection<Bucket> buckets);

        /**
         * Sets the value of the Buckets property for this object.
         *
         * @param buckets
         *        The new value for the Buckets property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buckets(Bucket... buckets);

        /**
         * Sets the value of the Owner property for this object.
         *
         * @param owner
         *        The new value for the Owner property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(Owner owner);
    }

    private static final class BuilderImpl implements Builder {
        private List<Bucket> buckets;

        private Owner owner;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketsResponse model) {
            setBuckets(model.buckets);
            setOwner(model.owner);
        }

        public final Collection<Bucket> getBuckets() {
            return buckets;
        }

        @Override
        public final Builder buckets(Collection<Bucket> buckets) {
            this.buckets = BucketsCopier.copy(buckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Bucket... buckets) {
            buckets(Arrays.asList(buckets));
            return this;
        }

        public final void setBuckets(Collection<Bucket> buckets) {
            this.buckets = BucketsCopier.copy(buckets);
        }

        public final Owner getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner owner) {
            this.owner = owner;
        }

        @Override
        public ListBucketsResponse build() {
            return new ListBucketsResponse(this);
        }
    }
}
