/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListBucketInventoryConfigurationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListBucketInventoryConfigurationsResponse.Builder, ListBucketInventoryConfigurationsResponse> {
    private final String continuationToken;

    private final List<InventoryConfiguration> inventoryConfigurationList;

    private final Boolean isTruncated;

    private final String nextContinuationToken;

    private ListBucketInventoryConfigurationsResponse(BuilderImpl builder) {
        this.continuationToken = builder.continuationToken;
        this.inventoryConfigurationList = builder.inventoryConfigurationList;
        this.isTruncated = builder.isTruncated;
        this.nextContinuationToken = builder.nextContinuationToken;
    }

    /**
     * If sent in the request, the marker that is used as a starting point for this inventory configuration list
     * response.
     * 
     * @return If sent in the request, the marker that is used as a starting point for this inventory configuration list
     *         response.
     */
    public String continuationToken() {
        return continuationToken;
    }

    /**
     * The list of inventory configurations for a bucket.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of inventory configurations for a bucket.
     */
    public List<InventoryConfiguration> inventoryConfigurationList() {
        return inventoryConfigurationList;
    }

    /**
     * Indicates whether the returned list of inventory configurations is truncated in this response. A value of true
     * indicates that the list is truncated.
     * 
     * @return Indicates whether the returned list of inventory configurations is truncated in this response. A value of
     *         true indicates that the list is truncated.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * The marker used to continue this inventory configuration listing. Use the NextContinuationToken from this
     * response to continue the listing in a subsequent request. The continuation token is an opaque value that Amazon
     * S3 understands.
     * 
     * @return The marker used to continue this inventory configuration listing. Use the NextContinuationToken from this
     *         response to continue the listing in a subsequent request. The continuation token is an opaque value that
     *         Amazon S3 understands.
     */
    public String nextContinuationToken() {
        return nextContinuationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((continuationToken() == null) ? 0 : continuationToken().hashCode());
        hashCode = 31 * hashCode + ((inventoryConfigurationList() == null) ? 0 : inventoryConfigurationList().hashCode());
        hashCode = 31 * hashCode + ((isTruncated() == null) ? 0 : isTruncated().hashCode());
        hashCode = 31 * hashCode + ((nextContinuationToken() == null) ? 0 : nextContinuationToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketInventoryConfigurationsResponse)) {
            return false;
        }
        ListBucketInventoryConfigurationsResponse other = (ListBucketInventoryConfigurationsResponse) obj;
        if (other.continuationToken() == null ^ this.continuationToken() == null) {
            return false;
        }
        if (other.continuationToken() != null && !other.continuationToken().equals(this.continuationToken())) {
            return false;
        }
        if (other.inventoryConfigurationList() == null ^ this.inventoryConfigurationList() == null) {
            return false;
        }
        if (other.inventoryConfigurationList() != null
                && !other.inventoryConfigurationList().equals(this.inventoryConfigurationList())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.nextContinuationToken() == null ^ this.nextContinuationToken() == null) {
            return false;
        }
        if (other.nextContinuationToken() != null && !other.nextContinuationToken().equals(this.nextContinuationToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (continuationToken() != null) {
            sb.append("ContinuationToken: ").append(continuationToken()).append(",");
        }
        if (inventoryConfigurationList() != null) {
            sb.append("InventoryConfigurationList: ").append(inventoryConfigurationList()).append(",");
        }
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (nextContinuationToken() != null) {
            sb.append("NextContinuationToken: ").append(nextContinuationToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListBucketInventoryConfigurationsResponse> {
        /**
         * If sent in the request, the marker that is used as a starting point for this inventory configuration list
         * response.
         * 
         * @param continuationToken
         *        If sent in the request, the marker that is used as a starting point for this inventory configuration
         *        list response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);

        /**
         * The list of inventory configurations for a bucket.
         * 
         * @param inventoryConfigurationList
         *        The list of inventory configurations for a bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inventoryConfigurationList(Collection<InventoryConfiguration> inventoryConfigurationList);

        /**
         * The list of inventory configurations for a bucket.
         * 
         * @param inventoryConfigurationList
         *        The list of inventory configurations for a bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inventoryConfigurationList(InventoryConfiguration... inventoryConfigurationList);

        /**
         * Indicates whether the returned list of inventory configurations is truncated in this response. A value of
         * true indicates that the list is truncated.
         * 
         * @param isTruncated
         *        Indicates whether the returned list of inventory configurations is truncated in this response. A value
         *        of true indicates that the list is truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * The marker used to continue this inventory configuration listing. Use the NextContinuationToken from this
         * response to continue the listing in a subsequent request. The continuation token is an opaque value that
         * Amazon S3 understands.
         * 
         * @param nextContinuationToken
         *        The marker used to continue this inventory configuration listing. Use the NextContinuationToken from
         *        this response to continue the listing in a subsequent request. The continuation token is an opaque
         *        value that Amazon S3 understands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextContinuationToken(String nextContinuationToken);
    }

    private static final class BuilderImpl implements Builder {
        private String continuationToken;

        private List<InventoryConfiguration> inventoryConfigurationList;

        private Boolean isTruncated;

        private String nextContinuationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketInventoryConfigurationsResponse model) {
            setContinuationToken(model.continuationToken);
            setInventoryConfigurationList(model.inventoryConfigurationList);
            setIsTruncated(model.isTruncated);
            setNextContinuationToken(model.nextContinuationToken);
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final Collection<InventoryConfiguration> getInventoryConfigurationList() {
            return inventoryConfigurationList;
        }

        @Override
        public final Builder inventoryConfigurationList(Collection<InventoryConfiguration> inventoryConfigurationList) {
            this.inventoryConfigurationList = InventoryConfigurationListCopier.copy(inventoryConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inventoryConfigurationList(InventoryConfiguration... inventoryConfigurationList) {
            inventoryConfigurationList(Arrays.asList(inventoryConfigurationList));
            return this;
        }

        public final void setInventoryConfigurationList(Collection<InventoryConfiguration> inventoryConfigurationList) {
            this.inventoryConfigurationList = InventoryConfigurationListCopier.copy(inventoryConfigurationList);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextContinuationToken() {
            return nextContinuationToken;
        }

        @Override
        public final Builder nextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
            return this;
        }

        public final void setNextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
        }

        @Override
        public ListBucketInventoryConfigurationsResponse build() {
            return new ListBucketInventoryConfigurationsResponse(this);
        }
    }
}
