/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListBucketAnalyticsConfigurationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListBucketAnalyticsConfigurationsResponse.Builder, ListBucketAnalyticsConfigurationsResponse> {
    private final Boolean isTruncated;

    private final String continuationToken;

    private final String nextContinuationToken;

    private final List<AnalyticsConfiguration> analyticsConfigurationList;

    private ListBucketAnalyticsConfigurationsResponse(BuilderImpl builder) {
        this.isTruncated = builder.isTruncated;
        this.continuationToken = builder.continuationToken;
        this.nextContinuationToken = builder.nextContinuationToken;
        this.analyticsConfigurationList = builder.analyticsConfigurationList;
    }

    /**
     * Indicates whether the returned list of analytics configurations is complete. A value of true indicates that the
     * list is not complete and the NextContinuationToken will be provided for a subsequent request.
     * 
     * @return Indicates whether the returned list of analytics configurations is complete. A value of true indicates
     *         that the list is not complete and the NextContinuationToken will be provided for a subsequent request.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * The ContinuationToken that represents where this request began.
     * 
     * @return The ContinuationToken that represents where this request began.
     */
    public String continuationToken() {
        return continuationToken;
    }

    /**
     * NextContinuationToken is sent when isTruncated is true, which indicates that there are more analytics
     * configurations to list. The next request must include this NextContinuationToken. The token is obfuscated and is
     * not a usable value.
     * 
     * @return NextContinuationToken is sent when isTruncated is true, which indicates that there are more analytics
     *         configurations to list. The next request must include this NextContinuationToken. The token is obfuscated
     *         and is not a usable value.
     */
    public String nextContinuationToken() {
        return nextContinuationToken;
    }

    /**
     * The list of analytics configurations for a bucket.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of analytics configurations for a bucket.
     */
    public List<AnalyticsConfiguration> analyticsConfigurationList() {
        return analyticsConfigurationList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((isTruncated() == null) ? 0 : isTruncated().hashCode());
        hashCode = 31 * hashCode + ((continuationToken() == null) ? 0 : continuationToken().hashCode());
        hashCode = 31 * hashCode + ((nextContinuationToken() == null) ? 0 : nextContinuationToken().hashCode());
        hashCode = 31 * hashCode + ((analyticsConfigurationList() == null) ? 0 : analyticsConfigurationList().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketAnalyticsConfigurationsResponse)) {
            return false;
        }
        ListBucketAnalyticsConfigurationsResponse other = (ListBucketAnalyticsConfigurationsResponse) obj;
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.continuationToken() == null ^ this.continuationToken() == null) {
            return false;
        }
        if (other.continuationToken() != null && !other.continuationToken().equals(this.continuationToken())) {
            return false;
        }
        if (other.nextContinuationToken() == null ^ this.nextContinuationToken() == null) {
            return false;
        }
        if (other.nextContinuationToken() != null && !other.nextContinuationToken().equals(this.nextContinuationToken())) {
            return false;
        }
        if (other.analyticsConfigurationList() == null ^ this.analyticsConfigurationList() == null) {
            return false;
        }
        if (other.analyticsConfigurationList() != null
                && !other.analyticsConfigurationList().equals(this.analyticsConfigurationList())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (continuationToken() != null) {
            sb.append("ContinuationToken: ").append(continuationToken()).append(",");
        }
        if (nextContinuationToken() != null) {
            sb.append("NextContinuationToken: ").append(nextContinuationToken()).append(",");
        }
        if (analyticsConfigurationList() != null) {
            sb.append("AnalyticsConfigurationList: ").append(analyticsConfigurationList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListBucketAnalyticsConfigurationsResponse> {
        /**
         * Indicates whether the returned list of analytics configurations is complete. A value of true indicates that
         * the list is not complete and the NextContinuationToken will be provided for a subsequent request.
         * 
         * @param isTruncated
         *        Indicates whether the returned list of analytics configurations is complete. A value of true indicates
         *        that the list is not complete and the NextContinuationToken will be provided for a subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * The ContinuationToken that represents where this request began.
         * 
         * @param continuationToken
         *        The ContinuationToken that represents where this request began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);

        /**
         * NextContinuationToken is sent when isTruncated is true, which indicates that there are more analytics
         * configurations to list. The next request must include this NextContinuationToken. The token is obfuscated and
         * is not a usable value.
         * 
         * @param nextContinuationToken
         *        NextContinuationToken is sent when isTruncated is true, which indicates that there are more analytics
         *        configurations to list. The next request must include this NextContinuationToken. The token is
         *        obfuscated and is not a usable value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextContinuationToken(String nextContinuationToken);

        /**
         * The list of analytics configurations for a bucket.
         * 
         * @param analyticsConfigurationList
         *        The list of analytics configurations for a bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyticsConfigurationList(Collection<AnalyticsConfiguration> analyticsConfigurationList);

        /**
         * The list of analytics configurations for a bucket.
         * 
         * @param analyticsConfigurationList
         *        The list of analytics configurations for a bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyticsConfigurationList(AnalyticsConfiguration... analyticsConfigurationList);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean isTruncated;

        private String continuationToken;

        private String nextContinuationToken;

        private List<AnalyticsConfiguration> analyticsConfigurationList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketAnalyticsConfigurationsResponse model) {
            setIsTruncated(model.isTruncated);
            setContinuationToken(model.continuationToken);
            setNextContinuationToken(model.nextContinuationToken);
            setAnalyticsConfigurationList(model.analyticsConfigurationList);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final String getNextContinuationToken() {
            return nextContinuationToken;
        }

        @Override
        public final Builder nextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
            return this;
        }

        public final void setNextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
        }

        public final Collection<AnalyticsConfiguration> getAnalyticsConfigurationList() {
            return analyticsConfigurationList;
        }

        @Override
        public final Builder analyticsConfigurationList(Collection<AnalyticsConfiguration> analyticsConfigurationList) {
            this.analyticsConfigurationList = AnalyticsConfigurationListCopier.copy(analyticsConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyticsConfigurationList(AnalyticsConfiguration... analyticsConfigurationList) {
            analyticsConfigurationList(Arrays.asList(analyticsConfigurationList));
            return this;
        }

        public final void setAnalyticsConfigurationList(Collection<AnalyticsConfiguration> analyticsConfigurationList) {
            this.analyticsConfigurationList = AnalyticsConfigurationListCopier.copy(analyticsConfigurationList);
        }

        @Override
        public ListBucketAnalyticsConfigurationsResponse build() {
            return new ListBucketAnalyticsConfigurationsResponse(this);
        }
    }
}
