/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class LifecycleExpiration implements ToCopyableBuilder<LifecycleExpiration.Builder, LifecycleExpiration> {
    private final Instant dateValue;

    private final Integer days;

    private final Boolean expiredObjectDeleteMarker;

    private LifecycleExpiration(BuilderImpl builder) {
        this.dateValue = builder.dateValue;
        this.days = builder.days;
        this.expiredObjectDeleteMarker = builder.expiredObjectDeleteMarker;
    }

    /**
     * Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.
     * 
     * @return Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.
     */
    public Instant date() {
        return dateValue;
    }

    /**
     * Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero
     * positive integer.
     * 
     * @return Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a
     *         non-zero positive integer.
     */
    public Integer days() {
        return days;
    }

    /**
     * Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete
     * marker will be expired; if set to false the policy takes no action. This cannot be specified with Days or Date in
     * a Lifecycle Expiration Policy.
     * 
     * @return Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the
     *         delete marker will be expired; if set to false the policy takes no action. This cannot be specified with
     *         Days or Date in a Lifecycle Expiration Policy.
     */
    public Boolean expiredObjectDeleteMarker() {
        return expiredObjectDeleteMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((date() == null) ? 0 : date().hashCode());
        hashCode = 31 * hashCode + ((days() == null) ? 0 : days().hashCode());
        hashCode = 31 * hashCode + ((expiredObjectDeleteMarker() == null) ? 0 : expiredObjectDeleteMarker().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleExpiration)) {
            return false;
        }
        LifecycleExpiration other = (LifecycleExpiration) obj;
        if (other.date() == null ^ this.date() == null) {
            return false;
        }
        if (other.date() != null && !other.date().equals(this.date())) {
            return false;
        }
        if (other.days() == null ^ this.days() == null) {
            return false;
        }
        if (other.days() != null && !other.days().equals(this.days())) {
            return false;
        }
        if (other.expiredObjectDeleteMarker() == null ^ this.expiredObjectDeleteMarker() == null) {
            return false;
        }
        if (other.expiredObjectDeleteMarker() != null
                && !other.expiredObjectDeleteMarker().equals(this.expiredObjectDeleteMarker())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (date() != null) {
            sb.append("Date: ").append(date()).append(",");
        }
        if (days() != null) {
            sb.append("Days: ").append(days()).append(",");
        }
        if (expiredObjectDeleteMarker() != null) {
            sb.append("ExpiredObjectDeleteMarker: ").append(expiredObjectDeleteMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, LifecycleExpiration> {
        /**
         * Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.
         * 
         * @param dateValue
         *        Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(Instant dateValue);

        /**
         * Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero
         * positive integer.
         * 
         * @param days
         *        Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a
         *        non-zero positive integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder days(Integer days);

        /**
         * Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the
         * delete marker will be expired; if set to false the policy takes no action. This cannot be specified with Days
         * or Date in a Lifecycle Expiration Policy.
         * 
         * @param expiredObjectDeleteMarker
         *        Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true,
         *        the delete marker will be expired; if set to false the policy takes no action. This cannot be
         *        specified with Days or Date in a Lifecycle Expiration Policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiredObjectDeleteMarker(Boolean expiredObjectDeleteMarker);
    }

    private static final class BuilderImpl implements Builder {
        private Instant dateValue;

        private Integer days;

        private Boolean expiredObjectDeleteMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleExpiration model) {
            setDate(model.dateValue);
            setDays(model.days);
            setExpiredObjectDeleteMarker(model.expiredObjectDeleteMarker);
        }

        public final Instant getDate() {
            return dateValue;
        }

        @Override
        public final Builder date(Instant dateValue) {
            this.dateValue = dateValue;
            return this;
        }

        public final void setDate(Instant dateValue) {
            this.dateValue = dateValue;
        }

        public final Integer getDays() {
            return days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        public final Boolean getExpiredObjectDeleteMarker() {
            return expiredObjectDeleteMarker;
        }

        @Override
        public final Builder expiredObjectDeleteMarker(Boolean expiredObjectDeleteMarker) {
            this.expiredObjectDeleteMarker = expiredObjectDeleteMarker;
            return this;
        }

        public final void setExpiredObjectDeleteMarker(Boolean expiredObjectDeleteMarker) {
            this.expiredObjectDeleteMarker = expiredObjectDeleteMarker;
        }

        @Override
        public LifecycleExpiration build() {
            return new LifecycleExpiration(this);
        }
    }
}
