/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class Grantee implements ToCopyableBuilder<Grantee.Builder, Grantee> {
    private final String displayName;

    private final String emailAddress;

    private final String id;

    private final String type;

    private final String uri;

    private Grantee(BuilderImpl builder) {
        this.displayName = builder.displayName;
        this.emailAddress = builder.emailAddress;
        this.id = builder.id;
        this.type = builder.type;
        this.uri = builder.uri;
    }

    /**
     * Screen name of the grantee.
     * 
     * @return Screen name of the grantee.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * Email address of the grantee.
     * 
     * @return Email address of the grantee.
     */
    public String emailAddress() {
        return emailAddress;
    }

    /**
     * The canonical user ID of the grantee.
     * 
     * @return The canonical user ID of the grantee.
     */
    public String id() {
        return id;
    }

    /**
     * Type of grantee
     * 
     * @return Type of grantee
     * @see Type
     */
    public String type() {
        return type;
    }

    /**
     * URI of the grantee group.
     * 
     * @return URI of the grantee group.
     */
    public String uri() {
        return uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((displayName() == null) ? 0 : displayName().hashCode());
        hashCode = 31 * hashCode + ((emailAddress() == null) ? 0 : emailAddress().hashCode());
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((uri() == null) ? 0 : uri().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Grantee)) {
            return false;
        }
        Grantee other = (Grantee) obj;
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.emailAddress() == null ^ this.emailAddress() == null) {
            return false;
        }
        if (other.emailAddress() != null && !other.emailAddress().equals(this.emailAddress())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.uri() == null ^ this.uri() == null) {
            return false;
        }
        if (other.uri() != null && !other.uri().equals(this.uri())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (displayName() != null) {
            sb.append("DisplayName: ").append(displayName()).append(",");
        }
        if (emailAddress() != null) {
            sb.append("EmailAddress: ").append(emailAddress()).append(",");
        }
        if (id() != null) {
            sb.append("ID: ").append(id()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (uri() != null) {
            sb.append("URI: ").append(uri()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Grantee> {
        /**
         * Screen name of the grantee.
         * 
         * @param displayName
         *        Screen name of the grantee.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * Email address of the grantee.
         * 
         * @param emailAddress
         *        Email address of the grantee.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * The canonical user ID of the grantee.
         * 
         * @param id
         *        The canonical user ID of the grantee.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Type of grantee
         * 
         * @param type
         *        Type of grantee
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * Type of grantee
         * 
         * @param type
         *        Type of grantee
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        /**
         * URI of the grantee group.
         * 
         * @param uri
         *        URI of the grantee group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);
    }

    private static final class BuilderImpl implements Builder {
        private String displayName;

        private String emailAddress;

        private String id;

        private String type;

        private String uri;

        private BuilderImpl() {
        }

        private BuilderImpl(Grantee model) {
            setDisplayName(model.displayName);
            setEmailAddress(model.emailAddress);
            setID(model.id);
            setType(model.type);
            setURI(model.uri);
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getID() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getURI() {
            return uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setURI(String uri) {
            this.uri = uri;
        }

        @Override
        public Grantee build() {
            return new Grantee(this);
        }
    }
}
