/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBucketReplicationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBucketReplicationResponse.Builder, GetBucketReplicationResponse> {
    private final ReplicationConfiguration replicationConfiguration;

    private GetBucketReplicationResponse(BuilderImpl builder) {
        this.replicationConfiguration = builder.replicationConfiguration;
    }

    /**
     * Returns the value of the ReplicationConfiguration property for this object.
     * 
     * @return The value of the ReplicationConfiguration property for this object.
     */
    public ReplicationConfiguration replicationConfiguration() {
        return replicationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((replicationConfiguration() == null) ? 0 : replicationConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketReplicationResponse)) {
            return false;
        }
        GetBucketReplicationResponse other = (GetBucketReplicationResponse) obj;
        if (other.replicationConfiguration() == null ^ this.replicationConfiguration() == null) {
            return false;
        }
        if (other.replicationConfiguration() != null && !other.replicationConfiguration().equals(this.replicationConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (replicationConfiguration() != null) {
            sb.append("ReplicationConfiguration: ").append(replicationConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetBucketReplicationResponse> {
        /**
         * Sets the value of the ReplicationConfiguration property for this object.
         *
         * @param replicationConfiguration
         *        The new value for the ReplicationConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfiguration(ReplicationConfiguration replicationConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private ReplicationConfiguration replicationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketReplicationResponse model) {
            setReplicationConfiguration(model.replicationConfiguration);
        }

        public final ReplicationConfiguration getReplicationConfiguration() {
            return replicationConfiguration;
        }

        @Override
        public final Builder replicationConfiguration(ReplicationConfiguration replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration;
            return this;
        }

        public final void setReplicationConfiguration(ReplicationConfiguration replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration;
        }

        @Override
        public GetBucketReplicationResponse build() {
            return new GetBucketReplicationResponse(this);
        }
    }
}
