/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CopyObjectRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CopyObjectRequest.Builder, CopyObjectRequest> {
    private final String acl;

    private final String bucket;

    private final String cacheControl;

    private final String contentDisposition;

    private final String contentEncoding;

    private final String contentLanguage;

    private final String contentType;

    private final String copySource;

    private final String copySourceIfMatch;

    private final Instant copySourceIfModifiedSince;

    private final String copySourceIfNoneMatch;

    private final Instant copySourceIfUnmodifiedSince;

    private final Instant expires;

    private final String grantFullControl;

    private final String grantRead;

    private final String grantReadACP;

    private final String grantWriteACP;

    private final String key;

    private final Map<String, String> metadata;

    private final String metadataDirective;

    private final String taggingDirective;

    private final String serverSideEncryption;

    private final String storageClass;

    private final String websiteRedirectLocation;

    private final String sseCustomerAlgorithm;

    private final String sseCustomerKey;

    private final String sseCustomerKeyMD5;

    private final String ssekmsKeyId;

    private final String copySourceSSECustomerAlgorithm;

    private final String copySourceSSECustomerKey;

    private final String copySourceSSECustomerKeyMD5;

    private final String requestPayer;

    private final String tagging;

    private CopyObjectRequest(BuilderImpl builder) {
        this.acl = builder.acl;
        this.bucket = builder.bucket;
        this.cacheControl = builder.cacheControl;
        this.contentDisposition = builder.contentDisposition;
        this.contentEncoding = builder.contentEncoding;
        this.contentLanguage = builder.contentLanguage;
        this.contentType = builder.contentType;
        this.copySource = builder.copySource;
        this.copySourceIfMatch = builder.copySourceIfMatch;
        this.copySourceIfModifiedSince = builder.copySourceIfModifiedSince;
        this.copySourceIfNoneMatch = builder.copySourceIfNoneMatch;
        this.copySourceIfUnmodifiedSince = builder.copySourceIfUnmodifiedSince;
        this.expires = builder.expires;
        this.grantFullControl = builder.grantFullControl;
        this.grantRead = builder.grantRead;
        this.grantReadACP = builder.grantReadACP;
        this.grantWriteACP = builder.grantWriteACP;
        this.key = builder.key;
        this.metadata = builder.metadata;
        this.metadataDirective = builder.metadataDirective;
        this.taggingDirective = builder.taggingDirective;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.storageClass = builder.storageClass;
        this.websiteRedirectLocation = builder.websiteRedirectLocation;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKey = builder.sseCustomerKey;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.ssekmsKeyId = builder.ssekmsKeyId;
        this.copySourceSSECustomerAlgorithm = builder.copySourceSSECustomerAlgorithm;
        this.copySourceSSECustomerKey = builder.copySourceSSECustomerKey;
        this.copySourceSSECustomerKeyMD5 = builder.copySourceSSECustomerKeyMD5;
        this.requestPayer = builder.requestPayer;
        this.tagging = builder.tagging;
    }

    /**
     * The canned ACL to apply to the object.
     * 
     * @return The canned ACL to apply to the object.
     * @see ObjectCannedACL
     */
    public String acl() {
        return acl;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Specifies caching behavior along the request/reply chain.
     * 
     * @return Specifies caching behavior along the request/reply chain.
     */
    public String cacheControl() {
        return cacheControl;
    }

    /**
     * Specifies presentational information for the object.
     * 
     * @return Specifies presentational information for the object.
     */
    public String contentDisposition() {
        return contentDisposition;
    }

    /**
     * Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be
     * applied to obtain the media-type referenced by the Content-Type header field.
     * 
     * @return Specifies what content encodings have been applied to the object and thus what decoding mechanisms must
     *         be applied to obtain the media-type referenced by the Content-Type header field.
     */
    public String contentEncoding() {
        return contentEncoding;
    }

    /**
     * The language the content is in.
     * 
     * @return The language the content is in.
     */
    public String contentLanguage() {
        return contentLanguage;
    }

    /**
     * A standard MIME type describing the format of the object data.
     * 
     * @return A standard MIME type describing the format of the object data.
     */
    public String contentType() {
        return contentType;
    }

    /**
     * The name of the source bucket and key name of the source object, separated by a slash (/). Must be URL-encoded.
     * 
     * @return The name of the source bucket and key name of the source object, separated by a slash (/). Must be
     *         URL-encoded.
     */
    public String copySource() {
        return copySource;
    }

    /**
     * Copies the object if its entity tag (ETag) matches the specified tag.
     * 
     * @return Copies the object if its entity tag (ETag) matches the specified tag.
     */
    public String copySourceIfMatch() {
        return copySourceIfMatch;
    }

    /**
     * Copies the object if it has been modified since the specified time.
     * 
     * @return Copies the object if it has been modified since the specified time.
     */
    public Instant copySourceIfModifiedSince() {
        return copySourceIfModifiedSince;
    }

    /**
     * Copies the object if its entity tag (ETag) is different than the specified ETag.
     * 
     * @return Copies the object if its entity tag (ETag) is different than the specified ETag.
     */
    public String copySourceIfNoneMatch() {
        return copySourceIfNoneMatch;
    }

    /**
     * Copies the object if it hasn't been modified since the specified time.
     * 
     * @return Copies the object if it hasn't been modified since the specified time.
     */
    public Instant copySourceIfUnmodifiedSince() {
        return copySourceIfUnmodifiedSince;
    }

    /**
     * The date and time at which the object is no longer cacheable.
     * 
     * @return The date and time at which the object is no longer cacheable.
     */
    public Instant expires() {
        return expires;
    }

    /**
     * Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
     * 
     * @return Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
     */
    public String grantFullControl() {
        return grantFullControl;
    }

    /**
     * Allows grantee to read the object data and its metadata.
     * 
     * @return Allows grantee to read the object data and its metadata.
     */
    public String grantRead() {
        return grantRead;
    }

    /**
     * Allows grantee to read the object ACL.
     * 
     * @return Allows grantee to read the object ACL.
     */
    public String grantReadACP() {
        return grantReadACP;
    }

    /**
     * Allows grantee to write the ACL for the applicable object.
     * 
     * @return Allows grantee to write the ACL for the applicable object.
     */
    public String grantWriteACP() {
        return grantWriteACP;
    }

    /**
     * Returns the value of the Key property for this object.
     * 
     * @return The value of the Key property for this object.
     */
    public String key() {
        return key;
    }

    /**
     * A map of metadata to store with the object in S3.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of metadata to store with the object in S3.
     */
    public Map<String, String> metadata() {
        return metadata;
    }

    /**
     * Specifies whether the metadata is copied from the source object or replaced with metadata provided in the
     * request.
     * 
     * @return Specifies whether the metadata is copied from the source object or replaced with metadata provided in the
     *         request.
     * @see MetadataDirective
     */
    public String metadataDirective() {
        return metadataDirective;
    }

    /**
     * Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the
     * request.
     * 
     * @return Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided
     *         in the request.
     * @see TaggingDirective
     */
    public String taggingDirective() {
        return taggingDirective;
    }

    /**
     * The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
     * 
     * @return The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
     * @see ServerSideEncryption
     */
    public String serverSideEncryption() {
        return serverSideEncryption;
    }

    /**
     * The type of storage to use for the object. Defaults to 'STANDARD'.
     * 
     * @return The type of storage to use for the object. Defaults to 'STANDARD'.
     * @see StorageClass
     */
    public String storageClass() {
        return storageClass;
    }

    /**
     * If the bucket is configured as a website, redirects requests for this object to another object in the same bucket
     * or to an external URL. Amazon S3 stores the value of this header in the object metadata.
     * 
     * @return If the bucket is configured as a website, redirects requests for this object to another object in the
     *         same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.
     */
    public String websiteRedirectLocation() {
        return websiteRedirectLocation;
    }

    /**
     * Specifies the algorithm to use to when encrypting the object (e.g., AES256).
     * 
     * @return Specifies the algorithm to use to when encrypting the object (e.g., AES256).
     */
    public String sseCustomerAlgorithm() {
        return sseCustomerAlgorithm;
    }

    /**
     * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to
     * store the object and then it is discarded; Amazon does not store the encryption key. The key must be appropriate
     * for use with the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm header.
     * 
     * @return Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is
     *         used to store the object and then it is discarded; Amazon does not store the encryption key. The key must
     *         be appropriate for use with the algorithm specified in the
     *         x-amz-server-side​-encryption​-customer-algorithm header.
     */
    public String sseCustomerKey() {
        return sseCustomerKey;
    }

    /**
     * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a
     * message integrity check to ensure the encryption key was transmitted without error.
     * 
     * @return Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header
     *         for a message integrity check to ensure the encryption key was transmitted without error.
     */
    public String sseCustomerKeyMD5() {
        return sseCustomerKeyMD5;
    }

    /**
     * Specifies the AWS KMS key ID to use for object encryption. All GET and PUT requests for an object protected by
     * AWS KMS will fail if not made via SSL or using SigV4. Documentation on configuring any of the officially
     * supported AWS SDKs and CLI can be found at
     * http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
     * 
     * @return Specifies the AWS KMS key ID to use for object encryption. All GET and PUT requests for an object
     *         protected by AWS KMS will fail if not made via SSL or using SigV4. Documentation on configuring any of
     *         the officially supported AWS SDKs and CLI can be found at
     *         http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
     */
    public String ssekmsKeyId() {
        return ssekmsKeyId;
    }

    /**
     * Specifies the algorithm to use when decrypting the source object (e.g., AES256).
     * 
     * @return Specifies the algorithm to use when decrypting the source object (e.g., AES256).
     */
    public String copySourceSSECustomerAlgorithm() {
        return copySourceSSECustomerAlgorithm;
    }

    /**
     * Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption
     * key provided in this header must be one that was used when the source object was created.
     * 
     * @return Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The
     *         encryption key provided in this header must be one that was used when the source object was created.
     */
    public String copySourceSSECustomerKey() {
        return copySourceSSECustomerKey;
    }

    /**
     * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a
     * message integrity check to ensure the encryption key was transmitted without error.
     * 
     * @return Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header
     *         for a message integrity check to ensure the encryption key was transmitted without error.
     */
    public String copySourceSSECustomerKeyMD5() {
        return copySourceSSECustomerKeyMD5;
    }

    /**
     * Returns the value of the RequestPayer property for this object.
     * 
     * @return The value of the RequestPayer property for this object.
     * @see RequestPayer
     */
    public String requestPayer() {
        return requestPayer;
    }

    /**
     * The tag-set for the object destination object this value must be used in conjunction with the TaggingDirective.
     * The tag-set must be encoded as URL Query parameters
     * 
     * @return The tag-set for the object destination object this value must be used in conjunction with the
     *         TaggingDirective. The tag-set must be encoded as URL Query parameters
     */
    public String tagging() {
        return tagging;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((acl() == null) ? 0 : acl().hashCode());
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((cacheControl() == null) ? 0 : cacheControl().hashCode());
        hashCode = 31 * hashCode + ((contentDisposition() == null) ? 0 : contentDisposition().hashCode());
        hashCode = 31 * hashCode + ((contentEncoding() == null) ? 0 : contentEncoding().hashCode());
        hashCode = 31 * hashCode + ((contentLanguage() == null) ? 0 : contentLanguage().hashCode());
        hashCode = 31 * hashCode + ((contentType() == null) ? 0 : contentType().hashCode());
        hashCode = 31 * hashCode + ((copySource() == null) ? 0 : copySource().hashCode());
        hashCode = 31 * hashCode + ((copySourceIfMatch() == null) ? 0 : copySourceIfMatch().hashCode());
        hashCode = 31 * hashCode + ((copySourceIfModifiedSince() == null) ? 0 : copySourceIfModifiedSince().hashCode());
        hashCode = 31 * hashCode + ((copySourceIfNoneMatch() == null) ? 0 : copySourceIfNoneMatch().hashCode());
        hashCode = 31 * hashCode + ((copySourceIfUnmodifiedSince() == null) ? 0 : copySourceIfUnmodifiedSince().hashCode());
        hashCode = 31 * hashCode + ((expires() == null) ? 0 : expires().hashCode());
        hashCode = 31 * hashCode + ((grantFullControl() == null) ? 0 : grantFullControl().hashCode());
        hashCode = 31 * hashCode + ((grantRead() == null) ? 0 : grantRead().hashCode());
        hashCode = 31 * hashCode + ((grantReadACP() == null) ? 0 : grantReadACP().hashCode());
        hashCode = 31 * hashCode + ((grantWriteACP() == null) ? 0 : grantWriteACP().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((metadata() == null) ? 0 : metadata().hashCode());
        hashCode = 31 * hashCode + ((metadataDirective() == null) ? 0 : metadataDirective().hashCode());
        hashCode = 31 * hashCode + ((taggingDirective() == null) ? 0 : taggingDirective().hashCode());
        hashCode = 31 * hashCode + ((serverSideEncryption() == null) ? 0 : serverSideEncryption().hashCode());
        hashCode = 31 * hashCode + ((storageClass() == null) ? 0 : storageClass().hashCode());
        hashCode = 31 * hashCode + ((websiteRedirectLocation() == null) ? 0 : websiteRedirectLocation().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerAlgorithm() == null) ? 0 : sseCustomerAlgorithm().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerKey() == null) ? 0 : sseCustomerKey().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerKeyMD5() == null) ? 0 : sseCustomerKeyMD5().hashCode());
        hashCode = 31 * hashCode + ((ssekmsKeyId() == null) ? 0 : ssekmsKeyId().hashCode());
        hashCode = 31 * hashCode + ((copySourceSSECustomerAlgorithm() == null) ? 0 : copySourceSSECustomerAlgorithm().hashCode());
        hashCode = 31 * hashCode + ((copySourceSSECustomerKey() == null) ? 0 : copySourceSSECustomerKey().hashCode());
        hashCode = 31 * hashCode + ((copySourceSSECustomerKeyMD5() == null) ? 0 : copySourceSSECustomerKeyMD5().hashCode());
        hashCode = 31 * hashCode + ((requestPayer() == null) ? 0 : requestPayer().hashCode());
        hashCode = 31 * hashCode + ((tagging() == null) ? 0 : tagging().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyObjectRequest)) {
            return false;
        }
        CopyObjectRequest other = (CopyObjectRequest) obj;
        if (other.acl() == null ^ this.acl() == null) {
            return false;
        }
        if (other.acl() != null && !other.acl().equals(this.acl())) {
            return false;
        }
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.cacheControl() == null ^ this.cacheControl() == null) {
            return false;
        }
        if (other.cacheControl() != null && !other.cacheControl().equals(this.cacheControl())) {
            return false;
        }
        if (other.contentDisposition() == null ^ this.contentDisposition() == null) {
            return false;
        }
        if (other.contentDisposition() != null && !other.contentDisposition().equals(this.contentDisposition())) {
            return false;
        }
        if (other.contentEncoding() == null ^ this.contentEncoding() == null) {
            return false;
        }
        if (other.contentEncoding() != null && !other.contentEncoding().equals(this.contentEncoding())) {
            return false;
        }
        if (other.contentLanguage() == null ^ this.contentLanguage() == null) {
            return false;
        }
        if (other.contentLanguage() != null && !other.contentLanguage().equals(this.contentLanguage())) {
            return false;
        }
        if (other.contentType() == null ^ this.contentType() == null) {
            return false;
        }
        if (other.contentType() != null && !other.contentType().equals(this.contentType())) {
            return false;
        }
        if (other.copySource() == null ^ this.copySource() == null) {
            return false;
        }
        if (other.copySource() != null && !other.copySource().equals(this.copySource())) {
            return false;
        }
        if (other.copySourceIfMatch() == null ^ this.copySourceIfMatch() == null) {
            return false;
        }
        if (other.copySourceIfMatch() != null && !other.copySourceIfMatch().equals(this.copySourceIfMatch())) {
            return false;
        }
        if (other.copySourceIfModifiedSince() == null ^ this.copySourceIfModifiedSince() == null) {
            return false;
        }
        if (other.copySourceIfModifiedSince() != null
                && !other.copySourceIfModifiedSince().equals(this.copySourceIfModifiedSince())) {
            return false;
        }
        if (other.copySourceIfNoneMatch() == null ^ this.copySourceIfNoneMatch() == null) {
            return false;
        }
        if (other.copySourceIfNoneMatch() != null && !other.copySourceIfNoneMatch().equals(this.copySourceIfNoneMatch())) {
            return false;
        }
        if (other.copySourceIfUnmodifiedSince() == null ^ this.copySourceIfUnmodifiedSince() == null) {
            return false;
        }
        if (other.copySourceIfUnmodifiedSince() != null
                && !other.copySourceIfUnmodifiedSince().equals(this.copySourceIfUnmodifiedSince())) {
            return false;
        }
        if (other.expires() == null ^ this.expires() == null) {
            return false;
        }
        if (other.expires() != null && !other.expires().equals(this.expires())) {
            return false;
        }
        if (other.grantFullControl() == null ^ this.grantFullControl() == null) {
            return false;
        }
        if (other.grantFullControl() != null && !other.grantFullControl().equals(this.grantFullControl())) {
            return false;
        }
        if (other.grantRead() == null ^ this.grantRead() == null) {
            return false;
        }
        if (other.grantRead() != null && !other.grantRead().equals(this.grantRead())) {
            return false;
        }
        if (other.grantReadACP() == null ^ this.grantReadACP() == null) {
            return false;
        }
        if (other.grantReadACP() != null && !other.grantReadACP().equals(this.grantReadACP())) {
            return false;
        }
        if (other.grantWriteACP() == null ^ this.grantWriteACP() == null) {
            return false;
        }
        if (other.grantWriteACP() != null && !other.grantWriteACP().equals(this.grantWriteACP())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        if (other.metadata() != null && !other.metadata().equals(this.metadata())) {
            return false;
        }
        if (other.metadataDirective() == null ^ this.metadataDirective() == null) {
            return false;
        }
        if (other.metadataDirective() != null && !other.metadataDirective().equals(this.metadataDirective())) {
            return false;
        }
        if (other.taggingDirective() == null ^ this.taggingDirective() == null) {
            return false;
        }
        if (other.taggingDirective() != null && !other.taggingDirective().equals(this.taggingDirective())) {
            return false;
        }
        if (other.serverSideEncryption() == null ^ this.serverSideEncryption() == null) {
            return false;
        }
        if (other.serverSideEncryption() != null && !other.serverSideEncryption().equals(this.serverSideEncryption())) {
            return false;
        }
        if (other.storageClass() == null ^ this.storageClass() == null) {
            return false;
        }
        if (other.storageClass() != null && !other.storageClass().equals(this.storageClass())) {
            return false;
        }
        if (other.websiteRedirectLocation() == null ^ this.websiteRedirectLocation() == null) {
            return false;
        }
        if (other.websiteRedirectLocation() != null && !other.websiteRedirectLocation().equals(this.websiteRedirectLocation())) {
            return false;
        }
        if (other.sseCustomerAlgorithm() == null ^ this.sseCustomerAlgorithm() == null) {
            return false;
        }
        if (other.sseCustomerAlgorithm() != null && !other.sseCustomerAlgorithm().equals(this.sseCustomerAlgorithm())) {
            return false;
        }
        if (other.sseCustomerKey() == null ^ this.sseCustomerKey() == null) {
            return false;
        }
        if (other.sseCustomerKey() != null && !other.sseCustomerKey().equals(this.sseCustomerKey())) {
            return false;
        }
        if (other.sseCustomerKeyMD5() == null ^ this.sseCustomerKeyMD5() == null) {
            return false;
        }
        if (other.sseCustomerKeyMD5() != null && !other.sseCustomerKeyMD5().equals(this.sseCustomerKeyMD5())) {
            return false;
        }
        if (other.ssekmsKeyId() == null ^ this.ssekmsKeyId() == null) {
            return false;
        }
        if (other.ssekmsKeyId() != null && !other.ssekmsKeyId().equals(this.ssekmsKeyId())) {
            return false;
        }
        if (other.copySourceSSECustomerAlgorithm() == null ^ this.copySourceSSECustomerAlgorithm() == null) {
            return false;
        }
        if (other.copySourceSSECustomerAlgorithm() != null
                && !other.copySourceSSECustomerAlgorithm().equals(this.copySourceSSECustomerAlgorithm())) {
            return false;
        }
        if (other.copySourceSSECustomerKey() == null ^ this.copySourceSSECustomerKey() == null) {
            return false;
        }
        if (other.copySourceSSECustomerKey() != null && !other.copySourceSSECustomerKey().equals(this.copySourceSSECustomerKey())) {
            return false;
        }
        if (other.copySourceSSECustomerKeyMD5() == null ^ this.copySourceSSECustomerKeyMD5() == null) {
            return false;
        }
        if (other.copySourceSSECustomerKeyMD5() != null
                && !other.copySourceSSECustomerKeyMD5().equals(this.copySourceSSECustomerKeyMD5())) {
            return false;
        }
        if (other.requestPayer() == null ^ this.requestPayer() == null) {
            return false;
        }
        if (other.requestPayer() != null && !other.requestPayer().equals(this.requestPayer())) {
            return false;
        }
        if (other.tagging() == null ^ this.tagging() == null) {
            return false;
        }
        if (other.tagging() != null && !other.tagging().equals(this.tagging())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (acl() != null) {
            sb.append("ACL: ").append(acl()).append(",");
        }
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (cacheControl() != null) {
            sb.append("CacheControl: ").append(cacheControl()).append(",");
        }
        if (contentDisposition() != null) {
            sb.append("ContentDisposition: ").append(contentDisposition()).append(",");
        }
        if (contentEncoding() != null) {
            sb.append("ContentEncoding: ").append(contentEncoding()).append(",");
        }
        if (contentLanguage() != null) {
            sb.append("ContentLanguage: ").append(contentLanguage()).append(",");
        }
        if (contentType() != null) {
            sb.append("ContentType: ").append(contentType()).append(",");
        }
        if (copySource() != null) {
            sb.append("CopySource: ").append(copySource()).append(",");
        }
        if (copySourceIfMatch() != null) {
            sb.append("CopySourceIfMatch: ").append(copySourceIfMatch()).append(",");
        }
        if (copySourceIfModifiedSince() != null) {
            sb.append("CopySourceIfModifiedSince: ").append(copySourceIfModifiedSince()).append(",");
        }
        if (copySourceIfNoneMatch() != null) {
            sb.append("CopySourceIfNoneMatch: ").append(copySourceIfNoneMatch()).append(",");
        }
        if (copySourceIfUnmodifiedSince() != null) {
            sb.append("CopySourceIfUnmodifiedSince: ").append(copySourceIfUnmodifiedSince()).append(",");
        }
        if (expires() != null) {
            sb.append("Expires: ").append(expires()).append(",");
        }
        if (grantFullControl() != null) {
            sb.append("GrantFullControl: ").append(grantFullControl()).append(",");
        }
        if (grantRead() != null) {
            sb.append("GrantRead: ").append(grantRead()).append(",");
        }
        if (grantReadACP() != null) {
            sb.append("GrantReadACP: ").append(grantReadACP()).append(",");
        }
        if (grantWriteACP() != null) {
            sb.append("GrantWriteACP: ").append(grantWriteACP()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (metadata() != null) {
            sb.append("Metadata: ").append(metadata()).append(",");
        }
        if (metadataDirective() != null) {
            sb.append("MetadataDirective: ").append(metadataDirective()).append(",");
        }
        if (taggingDirective() != null) {
            sb.append("TaggingDirective: ").append(taggingDirective()).append(",");
        }
        if (serverSideEncryption() != null) {
            sb.append("ServerSideEncryption: ").append(serverSideEncryption()).append(",");
        }
        if (storageClass() != null) {
            sb.append("StorageClass: ").append(storageClass()).append(",");
        }
        if (websiteRedirectLocation() != null) {
            sb.append("WebsiteRedirectLocation: ").append(websiteRedirectLocation()).append(",");
        }
        if (sseCustomerAlgorithm() != null) {
            sb.append("SSECustomerAlgorithm: ").append(sseCustomerAlgorithm()).append(",");
        }
        if (sseCustomerKey() != null) {
            sb.append("SSECustomerKey: ").append(sseCustomerKey()).append(",");
        }
        if (sseCustomerKeyMD5() != null) {
            sb.append("SSECustomerKeyMD5: ").append(sseCustomerKeyMD5()).append(",");
        }
        if (ssekmsKeyId() != null) {
            sb.append("SSEKMSKeyId: ").append(ssekmsKeyId()).append(",");
        }
        if (copySourceSSECustomerAlgorithm() != null) {
            sb.append("CopySourceSSECustomerAlgorithm: ").append(copySourceSSECustomerAlgorithm()).append(",");
        }
        if (copySourceSSECustomerKey() != null) {
            sb.append("CopySourceSSECustomerKey: ").append(copySourceSSECustomerKey()).append(",");
        }
        if (copySourceSSECustomerKeyMD5() != null) {
            sb.append("CopySourceSSECustomerKeyMD5: ").append(copySourceSSECustomerKeyMD5()).append(",");
        }
        if (requestPayer() != null) {
            sb.append("RequestPayer: ").append(requestPayer()).append(",");
        }
        if (tagging() != null) {
            sb.append("Tagging: ").append(tagging()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CopyObjectRequest> {
        /**
         * The canned ACL to apply to the object.
         * 
         * @param acl
         *        The canned ACL to apply to the object.
         * @see ObjectCannedACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectCannedACL
         */
        Builder acl(String acl);

        /**
         * The canned ACL to apply to the object.
         * 
         * @param acl
         *        The canned ACL to apply to the object.
         * @see ObjectCannedACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectCannedACL
         */
        Builder acl(ObjectCannedACL acl);

        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Specifies caching behavior along the request/reply chain.
         * 
         * @param cacheControl
         *        Specifies caching behavior along the request/reply chain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheControl(String cacheControl);

        /**
         * Specifies presentational information for the object.
         * 
         * @param contentDisposition
         *        Specifies presentational information for the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentDisposition(String contentDisposition);

        /**
         * Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be
         * applied to obtain the media-type referenced by the Content-Type header field.
         * 
         * @param contentEncoding
         *        Specifies what content encodings have been applied to the object and thus what decoding mechanisms
         *        must be applied to obtain the media-type referenced by the Content-Type header field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentEncoding(String contentEncoding);

        /**
         * The language the content is in.
         * 
         * @param contentLanguage
         *        The language the content is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentLanguage(String contentLanguage);

        /**
         * A standard MIME type describing the format of the object data.
         * 
         * @param contentType
         *        A standard MIME type describing the format of the object data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * The name of the source bucket and key name of the source object, separated by a slash (/). Must be
         * URL-encoded.
         * 
         * @param copySource
         *        The name of the source bucket and key name of the source object, separated by a slash (/). Must be
         *        URL-encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySource(String copySource);

        /**
         * Copies the object if its entity tag (ETag) matches the specified tag.
         * 
         * @param copySourceIfMatch
         *        Copies the object if its entity tag (ETag) matches the specified tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceIfMatch(String copySourceIfMatch);

        /**
         * Copies the object if it has been modified since the specified time.
         * 
         * @param copySourceIfModifiedSince
         *        Copies the object if it has been modified since the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceIfModifiedSince(Instant copySourceIfModifiedSince);

        /**
         * Copies the object if its entity tag (ETag) is different than the specified ETag.
         * 
         * @param copySourceIfNoneMatch
         *        Copies the object if its entity tag (ETag) is different than the specified ETag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceIfNoneMatch(String copySourceIfNoneMatch);

        /**
         * Copies the object if it hasn't been modified since the specified time.
         * 
         * @param copySourceIfUnmodifiedSince
         *        Copies the object if it hasn't been modified since the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceIfUnmodifiedSince(Instant copySourceIfUnmodifiedSince);

        /**
         * The date and time at which the object is no longer cacheable.
         * 
         * @param expires
         *        The date and time at which the object is no longer cacheable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expires(Instant expires);

        /**
         * Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
         * 
         * @param grantFullControl
         *        Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantFullControl(String grantFullControl);

        /**
         * Allows grantee to read the object data and its metadata.
         * 
         * @param grantRead
         *        Allows grantee to read the object data and its metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantRead(String grantRead);

        /**
         * Allows grantee to read the object ACL.
         * 
         * @param grantReadACP
         *        Allows grantee to read the object ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantReadACP(String grantReadACP);

        /**
         * Allows grantee to write the ACL for the applicable object.
         * 
         * @param grantWriteACP
         *        Allows grantee to write the ACL for the applicable object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantWriteACP(String grantWriteACP);

        /**
         * Sets the value of the Key property for this object.
         *
         * @param key
         *        The new value for the Key property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * A map of metadata to store with the object in S3.
         * 
         * @param metadata
         *        A map of metadata to store with the object in S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String> metadata);

        /**
         * Specifies whether the metadata is copied from the source object or replaced with metadata provided in the
         * request.
         * 
         * @param metadataDirective
         *        Specifies whether the metadata is copied from the source object or replaced with metadata provided in
         *        the request.
         * @see MetadataDirective
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataDirective
         */
        Builder metadataDirective(String metadataDirective);

        /**
         * Specifies whether the metadata is copied from the source object or replaced with metadata provided in the
         * request.
         * 
         * @param metadataDirective
         *        Specifies whether the metadata is copied from the source object or replaced with metadata provided in
         *        the request.
         * @see MetadataDirective
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataDirective
         */
        Builder metadataDirective(MetadataDirective metadataDirective);

        /**
         * Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in
         * the request.
         * 
         * @param taggingDirective
         *        Specifies whether the object tag-set are copied from the source object or replaced with tag-set
         *        provided in the request.
         * @see TaggingDirective
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaggingDirective
         */
        Builder taggingDirective(String taggingDirective);

        /**
         * Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in
         * the request.
         * 
         * @param taggingDirective
         *        Specifies whether the object tag-set are copied from the source object or replaced with tag-set
         *        provided in the request.
         * @see TaggingDirective
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaggingDirective
         */
        Builder taggingDirective(TaggingDirective taggingDirective);

        /**
         * The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * 
         * @param serverSideEncryption
         *        The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * @see ServerSideEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerSideEncryption
         */
        Builder serverSideEncryption(String serverSideEncryption);

        /**
         * The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * 
         * @param serverSideEncryption
         *        The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * @see ServerSideEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerSideEncryption
         */
        Builder serverSideEncryption(ServerSideEncryption serverSideEncryption);

        /**
         * The type of storage to use for the object. Defaults to 'STANDARD'.
         * 
         * @param storageClass
         *        The type of storage to use for the object. Defaults to 'STANDARD'.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * The type of storage to use for the object. Defaults to 'STANDARD'.
         * 
         * @param storageClass
         *        The type of storage to use for the object. Defaults to 'STANDARD'.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(StorageClass storageClass);

        /**
         * If the bucket is configured as a website, redirects requests for this object to another object in the same
         * bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.
         * 
         * @param websiteRedirectLocation
         *        If the bucket is configured as a website, redirects requests for this object to another object in the
         *        same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteRedirectLocation(String websiteRedirectLocation);

        /**
         * Specifies the algorithm to use to when encrypting the object (e.g., AES256).
         * 
         * @param sseCustomerAlgorithm
         *        Specifies the algorithm to use to when encrypting the object (e.g., AES256).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerAlgorithm(String sseCustomerAlgorithm);

        /**
         * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to
         * store the object and then it is discarded; Amazon does not store the encryption key. The key must be
         * appropriate for use with the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
         * header.
         * 
         * @param sseCustomerKey
         *        Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is
         *        used to store the object and then it is discarded; Amazon does not store the encryption key. The key
         *        must be appropriate for use with the algorithm specified in the
         *        x-amz-server-side​-encryption​-customer-algorithm header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerKey(String sseCustomerKey);

        /**
         * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for
         * a message integrity check to ensure the encryption key was transmitted without error.
         * 
         * @param sseCustomerKeyMD5
         *        Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this
         *        header for a message integrity check to ensure the encryption key was transmitted without error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerKeyMD5(String sseCustomerKeyMD5);

        /**
         * Specifies the AWS KMS key ID to use for object encryption. All GET and PUT requests for an object protected
         * by AWS KMS will fail if not made via SSL or using SigV4. Documentation on configuring any of the officially
         * supported AWS SDKs and CLI can be found at
         * http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
         * 
         * @param ssekmsKeyId
         *        Specifies the AWS KMS key ID to use for object encryption. All GET and PUT requests for an object
         *        protected by AWS KMS will fail if not made via SSL or using SigV4. Documentation on configuring any of
         *        the officially supported AWS SDKs and CLI can be found at
         *        http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssekmsKeyId(String ssekmsKeyId);

        /**
         * Specifies the algorithm to use when decrypting the source object (e.g., AES256).
         * 
         * @param copySourceSSECustomerAlgorithm
         *        Specifies the algorithm to use when decrypting the source object (e.g., AES256).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceSSECustomerAlgorithm(String copySourceSSECustomerAlgorithm);

        /**
         * Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The
         * encryption key provided in this header must be one that was used when the source object was created.
         * 
         * @param copySourceSSECustomerKey
         *        Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The
         *        encryption key provided in this header must be one that was used when the source object was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceSSECustomerKey(String copySourceSSECustomerKey);

        /**
         * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for
         * a message integrity check to ensure the encryption key was transmitted without error.
         * 
         * @param copySourceSSECustomerKeyMD5
         *        Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this
         *        header for a message integrity check to ensure the encryption key was transmitted without error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceSSECustomerKeyMD5(String copySourceSSECustomerKeyMD5);

        /**
         * Sets the value of the RequestPayer property for this object.
         *
         * @param requestPayer
         *        The new value for the RequestPayer property for this object.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(String requestPayer);

        /**
         * Sets the value of the RequestPayer property for this object.
         *
         * @param requestPayer
         *        The new value for the RequestPayer property for this object.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(RequestPayer requestPayer);

        /**
         * The tag-set for the object destination object this value must be used in conjunction with the
         * TaggingDirective. The tag-set must be encoded as URL Query parameters
         * 
         * @param tagging
         *        The tag-set for the object destination object this value must be used in conjunction with the
         *        TaggingDirective. The tag-set must be encoded as URL Query parameters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagging(String tagging);
    }

    private static final class BuilderImpl implements Builder {
        private String acl;

        private String bucket;

        private String cacheControl;

        private String contentDisposition;

        private String contentEncoding;

        private String contentLanguage;

        private String contentType;

        private String copySource;

        private String copySourceIfMatch;

        private Instant copySourceIfModifiedSince;

        private String copySourceIfNoneMatch;

        private Instant copySourceIfUnmodifiedSince;

        private Instant expires;

        private String grantFullControl;

        private String grantRead;

        private String grantReadACP;

        private String grantWriteACP;

        private String key;

        private Map<String, String> metadata;

        private String metadataDirective;

        private String taggingDirective;

        private String serverSideEncryption;

        private String storageClass;

        private String websiteRedirectLocation;

        private String sseCustomerAlgorithm;

        private String sseCustomerKey;

        private String sseCustomerKeyMD5;

        private String ssekmsKeyId;

        private String copySourceSSECustomerAlgorithm;

        private String copySourceSSECustomerKey;

        private String copySourceSSECustomerKeyMD5;

        private String requestPayer;

        private String tagging;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyObjectRequest model) {
            setACL(model.acl);
            setBucket(model.bucket);
            setCacheControl(model.cacheControl);
            setContentDisposition(model.contentDisposition);
            setContentEncoding(model.contentEncoding);
            setContentLanguage(model.contentLanguage);
            setContentType(model.contentType);
            setCopySource(model.copySource);
            setCopySourceIfMatch(model.copySourceIfMatch);
            setCopySourceIfModifiedSince(model.copySourceIfModifiedSince);
            setCopySourceIfNoneMatch(model.copySourceIfNoneMatch);
            setCopySourceIfUnmodifiedSince(model.copySourceIfUnmodifiedSince);
            setExpires(model.expires);
            setGrantFullControl(model.grantFullControl);
            setGrantRead(model.grantRead);
            setGrantReadACP(model.grantReadACP);
            setGrantWriteACP(model.grantWriteACP);
            setKey(model.key);
            setMetadata(model.metadata);
            setMetadataDirective(model.metadataDirective);
            setTaggingDirective(model.taggingDirective);
            setServerSideEncryption(model.serverSideEncryption);
            setStorageClass(model.storageClass);
            setWebsiteRedirectLocation(model.websiteRedirectLocation);
            setSSECustomerAlgorithm(model.sseCustomerAlgorithm);
            setSSECustomerKey(model.sseCustomerKey);
            setSSECustomerKeyMD5(model.sseCustomerKeyMD5);
            setSSEKMSKeyId(model.ssekmsKeyId);
            setCopySourceSSECustomerAlgorithm(model.copySourceSSECustomerAlgorithm);
            setCopySourceSSECustomerKey(model.copySourceSSECustomerKey);
            setCopySourceSSECustomerKeyMD5(model.copySourceSSECustomerKeyMD5);
            setRequestPayer(model.requestPayer);
            setTagging(model.tagging);
        }

        public final String getACL() {
            return acl;
        }

        @Override
        public final Builder acl(String acl) {
            this.acl = acl;
            return this;
        }

        @Override
        public final Builder acl(ObjectCannedACL acl) {
            this.acl(acl.toString());
            return this;
        }

        public final void setACL(String acl) {
            this.acl = acl;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getCacheControl() {
            return cacheControl;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        public final String getContentDisposition() {
            return contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        public final String getContentEncoding() {
            return contentEncoding;
        }

        @Override
        public final Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public final void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        public final String getContentLanguage() {
            return contentLanguage;
        }

        @Override
        public final Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public final void setContentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getCopySource() {
            return copySource;
        }

        @Override
        public final Builder copySource(String copySource) {
            this.copySource = copySource;
            return this;
        }

        public final void setCopySource(String copySource) {
            this.copySource = copySource;
        }

        public final String getCopySourceIfMatch() {
            return copySourceIfMatch;
        }

        @Override
        public final Builder copySourceIfMatch(String copySourceIfMatch) {
            this.copySourceIfMatch = copySourceIfMatch;
            return this;
        }

        public final void setCopySourceIfMatch(String copySourceIfMatch) {
            this.copySourceIfMatch = copySourceIfMatch;
        }

        public final Instant getCopySourceIfModifiedSince() {
            return copySourceIfModifiedSince;
        }

        @Override
        public final Builder copySourceIfModifiedSince(Instant copySourceIfModifiedSince) {
            this.copySourceIfModifiedSince = copySourceIfModifiedSince;
            return this;
        }

        public final void setCopySourceIfModifiedSince(Instant copySourceIfModifiedSince) {
            this.copySourceIfModifiedSince = copySourceIfModifiedSince;
        }

        public final String getCopySourceIfNoneMatch() {
            return copySourceIfNoneMatch;
        }

        @Override
        public final Builder copySourceIfNoneMatch(String copySourceIfNoneMatch) {
            this.copySourceIfNoneMatch = copySourceIfNoneMatch;
            return this;
        }

        public final void setCopySourceIfNoneMatch(String copySourceIfNoneMatch) {
            this.copySourceIfNoneMatch = copySourceIfNoneMatch;
        }

        public final Instant getCopySourceIfUnmodifiedSince() {
            return copySourceIfUnmodifiedSince;
        }

        @Override
        public final Builder copySourceIfUnmodifiedSince(Instant copySourceIfUnmodifiedSince) {
            this.copySourceIfUnmodifiedSince = copySourceIfUnmodifiedSince;
            return this;
        }

        public final void setCopySourceIfUnmodifiedSince(Instant copySourceIfUnmodifiedSince) {
            this.copySourceIfUnmodifiedSince = copySourceIfUnmodifiedSince;
        }

        public final Instant getExpires() {
            return expires;
        }

        @Override
        public final Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        public final void setExpires(Instant expires) {
            this.expires = expires;
        }

        public final String getGrantFullControl() {
            return grantFullControl;
        }

        @Override
        public final Builder grantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
            return this;
        }

        public final void setGrantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
        }

        public final String getGrantRead() {
            return grantRead;
        }

        @Override
        public final Builder grantRead(String grantRead) {
            this.grantRead = grantRead;
            return this;
        }

        public final void setGrantRead(String grantRead) {
            this.grantRead = grantRead;
        }

        public final String getGrantReadACP() {
            return grantReadACP;
        }

        @Override
        public final Builder grantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
            return this;
        }

        public final void setGrantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
        }

        public final String getGrantWriteACP() {
            return grantWriteACP;
        }

        @Override
        public final Builder grantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
            return this;
        }

        public final void setGrantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Map<String, String> getMetadata() {
            return metadata;
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
            return this;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
        }

        public final String getMetadataDirective() {
            return metadataDirective;
        }

        @Override
        public final Builder metadataDirective(String metadataDirective) {
            this.metadataDirective = metadataDirective;
            return this;
        }

        @Override
        public final Builder metadataDirective(MetadataDirective metadataDirective) {
            this.metadataDirective(metadataDirective.toString());
            return this;
        }

        public final void setMetadataDirective(String metadataDirective) {
            this.metadataDirective = metadataDirective;
        }

        public final String getTaggingDirective() {
            return taggingDirective;
        }

        @Override
        public final Builder taggingDirective(String taggingDirective) {
            this.taggingDirective = taggingDirective;
            return this;
        }

        @Override
        public final Builder taggingDirective(TaggingDirective taggingDirective) {
            this.taggingDirective(taggingDirective.toString());
            return this;
        }

        public final void setTaggingDirective(String taggingDirective) {
            this.taggingDirective = taggingDirective;
        }

        public final String getServerSideEncryption() {
            return serverSideEncryption;
        }

        @Override
        public final Builder serverSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        @Override
        public final Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption(serverSideEncryption.toString());
            return this;
        }

        public final void setServerSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final String getWebsiteRedirectLocation() {
            return websiteRedirectLocation;
        }

        @Override
        public final Builder websiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
            return this;
        }

        public final void setWebsiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
        }

        public final String getSSECustomerAlgorithm() {
            return sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKey() {
            return sseCustomerKey;
        }

        @Override
        public final Builder sseCustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            return this;
        }

        public final void setSSECustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
        }

        public final String getSSECustomerKeyMD5() {
            return sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getSSEKMSKeyId() {
            return ssekmsKeyId;
        }

        @Override
        public final Builder ssekmsKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
            return this;
        }

        public final void setSSEKMSKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
        }

        public final String getCopySourceSSECustomerAlgorithm() {
            return copySourceSSECustomerAlgorithm;
        }

        @Override
        public final Builder copySourceSSECustomerAlgorithm(String copySourceSSECustomerAlgorithm) {
            this.copySourceSSECustomerAlgorithm = copySourceSSECustomerAlgorithm;
            return this;
        }

        public final void setCopySourceSSECustomerAlgorithm(String copySourceSSECustomerAlgorithm) {
            this.copySourceSSECustomerAlgorithm = copySourceSSECustomerAlgorithm;
        }

        public final String getCopySourceSSECustomerKey() {
            return copySourceSSECustomerKey;
        }

        @Override
        public final Builder copySourceSSECustomerKey(String copySourceSSECustomerKey) {
            this.copySourceSSECustomerKey = copySourceSSECustomerKey;
            return this;
        }

        public final void setCopySourceSSECustomerKey(String copySourceSSECustomerKey) {
            this.copySourceSSECustomerKey = copySourceSSECustomerKey;
        }

        public final String getCopySourceSSECustomerKeyMD5() {
            return copySourceSSECustomerKeyMD5;
        }

        @Override
        public final Builder copySourceSSECustomerKeyMD5(String copySourceSSECustomerKeyMD5) {
            this.copySourceSSECustomerKeyMD5 = copySourceSSECustomerKeyMD5;
            return this;
        }

        public final void setCopySourceSSECustomerKeyMD5(String copySourceSSECustomerKeyMD5) {
            this.copySourceSSECustomerKeyMD5 = copySourceSSECustomerKeyMD5;
        }

        public final String getRequestPayer() {
            return requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final String getTagging() {
            return tagging;
        }

        @Override
        public final Builder tagging(String tagging) {
            this.tagging = tagging;
            return this;
        }

        public final void setTagging(String tagging) {
            this.tagging = tagging;
        }

        @Override
        public CopyObjectRequest build() {
            return new CopyObjectRequest(this);
        }
    }
}
