/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CORSConfiguration implements ToCopyableBuilder<CORSConfiguration.Builder, CORSConfiguration> {
    private final List<CORSRule> corsRules;

    private CORSConfiguration(BuilderImpl builder) {
        this.corsRules = builder.corsRules;
    }

    /**
     * Returns the value of the CORSRules property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the CORSRules property for this object.
     */
    public List<CORSRule> corsRules() {
        return corsRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((corsRules() == null) ? 0 : corsRules().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CORSConfiguration)) {
            return false;
        }
        CORSConfiguration other = (CORSConfiguration) obj;
        if (other.corsRules() == null ^ this.corsRules() == null) {
            return false;
        }
        if (other.corsRules() != null && !other.corsRules().equals(this.corsRules())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (corsRules() != null) {
            sb.append("CORSRules: ").append(corsRules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CORSConfiguration> {
        /**
         * Sets the value of the CORSRules property for this object.
         *
         * @param corsRules
         *        The new value for the CORSRules property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder corsRules(Collection<CORSRule> corsRules);

        /**
         * Sets the value of the CORSRules property for this object.
         *
         * @param corsRules
         *        The new value for the CORSRules property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder corsRules(CORSRule... corsRules);
    }

    private static final class BuilderImpl implements Builder {
        private List<CORSRule> corsRules;

        private BuilderImpl() {
        }

        private BuilderImpl(CORSConfiguration model) {
            setCORSRules(model.corsRules);
        }

        public final Collection<CORSRule> getCORSRules() {
            return corsRules;
        }

        @Override
        public final Builder corsRules(Collection<CORSRule> corsRules) {
            this.corsRules = CORSRulesCopier.copy(corsRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder corsRules(CORSRule... corsRules) {
            corsRules(Arrays.asList(corsRules));
            return this;
        }

        public final void setCORSRules(Collection<CORSRule> corsRules) {
            this.corsRules = CORSRulesCopier.copy(corsRules);
        }

        @Override
        public CORSConfiguration build() {
            return new CORSConfiguration(this);
        }
    }
}
