/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AccessControlPolicy implements ToCopyableBuilder<AccessControlPolicy.Builder, AccessControlPolicy> {
    private final List<Grant> grants;

    private final Owner owner;

    private AccessControlPolicy(BuilderImpl builder) {
        this.grants = builder.grants;
        this.owner = builder.owner;
    }

    /**
     * A list of grants.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of grants.
     */
    public List<Grant> grants() {
        return grants;
    }

    /**
     * Returns the value of the Owner property for this object.
     * 
     * @return The value of the Owner property for this object.
     */
    public Owner owner() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((grants() == null) ? 0 : grants().hashCode());
        hashCode = 31 * hashCode + ((owner() == null) ? 0 : owner().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessControlPolicy)) {
            return false;
        }
        AccessControlPolicy other = (AccessControlPolicy) obj;
        if (other.grants() == null ^ this.grants() == null) {
            return false;
        }
        if (other.grants() != null && !other.grants().equals(this.grants())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (grants() != null) {
            sb.append("Grants: ").append(grants()).append(",");
        }
        if (owner() != null) {
            sb.append("Owner: ").append(owner()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AccessControlPolicy> {
        /**
         * A list of grants.
         * 
         * @param grants
         *        A list of grants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grants(Collection<Grant> grants);

        /**
         * A list of grants.
         * 
         * @param grants
         *        A list of grants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grants(Grant... grants);

        /**
         * Sets the value of the Owner property for this object.
         *
         * @param owner
         *        The new value for the Owner property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(Owner owner);
    }

    private static final class BuilderImpl implements Builder {
        private List<Grant> grants;

        private Owner owner;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessControlPolicy model) {
            setGrants(model.grants);
            setOwner(model.owner);
        }

        public final Collection<Grant> getGrants() {
            return grants;
        }

        @Override
        public final Builder grants(Collection<Grant> grants) {
            this.grants = GrantsCopier.copy(grants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(Grant... grants) {
            grants(Arrays.asList(grants));
            return this;
        }

        public final void setGrants(Collection<Grant> grants) {
            this.grants = GrantsCopier.copy(grants);
        }

        public final Owner getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner owner) {
            this.owner = owner;
        }

        @Override
        public AccessControlPolicy build() {
            return new AccessControlPolicy(this);
        }
    }
}
