/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class Transition implements ToCopyableBuilder<Transition.Builder, Transition> {
    private final Instant dateValue;

    private final Integer days;

    private final String storageClass;

    private Transition(BuilderImpl builder) {
        this.dateValue = builder.dateValue;
        this.days = builder.days;
        this.storageClass = builder.storageClass;
    }

    /**
     * Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.
     * 
     * @return Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.
     */
    public Instant date() {
        return dateValue;
    }

    /**
     * Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero
     * positive integer.
     * 
     * @return Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a
     *         non-zero positive integer.
     */
    public Integer days() {
        return days;
    }

    /**
     * The class of storage used to store the object.
     * 
     * @return The class of storage used to store the object.
     * @see TransitionStorageClass
     */
    public String storageClass() {
        return storageClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((date() == null) ? 0 : date().hashCode());
        hashCode = 31 * hashCode + ((days() == null) ? 0 : days().hashCode());
        hashCode = 31 * hashCode + ((storageClass() == null) ? 0 : storageClass().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transition)) {
            return false;
        }
        Transition other = (Transition) obj;
        if (other.date() == null ^ this.date() == null) {
            return false;
        }
        if (other.date() != null && !other.date().equals(this.date())) {
            return false;
        }
        if (other.days() == null ^ this.days() == null) {
            return false;
        }
        if (other.days() != null && !other.days().equals(this.days())) {
            return false;
        }
        if (other.storageClass() == null ^ this.storageClass() == null) {
            return false;
        }
        if (other.storageClass() != null && !other.storageClass().equals(this.storageClass())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (date() != null) {
            sb.append("Date: ").append(date()).append(",");
        }
        if (days() != null) {
            sb.append("Days: ").append(days()).append(",");
        }
        if (storageClass() != null) {
            sb.append("StorageClass: ").append(storageClass()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Transition> {
        /**
         * Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.
         * 
         * @param dateValue
         *        Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(Instant dateValue);

        /**
         * Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero
         * positive integer.
         * 
         * @param days
         *        Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a
         *        non-zero positive integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder days(Integer days);

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see TransitionStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitionStorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see TransitionStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitionStorageClass
         */
        Builder storageClass(TransitionStorageClass storageClass);
    }

    private static final class BuilderImpl implements Builder {
        private Instant dateValue;

        private Integer days;

        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(Transition model) {
            setDate(model.dateValue);
            setDays(model.days);
            setStorageClass(model.storageClass);
        }

        public final Instant getDate() {
            return dateValue;
        }

        @Override
        public final Builder date(Instant dateValue) {
            this.dateValue = dateValue;
            return this;
        }

        public final void setDate(Instant dateValue) {
            this.dateValue = dateValue;
        }

        public final Integer getDays() {
            return days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(TransitionStorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final void setStorageClass(TransitionStorageClass storageClass) {
            this.storageClass(storageClass.toString());
        }

        @Override
        public Transition build() {
            return new Transition(this);
        }
    }
}
