/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutObjectResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PutObjectResponse.Builder, PutObjectResponse> {
    private final String expiration;

    private final String eTag;

    private final String serverSideEncryption;

    private final String versionId;

    private final String sseCustomerAlgorithm;

    private final String sseCustomerKeyMD5;

    private final String ssekmsKeyId;

    private final String requestCharged;

    private PutObjectResponse(BuilderImpl builder) {
        this.expiration = builder.expiration;
        this.eTag = builder.eTag;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.versionId = builder.versionId;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.ssekmsKeyId = builder.ssekmsKeyId;
        this.requestCharged = builder.requestCharged;
    }

    /**
     * If the object expiration is configured, this will contain the expiration date (expiry-date) and rule ID
     * (rule-id). The value of rule-id is URL encoded.
     * 
     * @return If the object expiration is configured, this will contain the expiration date (expiry-date) and rule ID
     *         (rule-id). The value of rule-id is URL encoded.
     */
    public String expiration() {
        return expiration;
    }

    /**
     * Entity tag for the uploaded object.
     * 
     * @return Entity tag for the uploaded object.
     */
    public String eTag() {
        return eTag;
    }

    /**
     * The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
     * 
     * @return The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
     * @see ServerSideEncryption
     */
    public String serverSideEncryption() {
        return serverSideEncryption;
    }

    /**
     * Version of the object.
     * 
     * @return Version of the object.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * If server-side encryption with a customer-provided encryption key was requested, the response will include this
     * header confirming the encryption algorithm used.
     * 
     * @return If server-side encryption with a customer-provided encryption key was requested, the response will
     *         include this header confirming the encryption algorithm used.
     */
    public String sseCustomerAlgorithm() {
        return sseCustomerAlgorithm;
    }

    /**
     * If server-side encryption with a customer-provided encryption key was requested, the response will include this
     * header to provide round trip message integrity verification of the customer-provided encryption key.
     * 
     * @return If server-side encryption with a customer-provided encryption key was requested, the response will
     *         include this header to provide round trip message integrity verification of the customer-provided
     *         encryption key.
     */
    public String sseCustomerKeyMD5() {
        return sseCustomerKeyMD5;
    }

    /**
     * If present, specifies the ID of the AWS Key Management Service (KMS) master encryption key that was used for the
     * object.
     * 
     * @return If present, specifies the ID of the AWS Key Management Service (KMS) master encryption key that was used
     *         for the object.
     */
    public String ssekmsKeyId() {
        return ssekmsKeyId;
    }

    /**
     * Returns the value of the RequestCharged property for this object.
     * 
     * @return The value of the RequestCharged property for this object.
     * @see RequestCharged
     */
    public String requestCharged() {
        return requestCharged;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((expiration() == null) ? 0 : expiration().hashCode());
        hashCode = 31 * hashCode + ((eTag() == null) ? 0 : eTag().hashCode());
        hashCode = 31 * hashCode + ((serverSideEncryption() == null) ? 0 : serverSideEncryption().hashCode());
        hashCode = 31 * hashCode + ((versionId() == null) ? 0 : versionId().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerAlgorithm() == null) ? 0 : sseCustomerAlgorithm().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerKeyMD5() == null) ? 0 : sseCustomerKeyMD5().hashCode());
        hashCode = 31 * hashCode + ((ssekmsKeyId() == null) ? 0 : ssekmsKeyId().hashCode());
        hashCode = 31 * hashCode + ((requestCharged() == null) ? 0 : requestCharged().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectResponse)) {
            return false;
        }
        PutObjectResponse other = (PutObjectResponse) obj;
        if (other.expiration() == null ^ this.expiration() == null) {
            return false;
        }
        if (other.expiration() != null && !other.expiration().equals(this.expiration())) {
            return false;
        }
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        if (other.eTag() != null && !other.eTag().equals(this.eTag())) {
            return false;
        }
        if (other.serverSideEncryption() == null ^ this.serverSideEncryption() == null) {
            return false;
        }
        if (other.serverSideEncryption() != null && !other.serverSideEncryption().equals(this.serverSideEncryption())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.sseCustomerAlgorithm() == null ^ this.sseCustomerAlgorithm() == null) {
            return false;
        }
        if (other.sseCustomerAlgorithm() != null && !other.sseCustomerAlgorithm().equals(this.sseCustomerAlgorithm())) {
            return false;
        }
        if (other.sseCustomerKeyMD5() == null ^ this.sseCustomerKeyMD5() == null) {
            return false;
        }
        if (other.sseCustomerKeyMD5() != null && !other.sseCustomerKeyMD5().equals(this.sseCustomerKeyMD5())) {
            return false;
        }
        if (other.ssekmsKeyId() == null ^ this.ssekmsKeyId() == null) {
            return false;
        }
        if (other.ssekmsKeyId() != null && !other.ssekmsKeyId().equals(this.ssekmsKeyId())) {
            return false;
        }
        if (other.requestCharged() == null ^ this.requestCharged() == null) {
            return false;
        }
        if (other.requestCharged() != null && !other.requestCharged().equals(this.requestCharged())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (expiration() != null) {
            sb.append("Expiration: ").append(expiration()).append(",");
        }
        if (eTag() != null) {
            sb.append("ETag: ").append(eTag()).append(",");
        }
        if (serverSideEncryption() != null) {
            sb.append("ServerSideEncryption: ").append(serverSideEncryption()).append(",");
        }
        if (versionId() != null) {
            sb.append("VersionId: ").append(versionId()).append(",");
        }
        if (sseCustomerAlgorithm() != null) {
            sb.append("SSECustomerAlgorithm: ").append(sseCustomerAlgorithm()).append(",");
        }
        if (sseCustomerKeyMD5() != null) {
            sb.append("SSECustomerKeyMD5: ").append(sseCustomerKeyMD5()).append(",");
        }
        if (ssekmsKeyId() != null) {
            sb.append("SSEKMSKeyId: ").append(ssekmsKeyId()).append(",");
        }
        if (requestCharged() != null) {
            sb.append("RequestCharged: ").append(requestCharged()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutObjectResponse> {
        /**
         * If the object expiration is configured, this will contain the expiration date (expiry-date) and rule ID
         * (rule-id). The value of rule-id is URL encoded.
         * 
         * @param expiration
         *        If the object expiration is configured, this will contain the expiration date (expiry-date) and rule
         *        ID (rule-id). The value of rule-id is URL encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(String expiration);

        /**
         * Entity tag for the uploaded object.
         * 
         * @param eTag
         *        Entity tag for the uploaded object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * 
         * @param serverSideEncryption
         *        The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * @see ServerSideEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerSideEncryption
         */
        Builder serverSideEncryption(String serverSideEncryption);

        /**
         * The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * 
         * @param serverSideEncryption
         *        The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * @see ServerSideEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerSideEncryption
         */
        Builder serverSideEncryption(ServerSideEncryption serverSideEncryption);

        /**
         * Version of the object.
         * 
         * @param versionId
         *        Version of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * If server-side encryption with a customer-provided encryption key was requested, the response will include
         * this header confirming the encryption algorithm used.
         * 
         * @param sseCustomerAlgorithm
         *        If server-side encryption with a customer-provided encryption key was requested, the response will
         *        include this header confirming the encryption algorithm used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerAlgorithm(String sseCustomerAlgorithm);

        /**
         * If server-side encryption with a customer-provided encryption key was requested, the response will include
         * this header to provide round trip message integrity verification of the customer-provided encryption key.
         * 
         * @param sseCustomerKeyMD5
         *        If server-side encryption with a customer-provided encryption key was requested, the response will
         *        include this header to provide round trip message integrity verification of the customer-provided
         *        encryption key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerKeyMD5(String sseCustomerKeyMD5);

        /**
         * If present, specifies the ID of the AWS Key Management Service (KMS) master encryption key that was used for
         * the object.
         * 
         * @param ssekmsKeyId
         *        If present, specifies the ID of the AWS Key Management Service (KMS) master encryption key that was
         *        used for the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssekmsKeyId(String ssekmsKeyId);

        /**
         * Sets the value of the RequestCharged property for this object.
         *
         * @param requestCharged
         *        The new value for the RequestCharged property for this object.
         * @see RequestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(String requestCharged);

        /**
         * Sets the value of the RequestCharged property for this object.
         *
         * @param requestCharged
         *        The new value for the RequestCharged property for this object.
         * @see RequestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(RequestCharged requestCharged);
    }

    private static final class BuilderImpl implements Builder {
        private String expiration;

        private String eTag;

        private String serverSideEncryption;

        private String versionId;

        private String sseCustomerAlgorithm;

        private String sseCustomerKeyMD5;

        private String ssekmsKeyId;

        private String requestCharged;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectResponse model) {
            setExpiration(model.expiration);
            setETag(model.eTag);
            setServerSideEncryption(model.serverSideEncryption);
            setVersionId(model.versionId);
            setSSECustomerAlgorithm(model.sseCustomerAlgorithm);
            setSSECustomerKeyMD5(model.sseCustomerKeyMD5);
            setSSEKMSKeyId(model.ssekmsKeyId);
            setRequestCharged(model.requestCharged);
        }

        public final String getExpiration() {
            return expiration;
        }

        @Override
        public final Builder expiration(String expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final String getServerSideEncryption() {
            return serverSideEncryption;
        }

        @Override
        public final Builder serverSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        @Override
        public final Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption(serverSideEncryption.toString());
            return this;
        }

        public final void setServerSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
        }

        public final void setServerSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption(serverSideEncryption.toString());
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getSSECustomerAlgorithm() {
            return sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKeyMD5() {
            return sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getSSEKMSKeyId() {
            return ssekmsKeyId;
        }

        @Override
        public final Builder ssekmsKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
            return this;
        }

        public final void setSSEKMSKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
        }

        public final String getRequestCharged() {
            return requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        public final void setRequestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
        }

        @Override
        public PutObjectResponse build() {
            return new PutObjectResponse(this);
        }
    }
}
