/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListObjectsV2Request extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListObjectsV2Request.Builder, ListObjectsV2Request> {
    private final String bucket;

    private final String delimiter;

    private final String encodingType;

    private final Integer maxKeys;

    private final String prefix;

    private final String continuationToken;

    private final Boolean fetchOwner;

    private final String startAfter;

    private final String requestPayer;

    private ListObjectsV2Request(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.delimiter = builder.delimiter;
        this.encodingType = builder.encodingType;
        this.maxKeys = builder.maxKeys;
        this.prefix = builder.prefix;
        this.continuationToken = builder.continuationToken;
        this.fetchOwner = builder.fetchOwner;
        this.startAfter = builder.startAfter;
        this.requestPayer = builder.requestPayer;
    }

    /**
     * Name of the bucket to list.
     * 
     * @return Name of the bucket to list.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * A delimiter is a character you use to group keys.
     * 
     * @return A delimiter is a character you use to group keys.
     */
    public String delimiter() {
        return delimiter;
    }

    /**
     * Encoding type used by Amazon S3 to encode object keys in the response.
     * 
     * @return Encoding type used by Amazon S3 to encode object keys in the response.
     * @see EncodingType
     */
    public String encodingType() {
        return encodingType;
    }

    /**
     * Sets the maximum number of keys returned in the response. The response might contain fewer keys but will never
     * contain more.
     * 
     * @return Sets the maximum number of keys returned in the response. The response might contain fewer keys but will
     *         never contain more.
     */
    public Integer maxKeys() {
        return maxKeys;
    }

    /**
     * Limits the response to keys that begin with the specified prefix.
     * 
     * @return Limits the response to keys that begin with the specified prefix.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * ContinuationToken indicates Amazon S3 that the list is being continued on this bucket with a token.
     * ContinuationToken is obfuscated and is not a real key
     * 
     * @return ContinuationToken indicates Amazon S3 that the list is being continued on this bucket with a token.
     *         ContinuationToken is obfuscated and is not a real key
     */
    public String continuationToken() {
        return continuationToken;
    }

    /**
     * The owner field is not present in listV2 by default, if you want to return owner field with each key in the
     * result then set the fetch owner field to true
     * 
     * @return The owner field is not present in listV2 by default, if you want to return owner field with each key in
     *         the result then set the fetch owner field to true
     */
    public Boolean fetchOwner() {
        return fetchOwner;
    }

    /**
     * StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key.
     * StartAfter can be any key in the bucket
     * 
     * @return StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this
     *         specified key. StartAfter can be any key in the bucket
     */
    public String startAfter() {
        return startAfter;
    }

    /**
     * Confirms that the requester knows that she or he will be charged for the list objects request in V2 style. Bucket
     * owners need not specify this parameter in their requests.
     * 
     * @return Confirms that the requester knows that she or he will be charged for the list objects request in V2
     *         style. Bucket owners need not specify this parameter in their requests.
     * @see RequestPayer
     */
    public String requestPayer() {
        return requestPayer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((delimiter() == null) ? 0 : delimiter().hashCode());
        hashCode = 31 * hashCode + ((encodingType() == null) ? 0 : encodingType().hashCode());
        hashCode = 31 * hashCode + ((maxKeys() == null) ? 0 : maxKeys().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((continuationToken() == null) ? 0 : continuationToken().hashCode());
        hashCode = 31 * hashCode + ((fetchOwner() == null) ? 0 : fetchOwner().hashCode());
        hashCode = 31 * hashCode + ((startAfter() == null) ? 0 : startAfter().hashCode());
        hashCode = 31 * hashCode + ((requestPayer() == null) ? 0 : requestPayer().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectsV2Request)) {
            return false;
        }
        ListObjectsV2Request other = (ListObjectsV2Request) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.delimiter() == null ^ this.delimiter() == null) {
            return false;
        }
        if (other.delimiter() != null && !other.delimiter().equals(this.delimiter())) {
            return false;
        }
        if (other.encodingType() == null ^ this.encodingType() == null) {
            return false;
        }
        if (other.encodingType() != null && !other.encodingType().equals(this.encodingType())) {
            return false;
        }
        if (other.maxKeys() == null ^ this.maxKeys() == null) {
            return false;
        }
        if (other.maxKeys() != null && !other.maxKeys().equals(this.maxKeys())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.continuationToken() == null ^ this.continuationToken() == null) {
            return false;
        }
        if (other.continuationToken() != null && !other.continuationToken().equals(this.continuationToken())) {
            return false;
        }
        if (other.fetchOwner() == null ^ this.fetchOwner() == null) {
            return false;
        }
        if (other.fetchOwner() != null && !other.fetchOwner().equals(this.fetchOwner())) {
            return false;
        }
        if (other.startAfter() == null ^ this.startAfter() == null) {
            return false;
        }
        if (other.startAfter() != null && !other.startAfter().equals(this.startAfter())) {
            return false;
        }
        if (other.requestPayer() == null ^ this.requestPayer() == null) {
            return false;
        }
        if (other.requestPayer() != null && !other.requestPayer().equals(this.requestPayer())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (delimiter() != null) {
            sb.append("Delimiter: ").append(delimiter()).append(",");
        }
        if (encodingType() != null) {
            sb.append("EncodingType: ").append(encodingType()).append(",");
        }
        if (maxKeys() != null) {
            sb.append("MaxKeys: ").append(maxKeys()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (continuationToken() != null) {
            sb.append("ContinuationToken: ").append(continuationToken()).append(",");
        }
        if (fetchOwner() != null) {
            sb.append("FetchOwner: ").append(fetchOwner()).append(",");
        }
        if (startAfter() != null) {
            sb.append("StartAfter: ").append(startAfter()).append(",");
        }
        if (requestPayer() != null) {
            sb.append("RequestPayer: ").append(requestPayer()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListObjectsV2Request> {
        /**
         * Name of the bucket to list.
         * 
         * @param bucket
         *        Name of the bucket to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * A delimiter is a character you use to group keys.
         * 
         * @param delimiter
         *        A delimiter is a character you use to group keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimiter(String delimiter);

        /**
         * Encoding type used by Amazon S3 to encode object keys in the response.
         * 
         * @param encodingType
         *        Encoding type used by Amazon S3 to encode object keys in the response.
         * @see EncodingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(String encodingType);

        /**
         * Encoding type used by Amazon S3 to encode object keys in the response.
         * 
         * @param encodingType
         *        Encoding type used by Amazon S3 to encode object keys in the response.
         * @see EncodingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(EncodingType encodingType);

        /**
         * Sets the maximum number of keys returned in the response. The response might contain fewer keys but will
         * never contain more.
         * 
         * @param maxKeys
         *        Sets the maximum number of keys returned in the response. The response might contain fewer keys but
         *        will never contain more.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxKeys(Integer maxKeys);

        /**
         * Limits the response to keys that begin with the specified prefix.
         * 
         * @param prefix
         *        Limits the response to keys that begin with the specified prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * ContinuationToken indicates Amazon S3 that the list is being continued on this bucket with a token.
         * ContinuationToken is obfuscated and is not a real key
         * 
         * @param continuationToken
         *        ContinuationToken indicates Amazon S3 that the list is being continued on this bucket with a token.
         *        ContinuationToken is obfuscated and is not a real key
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);

        /**
         * The owner field is not present in listV2 by default, if you want to return owner field with each key in the
         * result then set the fetch owner field to true
         * 
         * @param fetchOwner
         *        The owner field is not present in listV2 by default, if you want to return owner field with each key
         *        in the result then set the fetch owner field to true
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fetchOwner(Boolean fetchOwner);

        /**
         * StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified
         * key. StartAfter can be any key in the bucket
         * 
         * @param startAfter
         *        StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this
         *        specified key. StartAfter can be any key in the bucket
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startAfter(String startAfter);

        /**
         * Confirms that the requester knows that she or he will be charged for the list objects request in V2 style.
         * Bucket owners need not specify this parameter in their requests.
         * 
         * @param requestPayer
         *        Confirms that the requester knows that she or he will be charged for the list objects request in V2
         *        style. Bucket owners need not specify this parameter in their requests.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(String requestPayer);

        /**
         * Confirms that the requester knows that she or he will be charged for the list objects request in V2 style.
         * Bucket owners need not specify this parameter in their requests.
         * 
         * @param requestPayer
         *        Confirms that the requester knows that she or he will be charged for the list objects request in V2
         *        style. Bucket owners need not specify this parameter in their requests.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(RequestPayer requestPayer);
    }

    private static final class BuilderImpl implements Builder {
        private String bucket;

        private String delimiter;

        private String encodingType;

        private Integer maxKeys;

        private String prefix;

        private String continuationToken;

        private Boolean fetchOwner;

        private String startAfter;

        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectsV2Request model) {
            setBucket(model.bucket);
            setDelimiter(model.delimiter);
            setEncodingType(model.encodingType);
            setMaxKeys(model.maxKeys);
            setPrefix(model.prefix);
            setContinuationToken(model.continuationToken);
            setFetchOwner(model.fetchOwner);
            setStartAfter(model.startAfter);
            setRequestPayer(model.requestPayer);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getDelimiter() {
            return delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final String getEncodingType() {
            return encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        public final void setEncodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
        }

        public final Integer getMaxKeys() {
            return maxKeys;
        }

        @Override
        public final Builder maxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        public final void setMaxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final Boolean getFetchOwner() {
            return fetchOwner;
        }

        @Override
        public final Builder fetchOwner(Boolean fetchOwner) {
            this.fetchOwner = fetchOwner;
            return this;
        }

        public final void setFetchOwner(Boolean fetchOwner) {
            this.fetchOwner = fetchOwner;
        }

        public final String getStartAfter() {
            return startAfter;
        }

        @Override
        public final Builder startAfter(String startAfter) {
            this.startAfter = startAfter;
            return this;
        }

        public final void setStartAfter(String startAfter) {
            this.startAfter = startAfter;
        }

        public final String getRequestPayer() {
            return requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final void setRequestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
        }

        @Override
        public ListObjectsV2Request build() {
            return new ListObjectsV2Request(this);
        }
    }
}
