/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListMultipartUploadsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListMultipartUploadsResponse.Builder, ListMultipartUploadsResponse> {
    private final String bucket;

    private final String keyMarker;

    private final String uploadIdMarker;

    private final String nextKeyMarker;

    private final String prefix;

    private final String delimiter;

    private final String nextUploadIdMarker;

    private final Integer maxUploads;

    private final Boolean isTruncated;

    private final List<MultipartUpload> uploads;

    private final List<CommonPrefix> commonPrefixes;

    private final String encodingType;

    private ListMultipartUploadsResponse(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.keyMarker = builder.keyMarker;
        this.uploadIdMarker = builder.uploadIdMarker;
        this.nextKeyMarker = builder.nextKeyMarker;
        this.prefix = builder.prefix;
        this.delimiter = builder.delimiter;
        this.nextUploadIdMarker = builder.nextUploadIdMarker;
        this.maxUploads = builder.maxUploads;
        this.isTruncated = builder.isTruncated;
        this.uploads = builder.uploads;
        this.commonPrefixes = builder.commonPrefixes;
        this.encodingType = builder.encodingType;
    }

    /**
     * Name of the bucket to which the multipart upload was initiated.
     * 
     * @return Name of the bucket to which the multipart upload was initiated.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * The key at or after which the listing began.
     * 
     * @return The key at or after which the listing began.
     */
    public String keyMarker() {
        return keyMarker;
    }

    /**
     * Upload ID after which listing began.
     * 
     * @return Upload ID after which listing began.
     */
    public String uploadIdMarker() {
        return uploadIdMarker;
    }

    /**
     * When a list is truncated, this element specifies the value that should be used for the key-marker request
     * parameter in a subsequent request.
     * 
     * @return When a list is truncated, this element specifies the value that should be used for the key-marker request
     *         parameter in a subsequent request.
     */
    public String nextKeyMarker() {
        return nextKeyMarker;
    }

    /**
     * When a prefix is provided in the request, this field contains the specified prefix. The result contains only keys
     * starting with the specified prefix.
     * 
     * @return When a prefix is provided in the request, this field contains the specified prefix. The result contains
     *         only keys starting with the specified prefix.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * Returns the value of the Delimiter property for this object.
     * 
     * @return The value of the Delimiter property for this object.
     */
    public String delimiter() {
        return delimiter;
    }

    /**
     * When a list is truncated, this element specifies the value that should be used for the upload-id-marker request
     * parameter in a subsequent request.
     * 
     * @return When a list is truncated, this element specifies the value that should be used for the upload-id-marker
     *         request parameter in a subsequent request.
     */
    public String nextUploadIdMarker() {
        return nextUploadIdMarker;
    }

    /**
     * Maximum number of multipart uploads that could have been included in the response.
     * 
     * @return Maximum number of multipart uploads that could have been included in the response.
     */
    public Integer maxUploads() {
        return maxUploads;
    }

    /**
     * Indicates whether the returned list of multipart uploads is truncated. A value of true indicates that the list
     * was truncated. The list can be truncated if the number of multipart uploads exceeds the limit allowed or
     * specified by max uploads.
     * 
     * @return Indicates whether the returned list of multipart uploads is truncated. A value of true indicates that the
     *         list was truncated. The list can be truncated if the number of multipart uploads exceeds the limit
     *         allowed or specified by max uploads.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * Returns the value of the Uploads property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Uploads property for this object.
     */
    public List<MultipartUpload> uploads() {
        return uploads;
    }

    /**
     * Returns the value of the CommonPrefixes property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the CommonPrefixes property for this object.
     */
    public List<CommonPrefix> commonPrefixes() {
        return commonPrefixes;
    }

    /**
     * Encoding type used by Amazon S3 to encode object keys in the response.
     * 
     * @return Encoding type used by Amazon S3 to encode object keys in the response.
     * @see EncodingType
     */
    public String encodingType() {
        return encodingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((keyMarker() == null) ? 0 : keyMarker().hashCode());
        hashCode = 31 * hashCode + ((uploadIdMarker() == null) ? 0 : uploadIdMarker().hashCode());
        hashCode = 31 * hashCode + ((nextKeyMarker() == null) ? 0 : nextKeyMarker().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((delimiter() == null) ? 0 : delimiter().hashCode());
        hashCode = 31 * hashCode + ((nextUploadIdMarker() == null) ? 0 : nextUploadIdMarker().hashCode());
        hashCode = 31 * hashCode + ((maxUploads() == null) ? 0 : maxUploads().hashCode());
        hashCode = 31 * hashCode + ((isTruncated() == null) ? 0 : isTruncated().hashCode());
        hashCode = 31 * hashCode + ((uploads() == null) ? 0 : uploads().hashCode());
        hashCode = 31 * hashCode + ((commonPrefixes() == null) ? 0 : commonPrefixes().hashCode());
        hashCode = 31 * hashCode + ((encodingType() == null) ? 0 : encodingType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultipartUploadsResponse)) {
            return false;
        }
        ListMultipartUploadsResponse other = (ListMultipartUploadsResponse) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.keyMarker() == null ^ this.keyMarker() == null) {
            return false;
        }
        if (other.keyMarker() != null && !other.keyMarker().equals(this.keyMarker())) {
            return false;
        }
        if (other.uploadIdMarker() == null ^ this.uploadIdMarker() == null) {
            return false;
        }
        if (other.uploadIdMarker() != null && !other.uploadIdMarker().equals(this.uploadIdMarker())) {
            return false;
        }
        if (other.nextKeyMarker() == null ^ this.nextKeyMarker() == null) {
            return false;
        }
        if (other.nextKeyMarker() != null && !other.nextKeyMarker().equals(this.nextKeyMarker())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.delimiter() == null ^ this.delimiter() == null) {
            return false;
        }
        if (other.delimiter() != null && !other.delimiter().equals(this.delimiter())) {
            return false;
        }
        if (other.nextUploadIdMarker() == null ^ this.nextUploadIdMarker() == null) {
            return false;
        }
        if (other.nextUploadIdMarker() != null && !other.nextUploadIdMarker().equals(this.nextUploadIdMarker())) {
            return false;
        }
        if (other.maxUploads() == null ^ this.maxUploads() == null) {
            return false;
        }
        if (other.maxUploads() != null && !other.maxUploads().equals(this.maxUploads())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.uploads() == null ^ this.uploads() == null) {
            return false;
        }
        if (other.uploads() != null && !other.uploads().equals(this.uploads())) {
            return false;
        }
        if (other.commonPrefixes() == null ^ this.commonPrefixes() == null) {
            return false;
        }
        if (other.commonPrefixes() != null && !other.commonPrefixes().equals(this.commonPrefixes())) {
            return false;
        }
        if (other.encodingType() == null ^ this.encodingType() == null) {
            return false;
        }
        if (other.encodingType() != null && !other.encodingType().equals(this.encodingType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (keyMarker() != null) {
            sb.append("KeyMarker: ").append(keyMarker()).append(",");
        }
        if (uploadIdMarker() != null) {
            sb.append("UploadIdMarker: ").append(uploadIdMarker()).append(",");
        }
        if (nextKeyMarker() != null) {
            sb.append("NextKeyMarker: ").append(nextKeyMarker()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (delimiter() != null) {
            sb.append("Delimiter: ").append(delimiter()).append(",");
        }
        if (nextUploadIdMarker() != null) {
            sb.append("NextUploadIdMarker: ").append(nextUploadIdMarker()).append(",");
        }
        if (maxUploads() != null) {
            sb.append("MaxUploads: ").append(maxUploads()).append(",");
        }
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (uploads() != null) {
            sb.append("Uploads: ").append(uploads()).append(",");
        }
        if (commonPrefixes() != null) {
            sb.append("CommonPrefixes: ").append(commonPrefixes()).append(",");
        }
        if (encodingType() != null) {
            sb.append("EncodingType: ").append(encodingType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListMultipartUploadsResponse> {
        /**
         * Name of the bucket to which the multipart upload was initiated.
         * 
         * @param bucket
         *        Name of the bucket to which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * The key at or after which the listing began.
         * 
         * @param keyMarker
         *        The key at or after which the listing began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyMarker(String keyMarker);

        /**
         * Upload ID after which listing began.
         * 
         * @param uploadIdMarker
         *        Upload ID after which listing began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadIdMarker(String uploadIdMarker);

        /**
         * When a list is truncated, this element specifies the value that should be used for the key-marker request
         * parameter in a subsequent request.
         * 
         * @param nextKeyMarker
         *        When a list is truncated, this element specifies the value that should be used for the key-marker
         *        request parameter in a subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextKeyMarker(String nextKeyMarker);

        /**
         * When a prefix is provided in the request, this field contains the specified prefix. The result contains only
         * keys starting with the specified prefix.
         * 
         * @param prefix
         *        When a prefix is provided in the request, this field contains the specified prefix. The result
         *        contains only keys starting with the specified prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * Sets the value of the Delimiter property for this object.
         *
         * @param delimiter
         *        The new value for the Delimiter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimiter(String delimiter);

        /**
         * When a list is truncated, this element specifies the value that should be used for the upload-id-marker
         * request parameter in a subsequent request.
         * 
         * @param nextUploadIdMarker
         *        When a list is truncated, this element specifies the value that should be used for the
         *        upload-id-marker request parameter in a subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextUploadIdMarker(String nextUploadIdMarker);

        /**
         * Maximum number of multipart uploads that could have been included in the response.
         * 
         * @param maxUploads
         *        Maximum number of multipart uploads that could have been included in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUploads(Integer maxUploads);

        /**
         * Indicates whether the returned list of multipart uploads is truncated. A value of true indicates that the
         * list was truncated. The list can be truncated if the number of multipart uploads exceeds the limit allowed or
         * specified by max uploads.
         * 
         * @param isTruncated
         *        Indicates whether the returned list of multipart uploads is truncated. A value of true indicates that
         *        the list was truncated. The list can be truncated if the number of multipart uploads exceeds the limit
         *        allowed or specified by max uploads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * Sets the value of the Uploads property for this object.
         *
         * @param uploads
         *        The new value for the Uploads property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploads(Collection<MultipartUpload> uploads);

        /**
         * Sets the value of the Uploads property for this object.
         *
         * @param uploads
         *        The new value for the Uploads property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploads(MultipartUpload... uploads);

        /**
         * Sets the value of the CommonPrefixes property for this object.
         *
         * @param commonPrefixes
         *        The new value for the CommonPrefixes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonPrefixes(Collection<CommonPrefix> commonPrefixes);

        /**
         * Sets the value of the CommonPrefixes property for this object.
         *
         * @param commonPrefixes
         *        The new value for the CommonPrefixes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonPrefixes(CommonPrefix... commonPrefixes);

        /**
         * Encoding type used by Amazon S3 to encode object keys in the response.
         * 
         * @param encodingType
         *        Encoding type used by Amazon S3 to encode object keys in the response.
         * @see EncodingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(String encodingType);

        /**
         * Encoding type used by Amazon S3 to encode object keys in the response.
         * 
         * @param encodingType
         *        Encoding type used by Amazon S3 to encode object keys in the response.
         * @see EncodingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(EncodingType encodingType);
    }

    private static final class BuilderImpl implements Builder {
        private String bucket;

        private String keyMarker;

        private String uploadIdMarker;

        private String nextKeyMarker;

        private String prefix;

        private String delimiter;

        private String nextUploadIdMarker;

        private Integer maxUploads;

        private Boolean isTruncated;

        private List<MultipartUpload> uploads;

        private List<CommonPrefix> commonPrefixes;

        private String encodingType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultipartUploadsResponse model) {
            setBucket(model.bucket);
            setKeyMarker(model.keyMarker);
            setUploadIdMarker(model.uploadIdMarker);
            setNextKeyMarker(model.nextKeyMarker);
            setPrefix(model.prefix);
            setDelimiter(model.delimiter);
            setNextUploadIdMarker(model.nextUploadIdMarker);
            setMaxUploads(model.maxUploads);
            setIsTruncated(model.isTruncated);
            setUploads(model.uploads);
            setCommonPrefixes(model.commonPrefixes);
            setEncodingType(model.encodingType);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKeyMarker() {
            return keyMarker;
        }

        @Override
        public final Builder keyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
            return this;
        }

        public final void setKeyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
        }

        public final String getUploadIdMarker() {
            return uploadIdMarker;
        }

        @Override
        public final Builder uploadIdMarker(String uploadIdMarker) {
            this.uploadIdMarker = uploadIdMarker;
            return this;
        }

        public final void setUploadIdMarker(String uploadIdMarker) {
            this.uploadIdMarker = uploadIdMarker;
        }

        public final String getNextKeyMarker() {
            return nextKeyMarker;
        }

        @Override
        public final Builder nextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
            return this;
        }

        public final void setNextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getDelimiter() {
            return delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final String getNextUploadIdMarker() {
            return nextUploadIdMarker;
        }

        @Override
        public final Builder nextUploadIdMarker(String nextUploadIdMarker) {
            this.nextUploadIdMarker = nextUploadIdMarker;
            return this;
        }

        public final void setNextUploadIdMarker(String nextUploadIdMarker) {
            this.nextUploadIdMarker = nextUploadIdMarker;
        }

        public final Integer getMaxUploads() {
            return maxUploads;
        }

        @Override
        public final Builder maxUploads(Integer maxUploads) {
            this.maxUploads = maxUploads;
            return this;
        }

        public final void setMaxUploads(Integer maxUploads) {
            this.maxUploads = maxUploads;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final Collection<MultipartUpload> getUploads() {
            return uploads;
        }

        @Override
        public final Builder uploads(Collection<MultipartUpload> uploads) {
            this.uploads = MultipartUploadListCopier.copy(uploads);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploads(MultipartUpload... uploads) {
            uploads(Arrays.asList(uploads));
            return this;
        }

        public final void setUploads(Collection<MultipartUpload> uploads) {
            this.uploads = MultipartUploadListCopier.copy(uploads);
        }

        @SafeVarargs
        public final void setUploads(MultipartUpload... uploads) {
            uploads(Arrays.asList(uploads));
        }

        public final Collection<CommonPrefix> getCommonPrefixes() {
            return commonPrefixes;
        }

        @Override
        public final Builder commonPrefixes(Collection<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copy(commonPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonPrefixes(CommonPrefix... commonPrefixes) {
            commonPrefixes(Arrays.asList(commonPrefixes));
            return this;
        }

        public final void setCommonPrefixes(Collection<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copy(commonPrefixes);
        }

        @SafeVarargs
        public final void setCommonPrefixes(CommonPrefix... commonPrefixes) {
            commonPrefixes(Arrays.asList(commonPrefixes));
        }

        public final String getEncodingType() {
            return encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        public final void setEncodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
        }

        @Override
        public ListMultipartUploadsResponse build() {
            return new ListMultipartUploadsResponse(this);
        }
    }
}
