/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The Filter is used to identify objects that a Lifecycle Rule applies to. A Filter must have exactly one of Prefix,
 * Tag, or And specified.
 */
@Generated("software.amazon.awssdk:codegen")
public class LifecycleRuleFilter implements ToCopyableBuilder<LifecycleRuleFilter.Builder, LifecycleRuleFilter> {
    private final String prefix;

    private final Tag tag;

    private final LifecycleRuleAndOperator and;

    private LifecycleRuleFilter(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.tag = builder.tag;
        this.and = builder.and;
    }

    /**
     * Prefix identifying one or more objects to which the rule applies.
     * 
     * @return Prefix identifying one or more objects to which the rule applies.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * This tag must exist in the object's tag set in order for the rule to apply.
     * 
     * @return This tag must exist in the object's tag set in order for the rule to apply.
     */
    public Tag tag() {
        return tag;
    }

    /**
     * Returns the value of the And property for this object.
     * 
     * @return The value of the And property for this object.
     */
    public LifecycleRuleAndOperator and() {
        return and;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((tag() == null) ? 0 : tag().hashCode());
        hashCode = 31 * hashCode + ((and() == null) ? 0 : and().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleRuleFilter)) {
            return false;
        }
        LifecycleRuleFilter other = (LifecycleRuleFilter) obj;
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.tag() == null ^ this.tag() == null) {
            return false;
        }
        if (other.tag() != null && !other.tag().equals(this.tag())) {
            return false;
        }
        if (other.and() == null ^ this.and() == null) {
            return false;
        }
        if (other.and() != null && !other.and().equals(this.and())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (tag() != null) {
            sb.append("Tag: ").append(tag()).append(",");
        }
        if (and() != null) {
            sb.append("And: ").append(and()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, LifecycleRuleFilter> {
        /**
         * Prefix identifying one or more objects to which the rule applies.
         * 
         * @param prefix
         *        Prefix identifying one or more objects to which the rule applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * This tag must exist in the object's tag set in order for the rule to apply.
         * 
         * @param tag
         *        This tag must exist in the object's tag set in order for the rule to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tag(Tag tag);

        /**
         * Sets the value of the And property for this object.
         *
         * @param and
         *        The new value for the And property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(LifecycleRuleAndOperator and);
    }

    private static final class BuilderImpl implements Builder {
        private String prefix;

        private Tag tag;

        private LifecycleRuleAndOperator and;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleRuleFilter model) {
            setPrefix(model.prefix);
            setTag(model.tag);
            setAnd(model.and);
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final Tag getTag() {
            return tag;
        }

        @Override
        public final Builder tag(Tag tag) {
            this.tag = tag;
            return this;
        }

        public final void setTag(Tag tag) {
            this.tag = tag;
        }

        public final LifecycleRuleAndOperator getAnd() {
            return and;
        }

        @Override
        public final Builder and(LifecycleRuleAndOperator and) {
            this.and = and;
            return this;
        }

        public final void setAnd(LifecycleRuleAndOperator and) {
            this.and = and;
        }

        @Override
        public LifecycleRuleFilter build() {
            return new LifecycleRuleFilter(this);
        }
    }
}
