/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBucketNotificationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBucketNotificationResponse.Builder, GetBucketNotificationResponse> {
    private final TopicConfigurationDeprecated topicConfiguration;

    private final QueueConfigurationDeprecated queueConfiguration;

    private final CloudFunctionConfiguration cloudFunctionConfiguration;

    private GetBucketNotificationResponse(BuilderImpl builder) {
        this.topicConfiguration = builder.topicConfiguration;
        this.queueConfiguration = builder.queueConfiguration;
        this.cloudFunctionConfiguration = builder.cloudFunctionConfiguration;
    }

    /**
     * Returns the value of the TopicConfiguration property for this object.
     * 
     * @return The value of the TopicConfiguration property for this object.
     */
    public TopicConfigurationDeprecated topicConfiguration() {
        return topicConfiguration;
    }

    /**
     * Returns the value of the QueueConfiguration property for this object.
     * 
     * @return The value of the QueueConfiguration property for this object.
     */
    public QueueConfigurationDeprecated queueConfiguration() {
        return queueConfiguration;
    }

    /**
     * Returns the value of the CloudFunctionConfiguration property for this object.
     * 
     * @return The value of the CloudFunctionConfiguration property for this object.
     */
    public CloudFunctionConfiguration cloudFunctionConfiguration() {
        return cloudFunctionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((topicConfiguration() == null) ? 0 : topicConfiguration().hashCode());
        hashCode = 31 * hashCode + ((queueConfiguration() == null) ? 0 : queueConfiguration().hashCode());
        hashCode = 31 * hashCode + ((cloudFunctionConfiguration() == null) ? 0 : cloudFunctionConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketNotificationResponse)) {
            return false;
        }
        GetBucketNotificationResponse other = (GetBucketNotificationResponse) obj;
        if (other.topicConfiguration() == null ^ this.topicConfiguration() == null) {
            return false;
        }
        if (other.topicConfiguration() != null && !other.topicConfiguration().equals(this.topicConfiguration())) {
            return false;
        }
        if (other.queueConfiguration() == null ^ this.queueConfiguration() == null) {
            return false;
        }
        if (other.queueConfiguration() != null && !other.queueConfiguration().equals(this.queueConfiguration())) {
            return false;
        }
        if (other.cloudFunctionConfiguration() == null ^ this.cloudFunctionConfiguration() == null) {
            return false;
        }
        if (other.cloudFunctionConfiguration() != null
                && !other.cloudFunctionConfiguration().equals(this.cloudFunctionConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (topicConfiguration() != null) {
            sb.append("TopicConfiguration: ").append(topicConfiguration()).append(",");
        }
        if (queueConfiguration() != null) {
            sb.append("QueueConfiguration: ").append(queueConfiguration()).append(",");
        }
        if (cloudFunctionConfiguration() != null) {
            sb.append("CloudFunctionConfiguration: ").append(cloudFunctionConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetBucketNotificationResponse> {
        /**
         * Sets the value of the TopicConfiguration property for this object.
         *
         * @param topicConfiguration
         *        The new value for the TopicConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicConfiguration(TopicConfigurationDeprecated topicConfiguration);

        /**
         * Sets the value of the QueueConfiguration property for this object.
         *
         * @param queueConfiguration
         *        The new value for the QueueConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueConfiguration(QueueConfigurationDeprecated queueConfiguration);

        /**
         * Sets the value of the CloudFunctionConfiguration property for this object.
         *
         * @param cloudFunctionConfiguration
         *        The new value for the CloudFunctionConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFunctionConfiguration(CloudFunctionConfiguration cloudFunctionConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private TopicConfigurationDeprecated topicConfiguration;

        private QueueConfigurationDeprecated queueConfiguration;

        private CloudFunctionConfiguration cloudFunctionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketNotificationResponse model) {
            setTopicConfiguration(model.topicConfiguration);
            setQueueConfiguration(model.queueConfiguration);
            setCloudFunctionConfiguration(model.cloudFunctionConfiguration);
        }

        public final TopicConfigurationDeprecated getTopicConfiguration() {
            return topicConfiguration;
        }

        @Override
        public final Builder topicConfiguration(TopicConfigurationDeprecated topicConfiguration) {
            this.topicConfiguration = topicConfiguration;
            return this;
        }

        public final void setTopicConfiguration(TopicConfigurationDeprecated topicConfiguration) {
            this.topicConfiguration = topicConfiguration;
        }

        public final QueueConfigurationDeprecated getQueueConfiguration() {
            return queueConfiguration;
        }

        @Override
        public final Builder queueConfiguration(QueueConfigurationDeprecated queueConfiguration) {
            this.queueConfiguration = queueConfiguration;
            return this;
        }

        public final void setQueueConfiguration(QueueConfigurationDeprecated queueConfiguration) {
            this.queueConfiguration = queueConfiguration;
        }

        public final CloudFunctionConfiguration getCloudFunctionConfiguration() {
            return cloudFunctionConfiguration;
        }

        @Override
        public final Builder cloudFunctionConfiguration(CloudFunctionConfiguration cloudFunctionConfiguration) {
            this.cloudFunctionConfiguration = cloudFunctionConfiguration;
            return this;
        }

        public final void setCloudFunctionConfiguration(CloudFunctionConfiguration cloudFunctionConfiguration) {
            this.cloudFunctionConfiguration = cloudFunctionConfiguration;
        }

        @Override
        public GetBucketNotificationResponse build() {
            return new GetBucketNotificationResponse(this);
        }
    }
}
