/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeletedObject implements ToCopyableBuilder<DeletedObject.Builder, DeletedObject> {
    private final String key;

    private final String versionId;

    private final Boolean deleteMarker;

    private final String deleteMarkerVersionId;

    private DeletedObject(BuilderImpl builder) {
        this.key = builder.key;
        this.versionId = builder.versionId;
        this.deleteMarker = builder.deleteMarker;
        this.deleteMarkerVersionId = builder.deleteMarkerVersionId;
    }

    /**
     * Returns the value of the Key property for this object.
     * 
     * @return The value of the Key property for this object.
     */
    public String key() {
        return key;
    }

    /**
     * Returns the value of the VersionId property for this object.
     * 
     * @return The value of the VersionId property for this object.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * Returns the value of the DeleteMarker property for this object.
     * 
     * @return The value of the DeleteMarker property for this object.
     */
    public Boolean deleteMarker() {
        return deleteMarker;
    }

    /**
     * Returns the value of the DeleteMarkerVersionId property for this object.
     * 
     * @return The value of the DeleteMarkerVersionId property for this object.
     */
    public String deleteMarkerVersionId() {
        return deleteMarkerVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((versionId() == null) ? 0 : versionId().hashCode());
        hashCode = 31 * hashCode + ((deleteMarker() == null) ? 0 : deleteMarker().hashCode());
        hashCode = 31 * hashCode + ((deleteMarkerVersionId() == null) ? 0 : deleteMarkerVersionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletedObject)) {
            return false;
        }
        DeletedObject other = (DeletedObject) obj;
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.deleteMarker() == null ^ this.deleteMarker() == null) {
            return false;
        }
        if (other.deleteMarker() != null && !other.deleteMarker().equals(this.deleteMarker())) {
            return false;
        }
        if (other.deleteMarkerVersionId() == null ^ this.deleteMarkerVersionId() == null) {
            return false;
        }
        if (other.deleteMarkerVersionId() != null && !other.deleteMarkerVersionId().equals(this.deleteMarkerVersionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (versionId() != null) {
            sb.append("VersionId: ").append(versionId()).append(",");
        }
        if (deleteMarker() != null) {
            sb.append("DeleteMarker: ").append(deleteMarker()).append(",");
        }
        if (deleteMarkerVersionId() != null) {
            sb.append("DeleteMarkerVersionId: ").append(deleteMarkerVersionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeletedObject> {
        /**
         * Sets the value of the Key property for this object.
         *
         * @param key
         *        The new value for the Key property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Sets the value of the VersionId property for this object.
         *
         * @param versionId
         *        The new value for the VersionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * Sets the value of the DeleteMarker property for this object.
         *
         * @param deleteMarker
         *        The new value for the DeleteMarker property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteMarker(Boolean deleteMarker);

        /**
         * Sets the value of the DeleteMarkerVersionId property for this object.
         *
         * @param deleteMarkerVersionId
         *        The new value for the DeleteMarkerVersionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteMarkerVersionId(String deleteMarkerVersionId);
    }

    private static final class BuilderImpl implements Builder {
        private String key;

        private String versionId;

        private Boolean deleteMarker;

        private String deleteMarkerVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletedObject model) {
            setKey(model.key);
            setVersionId(model.versionId);
            setDeleteMarker(model.deleteMarker);
            setDeleteMarkerVersionId(model.deleteMarkerVersionId);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Boolean getDeleteMarker() {
            return deleteMarker;
        }

        @Override
        public final Builder deleteMarker(Boolean deleteMarker) {
            this.deleteMarker = deleteMarker;
            return this;
        }

        public final void setDeleteMarker(Boolean deleteMarker) {
            this.deleteMarker = deleteMarker;
        }

        public final String getDeleteMarkerVersionId() {
            return deleteMarkerVersionId;
        }

        @Override
        public final Builder deleteMarkerVersionId(String deleteMarkerVersionId) {
            this.deleteMarkerVersionId = deleteMarkerVersionId;
            return this;
        }

        public final void setDeleteMarkerVersionId(String deleteMarkerVersionId) {
            this.deleteMarkerVersionId = deleteMarkerVersionId;
        }

        @Override
        public DeletedObject build() {
            return new DeletedObject(this);
        }
    }
}
