/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CORSRule implements ToCopyableBuilder<CORSRule.Builder, CORSRule> {
    private final List<String> allowedHeaders;

    private final List<String> allowedMethods;

    private final List<String> allowedOrigins;

    private final List<String> exposeHeaders;

    private final Integer maxAgeSeconds;

    private CORSRule(BuilderImpl builder) {
        this.allowedHeaders = builder.allowedHeaders;
        this.allowedMethods = builder.allowedMethods;
        this.allowedOrigins = builder.allowedOrigins;
        this.exposeHeaders = builder.exposeHeaders;
        this.maxAgeSeconds = builder.maxAgeSeconds;
    }

    /**
     * Specifies which headers are allowed in a pre-flight OPTIONS request.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies which headers are allowed in a pre-flight OPTIONS request.
     */
    public List<String> allowedHeaders() {
        return allowedHeaders;
    }

    /**
     * Identifies HTTP methods that the domain/origin specified in the rule is allowed to execute.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Identifies HTTP methods that the domain/origin specified in the rule is allowed to execute.
     */
    public List<String> allowedMethods() {
        return allowedMethods;
    }

    /**
     * One or more origins you want customers to be able to access the bucket from.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more origins you want customers to be able to access the bucket from.
     */
    public List<String> allowedOrigins() {
        return allowedOrigins;
    }

    /**
     * One or more headers in the response that you want customers to be able to access from their applications (for
     * example, from a JavaScript XMLHttpRequest object).
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more headers in the response that you want customers to be able to access from their applications
     *         (for example, from a JavaScript XMLHttpRequest object).
     */
    public List<String> exposeHeaders() {
        return exposeHeaders;
    }

    /**
     * The time in seconds that your browser is to cache the preflight response for the specified resource.
     * 
     * @return The time in seconds that your browser is to cache the preflight response for the specified resource.
     */
    public Integer maxAgeSeconds() {
        return maxAgeSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((allowedHeaders() == null) ? 0 : allowedHeaders().hashCode());
        hashCode = 31 * hashCode + ((allowedMethods() == null) ? 0 : allowedMethods().hashCode());
        hashCode = 31 * hashCode + ((allowedOrigins() == null) ? 0 : allowedOrigins().hashCode());
        hashCode = 31 * hashCode + ((exposeHeaders() == null) ? 0 : exposeHeaders().hashCode());
        hashCode = 31 * hashCode + ((maxAgeSeconds() == null) ? 0 : maxAgeSeconds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CORSRule)) {
            return false;
        }
        CORSRule other = (CORSRule) obj;
        if (other.allowedHeaders() == null ^ this.allowedHeaders() == null) {
            return false;
        }
        if (other.allowedHeaders() != null && !other.allowedHeaders().equals(this.allowedHeaders())) {
            return false;
        }
        if (other.allowedMethods() == null ^ this.allowedMethods() == null) {
            return false;
        }
        if (other.allowedMethods() != null && !other.allowedMethods().equals(this.allowedMethods())) {
            return false;
        }
        if (other.allowedOrigins() == null ^ this.allowedOrigins() == null) {
            return false;
        }
        if (other.allowedOrigins() != null && !other.allowedOrigins().equals(this.allowedOrigins())) {
            return false;
        }
        if (other.exposeHeaders() == null ^ this.exposeHeaders() == null) {
            return false;
        }
        if (other.exposeHeaders() != null && !other.exposeHeaders().equals(this.exposeHeaders())) {
            return false;
        }
        if (other.maxAgeSeconds() == null ^ this.maxAgeSeconds() == null) {
            return false;
        }
        if (other.maxAgeSeconds() != null && !other.maxAgeSeconds().equals(this.maxAgeSeconds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (allowedHeaders() != null) {
            sb.append("AllowedHeaders: ").append(allowedHeaders()).append(",");
        }
        if (allowedMethods() != null) {
            sb.append("AllowedMethods: ").append(allowedMethods()).append(",");
        }
        if (allowedOrigins() != null) {
            sb.append("AllowedOrigins: ").append(allowedOrigins()).append(",");
        }
        if (exposeHeaders() != null) {
            sb.append("ExposeHeaders: ").append(exposeHeaders()).append(",");
        }
        if (maxAgeSeconds() != null) {
            sb.append("MaxAgeSeconds: ").append(maxAgeSeconds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CORSRule> {
        /**
         * Specifies which headers are allowed in a pre-flight OPTIONS request.
         * 
         * @param allowedHeaders
         *        Specifies which headers are allowed in a pre-flight OPTIONS request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedHeaders(Collection<String> allowedHeaders);

        /**
         * Specifies which headers are allowed in a pre-flight OPTIONS request.
         * 
         * @param allowedHeaders
         *        Specifies which headers are allowed in a pre-flight OPTIONS request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedHeaders(String... allowedHeaders);

        /**
         * Identifies HTTP methods that the domain/origin specified in the rule is allowed to execute.
         * 
         * @param allowedMethods
         *        Identifies HTTP methods that the domain/origin specified in the rule is allowed to execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedMethods(Collection<String> allowedMethods);

        /**
         * Identifies HTTP methods that the domain/origin specified in the rule is allowed to execute.
         * 
         * @param allowedMethods
         *        Identifies HTTP methods that the domain/origin specified in the rule is allowed to execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedMethods(String... allowedMethods);

        /**
         * One or more origins you want customers to be able to access the bucket from.
         * 
         * @param allowedOrigins
         *        One or more origins you want customers to be able to access the bucket from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOrigins(Collection<String> allowedOrigins);

        /**
         * One or more origins you want customers to be able to access the bucket from.
         * 
         * @param allowedOrigins
         *        One or more origins you want customers to be able to access the bucket from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOrigins(String... allowedOrigins);

        /**
         * One or more headers in the response that you want customers to be able to access from their applications (for
         * example, from a JavaScript XMLHttpRequest object).
         * 
         * @param exposeHeaders
         *        One or more headers in the response that you want customers to be able to access from their
         *        applications (for example, from a JavaScript XMLHttpRequest object).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exposeHeaders(Collection<String> exposeHeaders);

        /**
         * One or more headers in the response that you want customers to be able to access from their applications (for
         * example, from a JavaScript XMLHttpRequest object).
         * 
         * @param exposeHeaders
         *        One or more headers in the response that you want customers to be able to access from their
         *        applications (for example, from a JavaScript XMLHttpRequest object).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exposeHeaders(String... exposeHeaders);

        /**
         * The time in seconds that your browser is to cache the preflight response for the specified resource.
         * 
         * @param maxAgeSeconds
         *        The time in seconds that your browser is to cache the preflight response for the specified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAgeSeconds(Integer maxAgeSeconds);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> allowedHeaders;

        private List<String> allowedMethods;

        private List<String> allowedOrigins;

        private List<String> exposeHeaders;

        private Integer maxAgeSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CORSRule model) {
            setAllowedHeaders(model.allowedHeaders);
            setAllowedMethods(model.allowedMethods);
            setAllowedOrigins(model.allowedOrigins);
            setExposeHeaders(model.exposeHeaders);
            setMaxAgeSeconds(model.maxAgeSeconds);
        }

        public final Collection<String> getAllowedHeaders() {
            return allowedHeaders;
        }

        @Override
        public final Builder allowedHeaders(Collection<String> allowedHeaders) {
            this.allowedHeaders = AllowedHeadersCopier.copy(allowedHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedHeaders(String... allowedHeaders) {
            allowedHeaders(Arrays.asList(allowedHeaders));
            return this;
        }

        public final void setAllowedHeaders(Collection<String> allowedHeaders) {
            this.allowedHeaders = AllowedHeadersCopier.copy(allowedHeaders);
        }

        @SafeVarargs
        public final void setAllowedHeaders(String... allowedHeaders) {
            allowedHeaders(Arrays.asList(allowedHeaders));
        }

        public final Collection<String> getAllowedMethods() {
            return allowedMethods;
        }

        @Override
        public final Builder allowedMethods(Collection<String> allowedMethods) {
            this.allowedMethods = AllowedMethodsCopier.copy(allowedMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedMethods(String... allowedMethods) {
            allowedMethods(Arrays.asList(allowedMethods));
            return this;
        }

        public final void setAllowedMethods(Collection<String> allowedMethods) {
            this.allowedMethods = AllowedMethodsCopier.copy(allowedMethods);
        }

        @SafeVarargs
        public final void setAllowedMethods(String... allowedMethods) {
            allowedMethods(Arrays.asList(allowedMethods));
        }

        public final Collection<String> getAllowedOrigins() {
            return allowedOrigins;
        }

        @Override
        public final Builder allowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = AllowedOriginsCopier.copy(allowedOrigins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOrigins(String... allowedOrigins) {
            allowedOrigins(Arrays.asList(allowedOrigins));
            return this;
        }

        public final void setAllowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = AllowedOriginsCopier.copy(allowedOrigins);
        }

        @SafeVarargs
        public final void setAllowedOrigins(String... allowedOrigins) {
            allowedOrigins(Arrays.asList(allowedOrigins));
        }

        public final Collection<String> getExposeHeaders() {
            return exposeHeaders;
        }

        @Override
        public final Builder exposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = ExposeHeadersCopier.copy(exposeHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exposeHeaders(String... exposeHeaders) {
            exposeHeaders(Arrays.asList(exposeHeaders));
            return this;
        }

        public final void setExposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = ExposeHeadersCopier.copy(exposeHeaders);
        }

        @SafeVarargs
        public final void setExposeHeaders(String... exposeHeaders) {
            exposeHeaders(Arrays.asList(exposeHeaders));
        }

        public final Integer getMaxAgeSeconds() {
            return maxAgeSeconds;
        }

        @Override
        public final Builder maxAgeSeconds(Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
            return this;
        }

        public final void setMaxAgeSeconds(Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
        }

        @Override
        public CORSRule build() {
            return new CORSRule(this);
        }
    }
}
