/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.s3.model.Rule;
import software.amazon.awssdk.services.s3.model.RulesCopier;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBucketLifecycleResponse
extends S3Response
implements ToCopyableBuilder<Builder, GetBucketLifecycleResponse> {
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetBucketLifecycleResponse.getter(GetBucketLifecycleResponse::rules)).setter(GetBucketLifecycleResponse.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").unmarshallLocationName("Rule").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).isFlattened(true).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_FIELD));
    private final List<Rule> rules;

    private GetBucketLifecycleResponse(BuilderImpl builder) {
        super(builder);
        this.rules = builder.rules;
    }

    public List<Rule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketLifecycleResponse)) {
            return false;
        }
        GetBucketLifecycleResponse other = (GetBucketLifecycleResponse)((Object)obj);
        return Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        return ToString.builder((String)"GetBucketLifecycleResponse").add("Rules", this.rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketLifecycleResponse, T> g) {
        return obj -> g.apply((GetBucketLifecycleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketLifecycleResponse model) {
            super(model);
            this.rules(model.rules);
        }

        public final Collection<Rule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(Rule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (Rule)((Rule.Builder)Rule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RulesCopier.copyFromBuilder(rules);
        }

        @Override
        public GetBucketLifecycleResponse build() {
            return new GetBucketLifecycleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBucketLifecycleResponse> {
        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder rules(Consumer<Rule.Builder> ... var1);
    }
}

