/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.internal.BucketUtils;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.utils.FunctionalUtils;

@SdkProtectedApi
public final class EndpointAddressInterceptor
implements ExecutionInterceptor {
    private static final List<Class<?>> ACCELERATE_DISABLED_OPERATIONS = Arrays.asList(ListBucketsRequest.class, CreateBucketRequest.class, DeleteBucketRequest.class);

    public SdkHttpFullRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpFullRequest request = context.httpRequest();
        SdkRequest sdkRequest = context.request();
        S3Configuration serviceConfiguration = (S3Configuration)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG);
        SdkHttpFullRequest.Builder mutableRequest = (SdkHttpFullRequest.Builder)request.toBuilder();
        URI endpoint = this.resolveEndpoint(request, sdkRequest, executionAttributes, serviceConfiguration);
        mutableRequest.uri(endpoint);
        if (serviceConfiguration == null || !serviceConfiguration.pathStyleAccessEnabled()) {
            sdkRequest.getValueForField("Bucket", String.class).ifPresent(b -> {
                if (BucketUtils.isVirtualAddressingCompatibleBucketName(b, false)) {
                    this.changeToDnsEndpoint(mutableRequest, (String)b);
                }
            });
        }
        return (SdkHttpFullRequest)mutableRequest.build();
    }

    private URI resolveEndpoint(SdkHttpFullRequest request, SdkRequest originalRequest, ExecutionAttributes executionAttributes, S3Configuration serviceConfiguration) {
        Region region = (Region)executionAttributes.getAttribute(AwsExecutionAttribute.AWS_REGION);
        RegionMetadata regionMetadata = RegionMetadata.of((Region)region);
        String protocol = request.protocol();
        if (EndpointAddressInterceptor.isAccelerateEnabled(serviceConfiguration) && this.isAccelerateSupported(originalRequest)) {
            return EndpointAddressInterceptor.accelerateEndpoint(serviceConfiguration, regionMetadata, protocol);
        }
        if (serviceConfiguration != null && serviceConfiguration.dualstackEnabled()) {
            return EndpointAddressInterceptor.dualstackEndpoint(regionMetadata, protocol);
        }
        return (URI)FunctionalUtils.invokeSafely(() -> new URI(request.protocol(), null, request.host(), request.port(), null, null, null));
    }

    private static URI dualstackEndpoint(RegionMetadata metadata, String protocol) {
        String serviceEndpoint = String.format("%s.%s.%s.%s", "s3", "dualstack", metadata.name(), metadata.domain());
        return EndpointAddressInterceptor.toUri(protocol, serviceEndpoint);
    }

    private static boolean isAccelerateEnabled(S3Configuration serviceConfiguration) {
        return serviceConfiguration != null && serviceConfiguration.accelerateModeEnabled();
    }

    private boolean isAccelerateSupported(Object originalRequest) {
        return !ACCELERATE_DISABLED_OPERATIONS.contains(originalRequest.getClass());
    }

    private static URI accelerateEndpoint(S3Configuration serviceConfiguration, RegionMetadata metadata, String protocol) {
        if (serviceConfiguration.dualstackEnabled()) {
            return EndpointAddressInterceptor.toUri(protocol, "s3-accelerate.dualstack." + metadata.domain());
        }
        return EndpointAddressInterceptor.toUri(protocol, "s3-accelerate." + metadata.domain());
    }

    private static URI toUri(String protocol, String endpoint) {
        try {
            return new URI(String.format("%s://%s", protocol, endpoint));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void changeToDnsEndpoint(SdkHttpFullRequest.Builder mutableRequest, String bucketName) {
        if (mutableRequest.host().startsWith("s3")) {
            String newHost = mutableRequest.host().replaceFirst("s3", bucketName + ".s3");
            String newPath = mutableRequest.encodedPath().replaceFirst("/" + bucketName, "");
            mutableRequest.host(newHost).encodedPath(newPath);
        }
    }
}

