/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Md5Utils;

@SdkProtectedApi
public class AddContentMd5HeaderInterceptor
implements ExecutionInterceptor {
    private static final List<Class> BLACKLIST_METHODS = Arrays.asList(PutObjectRequest.class, UploadPartRequest.class);

    public SdkHttpFullRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpFullRequest request = context.httpRequest();
        if (!BLACKLIST_METHODS.contains(context.request().getClass()) && request.contentStreamProvider().isPresent() && !request.firstMatchingHeader("Content-MD5").isPresent()) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IoUtils.copy((InputStream)((ContentStreamProvider)request.contentStreamProvider().get()).newStream(), (OutputStream)baos);
                return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)request.toBuilder()).putHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])baos.toByteArray())).build();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return request;
    }
}

