/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for filters that define which source objects should be replicated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceSelectionCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceSelectionCriteria.Builder, SourceSelectionCriteria> {
    private static final SdkField<SseKmsEncryptedObjects> SSE_KMS_ENCRYPTED_OBJECTS_FIELD = SdkField
            .<SseKmsEncryptedObjects> builder(MarshallingType.SDK_POJO)
            .getter(getter(SourceSelectionCriteria::sseKmsEncryptedObjects))
            .setter(setter(Builder::sseKmsEncryptedObjects))
            .constructor(SseKmsEncryptedObjects::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseKmsEncryptedObjects")
                    .unmarshallLocationName("SseKmsEncryptedObjects").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SSE_KMS_ENCRYPTED_OBJECTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SseKmsEncryptedObjects sseKmsEncryptedObjects;

    private SourceSelectionCriteria(BuilderImpl builder) {
        this.sseKmsEncryptedObjects = builder.sseKmsEncryptedObjects;
    }

    /**
     * <p>
     * Container for filter information of selection of KMS Encrypted S3 objects. The element is required if you include
     * <code>SourceSelectionCriteria</code> in the replication configuration.
     * </p>
     * 
     * @return Container for filter information of selection of KMS Encrypted S3 objects. The element is required if you
     *         include <code>SourceSelectionCriteria</code> in the replication configuration.
     */
    public SseKmsEncryptedObjects sseKmsEncryptedObjects() {
        return sseKmsEncryptedObjects;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sseKmsEncryptedObjects());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceSelectionCriteria)) {
            return false;
        }
        SourceSelectionCriteria other = (SourceSelectionCriteria) obj;
        return Objects.equals(sseKmsEncryptedObjects(), other.sseKmsEncryptedObjects());
    }

    @Override
    public String toString() {
        return ToString.builder("SourceSelectionCriteria").add("SseKmsEncryptedObjects", sseKmsEncryptedObjects()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SseKmsEncryptedObjects":
            return Optional.ofNullable(clazz.cast(sseKmsEncryptedObjects()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceSelectionCriteria, T> g) {
        return obj -> g.apply((SourceSelectionCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceSelectionCriteria> {
        /**
         * <p>
         * Container for filter information of selection of KMS Encrypted S3 objects. The element is required if you
         * include <code>SourceSelectionCriteria</code> in the replication configuration.
         * </p>
         * 
         * @param sseKmsEncryptedObjects
         *        Container for filter information of selection of KMS Encrypted S3 objects. The element is required if
         *        you include <code>SourceSelectionCriteria</code> in the replication configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseKmsEncryptedObjects(SseKmsEncryptedObjects sseKmsEncryptedObjects);

        /**
         * <p>
         * Container for filter information of selection of KMS Encrypted S3 objects. The element is required if you
         * include <code>SourceSelectionCriteria</code> in the replication configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link SseKmsEncryptedObjects.Builder} avoiding the
         * need to create one manually via {@link SseKmsEncryptedObjects#builder()}.
         *
         * When the {@link Consumer} completes, {@link SseKmsEncryptedObjects.Builder#build()} is called immediately and
         * its result is passed to {@link #sseKmsEncryptedObjects(SseKmsEncryptedObjects)}.
         * 
         * @param sseKmsEncryptedObjects
         *        a consumer that will call methods on {@link SseKmsEncryptedObjects.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseKmsEncryptedObjects(SseKmsEncryptedObjects)
         */
        default Builder sseKmsEncryptedObjects(Consumer<SseKmsEncryptedObjects.Builder> sseKmsEncryptedObjects) {
            return sseKmsEncryptedObjects(SseKmsEncryptedObjects.builder().applyMutation(sseKmsEncryptedObjects).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SseKmsEncryptedObjects sseKmsEncryptedObjects;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceSelectionCriteria model) {
            sseKmsEncryptedObjects(model.sseKmsEncryptedObjects);
        }

        public final SseKmsEncryptedObjects.Builder getSseKmsEncryptedObjects() {
            return sseKmsEncryptedObjects != null ? sseKmsEncryptedObjects.toBuilder() : null;
        }

        @Override
        public final Builder sseKmsEncryptedObjects(SseKmsEncryptedObjects sseKmsEncryptedObjects) {
            this.sseKmsEncryptedObjects = sseKmsEncryptedObjects;
            return this;
        }

        public final void setSseKmsEncryptedObjects(SseKmsEncryptedObjects.BuilderImpl sseKmsEncryptedObjects) {
            this.sseKmsEncryptedObjects = sseKmsEncryptedObjects != null ? sseKmsEncryptedObjects.build() : null;
        }

        @Override
        public SourceSelectionCriteria build() {
            return new SourceSelectionCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
