/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rule implements SdkPojo, Serializable, ToCopyableBuilder<Rule.Builder, Rule> {
    private static final SdkField<LifecycleExpiration> EXPIRATION_FIELD = SdkField
            .<LifecycleExpiration> builder(MarshallingType.SDK_POJO)
            .getter(getter(Rule::expiration))
            .setter(setter(Builder::expiration))
            .constructor(LifecycleExpiration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration")
                    .unmarshallLocationName("Expiration").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Rule::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ID").unmarshallLocationName("ID")
                    .build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Rule::prefix))
            .setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix")
                    .unmarshallLocationName("Prefix").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Rule::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<Transition> TRANSITION_FIELD = SdkField
            .<Transition> builder(MarshallingType.SDK_POJO)
            .getter(getter(Rule::transition))
            .setter(setter(Builder::transition))
            .constructor(Transition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transition")
                    .unmarshallLocationName("Transition").build()).build();

    private static final SdkField<NoncurrentVersionTransition> NONCURRENT_VERSION_TRANSITION_FIELD = SdkField
            .<NoncurrentVersionTransition> builder(MarshallingType.SDK_POJO)
            .getter(getter(Rule::noncurrentVersionTransition))
            .setter(setter(Builder::noncurrentVersionTransition))
            .constructor(NoncurrentVersionTransition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoncurrentVersionTransition")
                    .unmarshallLocationName("NoncurrentVersionTransition").build()).build();

    private static final SdkField<NoncurrentVersionExpiration> NONCURRENT_VERSION_EXPIRATION_FIELD = SdkField
            .<NoncurrentVersionExpiration> builder(MarshallingType.SDK_POJO)
            .getter(getter(Rule::noncurrentVersionExpiration))
            .setter(setter(Builder::noncurrentVersionExpiration))
            .constructor(NoncurrentVersionExpiration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoncurrentVersionExpiration")
                    .unmarshallLocationName("NoncurrentVersionExpiration").build()).build();

    private static final SdkField<AbortIncompleteMultipartUpload> ABORT_INCOMPLETE_MULTIPART_UPLOAD_FIELD = SdkField
            .<AbortIncompleteMultipartUpload> builder(MarshallingType.SDK_POJO)
            .getter(getter(Rule::abortIncompleteMultipartUpload))
            .setter(setter(Builder::abortIncompleteMultipartUpload))
            .constructor(AbortIncompleteMultipartUpload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbortIncompleteMultipartUpload")
                    .unmarshallLocationName("AbortIncompleteMultipartUpload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRATION_FIELD, ID_FIELD,
            PREFIX_FIELD, STATUS_FIELD, TRANSITION_FIELD, NONCURRENT_VERSION_TRANSITION_FIELD,
            NONCURRENT_VERSION_EXPIRATION_FIELD, ABORT_INCOMPLETE_MULTIPART_UPLOAD_FIELD));

    private static final long serialVersionUID = 1L;

    private final LifecycleExpiration expiration;

    private final String id;

    private final String prefix;

    private final String status;

    private final Transition transition;

    private final NoncurrentVersionTransition noncurrentVersionTransition;

    private final NoncurrentVersionExpiration noncurrentVersionExpiration;

    private final AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

    private Rule(BuilderImpl builder) {
        this.expiration = builder.expiration;
        this.id = builder.id;
        this.prefix = builder.prefix;
        this.status = builder.status;
        this.transition = builder.transition;
        this.noncurrentVersionTransition = builder.noncurrentVersionTransition;
        this.noncurrentVersionExpiration = builder.noncurrentVersionExpiration;
        this.abortIncompleteMultipartUpload = builder.abortIncompleteMultipartUpload;
    }

    /**
     * Returns the value of the Expiration property for this object.
     * 
     * @return The value of the Expiration property for this object.
     */
    public LifecycleExpiration expiration() {
        return expiration;
    }

    /**
     * <p>
     * Unique identifier for the rule. The value cannot be longer than 255 characters.
     * </p>
     * 
     * @return Unique identifier for the rule. The value cannot be longer than 255 characters.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * Prefix identifying one or more objects to which the rule applies.
     * </p>
     * 
     * @return Prefix identifying one or more objects to which the rule applies.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExpirationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
     *         applied.
     * @see ExpirationStatus
     */
    public ExpirationStatus status() {
        return ExpirationStatus.fromValue(status);
    }

    /**
     * <p>
     * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExpirationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
     *         applied.
     * @see ExpirationStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the Transition property for this object.
     * 
     * @return The value of the Transition property for this object.
     */
    public Transition transition() {
        return transition;
    }

    /**
     * Returns the value of the NoncurrentVersionTransition property for this object.
     * 
     * @return The value of the NoncurrentVersionTransition property for this object.
     */
    public NoncurrentVersionTransition noncurrentVersionTransition() {
        return noncurrentVersionTransition;
    }

    /**
     * Returns the value of the NoncurrentVersionExpiration property for this object.
     * 
     * @return The value of the NoncurrentVersionExpiration property for this object.
     */
    public NoncurrentVersionExpiration noncurrentVersionExpiration() {
        return noncurrentVersionExpiration;
    }

    /**
     * Returns the value of the AbortIncompleteMultipartUpload property for this object.
     * 
     * @return The value of the AbortIncompleteMultipartUpload property for this object.
     */
    public AbortIncompleteMultipartUpload abortIncompleteMultipartUpload() {
        return abortIncompleteMultipartUpload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transition());
        hashCode = 31 * hashCode + Objects.hashCode(noncurrentVersionTransition());
        hashCode = 31 * hashCode + Objects.hashCode(noncurrentVersionExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(abortIncompleteMultipartUpload());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule) obj;
        return Objects.equals(expiration(), other.expiration()) && Objects.equals(id(), other.id())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(transition(), other.transition())
                && Objects.equals(noncurrentVersionTransition(), other.noncurrentVersionTransition())
                && Objects.equals(noncurrentVersionExpiration(), other.noncurrentVersionExpiration())
                && Objects.equals(abortIncompleteMultipartUpload(), other.abortIncompleteMultipartUpload());
    }

    @Override
    public String toString() {
        return ToString.builder("Rule").add("Expiration", expiration()).add("ID", id()).add("Prefix", prefix())
                .add("Status", statusAsString()).add("Transition", transition())
                .add("NoncurrentVersionTransition", noncurrentVersionTransition())
                .add("NoncurrentVersionExpiration", noncurrentVersionExpiration())
                .add("AbortIncompleteMultipartUpload", abortIncompleteMultipartUpload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expiration":
            return Optional.ofNullable(clazz.cast(expiration()));
        case "ID":
            return Optional.ofNullable(clazz.cast(id()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Transition":
            return Optional.ofNullable(clazz.cast(transition()));
        case "NoncurrentVersionTransition":
            return Optional.ofNullable(clazz.cast(noncurrentVersionTransition()));
        case "NoncurrentVersionExpiration":
            return Optional.ofNullable(clazz.cast(noncurrentVersionExpiration()));
        case "AbortIncompleteMultipartUpload":
            return Optional.ofNullable(clazz.cast(abortIncompleteMultipartUpload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Rule> {
        /**
         * Sets the value of the Expiration property for this object.
         *
         * @param expiration
         *        The new value for the Expiration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(LifecycleExpiration expiration);

        /**
         * Sets the value of the Expiration property for this object.
         *
         * This is a convenience that creates an instance of the {@link LifecycleExpiration.Builder} avoiding the need
         * to create one manually via {@link LifecycleExpiration#builder()}.
         *
         * When the {@link Consumer} completes, {@link LifecycleExpiration.Builder#build()} is called immediately and
         * its result is passed to {@link #expiration(LifecycleExpiration)}.
         * 
         * @param expiration
         *        a consumer that will call methods on {@link LifecycleExpiration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expiration(LifecycleExpiration)
         */
        default Builder expiration(Consumer<LifecycleExpiration.Builder> expiration) {
            return expiration(LifecycleExpiration.builder().applyMutation(expiration).build());
        }

        /**
         * <p>
         * Unique identifier for the rule. The value cannot be longer than 255 characters.
         * </p>
         * 
         * @param id
         *        Unique identifier for the rule. The value cannot be longer than 255 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Prefix identifying one or more objects to which the rule applies.
         * </p>
         * 
         * @param prefix
         *        Prefix identifying one or more objects to which the rule applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
         * </p>
         * 
         * @param status
         *        If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
         *        applied.
         * @see ExpirationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
         * </p>
         * 
         * @param status
         *        If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
         *        applied.
         * @see ExpirationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationStatus
         */
        Builder status(ExpirationStatus status);

        /**
         * Sets the value of the Transition property for this object.
         *
         * @param transition
         *        The new value for the Transition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transition(Transition transition);

        /**
         * Sets the value of the Transition property for this object.
         *
         * This is a convenience that creates an instance of the {@link Transition.Builder} avoiding the need to create
         * one manually via {@link Transition#builder()}.
         *
         * When the {@link Consumer} completes, {@link Transition.Builder#build()} is called immediately and its result
         * is passed to {@link #transition(Transition)}.
         * 
         * @param transition
         *        a consumer that will call methods on {@link Transition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transition(Transition)
         */
        default Builder transition(Consumer<Transition.Builder> transition) {
            return transition(Transition.builder().applyMutation(transition).build());
        }

        /**
         * Sets the value of the NoncurrentVersionTransition property for this object.
         *
         * @param noncurrentVersionTransition
         *        The new value for the NoncurrentVersionTransition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncurrentVersionTransition(NoncurrentVersionTransition noncurrentVersionTransition);

        /**
         * Sets the value of the NoncurrentVersionTransition property for this object.
         *
         * This is a convenience that creates an instance of the {@link NoncurrentVersionTransition.Builder} avoiding
         * the need to create one manually via {@link NoncurrentVersionTransition#builder()}.
         *
         * When the {@link Consumer} completes, {@link NoncurrentVersionTransition.Builder#build()} is called
         * immediately and its result is passed to {@link #noncurrentVersionTransition(NoncurrentVersionTransition)}.
         * 
         * @param noncurrentVersionTransition
         *        a consumer that will call methods on {@link NoncurrentVersionTransition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noncurrentVersionTransition(NoncurrentVersionTransition)
         */
        default Builder noncurrentVersionTransition(Consumer<NoncurrentVersionTransition.Builder> noncurrentVersionTransition) {
            return noncurrentVersionTransition(NoncurrentVersionTransition.builder().applyMutation(noncurrentVersionTransition)
                    .build());
        }

        /**
         * Sets the value of the NoncurrentVersionExpiration property for this object.
         *
         * @param noncurrentVersionExpiration
         *        The new value for the NoncurrentVersionExpiration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration);

        /**
         * Sets the value of the NoncurrentVersionExpiration property for this object.
         *
         * This is a convenience that creates an instance of the {@link NoncurrentVersionExpiration.Builder} avoiding
         * the need to create one manually via {@link NoncurrentVersionExpiration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NoncurrentVersionExpiration.Builder#build()} is called
         * immediately and its result is passed to {@link #noncurrentVersionExpiration(NoncurrentVersionExpiration)}.
         * 
         * @param noncurrentVersionExpiration
         *        a consumer that will call methods on {@link NoncurrentVersionExpiration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noncurrentVersionExpiration(NoncurrentVersionExpiration)
         */
        default Builder noncurrentVersionExpiration(Consumer<NoncurrentVersionExpiration.Builder> noncurrentVersionExpiration) {
            return noncurrentVersionExpiration(NoncurrentVersionExpiration.builder().applyMutation(noncurrentVersionExpiration)
                    .build());
        }

        /**
         * Sets the value of the AbortIncompleteMultipartUpload property for this object.
         *
         * @param abortIncompleteMultipartUpload
         *        The new value for the AbortIncompleteMultipartUpload property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload);

        /**
         * Sets the value of the AbortIncompleteMultipartUpload property for this object.
         *
         * This is a convenience that creates an instance of the {@link AbortIncompleteMultipartUpload.Builder} avoiding
         * the need to create one manually via {@link AbortIncompleteMultipartUpload#builder()}.
         *
         * When the {@link Consumer} completes, {@link AbortIncompleteMultipartUpload.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload)}.
         * 
         * @param abortIncompleteMultipartUpload
         *        a consumer that will call methods on {@link AbortIncompleteMultipartUpload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload)
         */
        default Builder abortIncompleteMultipartUpload(
                Consumer<AbortIncompleteMultipartUpload.Builder> abortIncompleteMultipartUpload) {
            return abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload.builder()
                    .applyMutation(abortIncompleteMultipartUpload).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LifecycleExpiration expiration;

        private String id;

        private String prefix;

        private String status;

        private Transition transition;

        private NoncurrentVersionTransition noncurrentVersionTransition;

        private NoncurrentVersionExpiration noncurrentVersionExpiration;

        private AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            expiration(model.expiration);
            id(model.id);
            prefix(model.prefix);
            status(model.status);
            transition(model.transition);
            noncurrentVersionTransition(model.noncurrentVersionTransition);
            noncurrentVersionExpiration(model.noncurrentVersionExpiration);
            abortIncompleteMultipartUpload(model.abortIncompleteMultipartUpload);
        }

        public final LifecycleExpiration.Builder getExpiration() {
            return expiration != null ? expiration.toBuilder() : null;
        }

        @Override
        public final Builder expiration(LifecycleExpiration expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(LifecycleExpiration.BuilderImpl expiration) {
            this.expiration = expiration != null ? expiration.build() : null;
        }

        public final String getID() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExpirationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Transition.Builder getTransition() {
            return transition != null ? transition.toBuilder() : null;
        }

        @Override
        public final Builder transition(Transition transition) {
            this.transition = transition;
            return this;
        }

        public final void setTransition(Transition.BuilderImpl transition) {
            this.transition = transition != null ? transition.build() : null;
        }

        public final NoncurrentVersionTransition.Builder getNoncurrentVersionTransition() {
            return noncurrentVersionTransition != null ? noncurrentVersionTransition.toBuilder() : null;
        }

        @Override
        public final Builder noncurrentVersionTransition(NoncurrentVersionTransition noncurrentVersionTransition) {
            this.noncurrentVersionTransition = noncurrentVersionTransition;
            return this;
        }

        public final void setNoncurrentVersionTransition(NoncurrentVersionTransition.BuilderImpl noncurrentVersionTransition) {
            this.noncurrentVersionTransition = noncurrentVersionTransition != null ? noncurrentVersionTransition.build() : null;
        }

        public final NoncurrentVersionExpiration.Builder getNoncurrentVersionExpiration() {
            return noncurrentVersionExpiration != null ? noncurrentVersionExpiration.toBuilder() : null;
        }

        @Override
        public final Builder noncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration;
            return this;
        }

        public final void setNoncurrentVersionExpiration(NoncurrentVersionExpiration.BuilderImpl noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration != null ? noncurrentVersionExpiration.build() : null;
        }

        public final AbortIncompleteMultipartUpload.Builder getAbortIncompleteMultipartUpload() {
            return abortIncompleteMultipartUpload != null ? abortIncompleteMultipartUpload.toBuilder() : null;
        }

        @Override
        public final Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
            return this;
        }

        public final void setAbortIncompleteMultipartUpload(
                AbortIncompleteMultipartUpload.BuilderImpl abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload != null ? abortIncompleteMultipartUpload.build()
                    : null;
        }

        @Override
        public Rule build() {
            return new Rule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
