/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for information regarding encryption based configuration for replicas.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionConfiguration.Builder, EncryptionConfiguration> {
    private static final SdkField<String> REPLICA_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(EncryptionConfiguration::replicaKmsKeyID))
            .setter(setter(Builder::replicaKmsKeyID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaKmsKeyID")
                    .unmarshallLocationName("ReplicaKmsKeyID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICA_KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicaKmsKeyID;

    private EncryptionConfiguration(BuilderImpl builder) {
        this.replicaKmsKeyID = builder.replicaKmsKeyID;
    }

    /**
     * <p>
     * The ID of the AWS KMS key for the region where the destination bucket resides. Amazon S3 uses this key to encrypt
     * the replica object.
     * </p>
     * 
     * @return The ID of the AWS KMS key for the region where the destination bucket resides. Amazon S3 uses this key to
     *         encrypt the replica object.
     */
    public String replicaKmsKeyID() {
        return replicaKmsKeyID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicaKmsKeyID());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration) obj;
        return Objects.equals(replicaKmsKeyID(), other.replicaKmsKeyID());
    }

    @Override
    public String toString() {
        return ToString.builder("EncryptionConfiguration").add("ReplicaKmsKeyID", replicaKmsKeyID()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicaKmsKeyID":
            return Optional.ofNullable(clazz.cast(replicaKmsKeyID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfiguration, T> g) {
        return obj -> g.apply((EncryptionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionConfiguration> {
        /**
         * <p>
         * The ID of the AWS KMS key for the region where the destination bucket resides. Amazon S3 uses this key to
         * encrypt the replica object.
         * </p>
         * 
         * @param replicaKmsKeyID
         *        The ID of the AWS KMS key for the region where the destination bucket resides. Amazon S3 uses this key
         *        to encrypt the replica object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaKmsKeyID(String replicaKmsKeyID);
    }

    static final class BuilderImpl implements Builder {
        private String replicaKmsKeyID;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfiguration model) {
            replicaKmsKeyID(model.replicaKmsKeyID);
        }

        public final String getReplicaKmsKeyID() {
            return replicaKmsKeyID;
        }

        @Override
        public final Builder replicaKmsKeyID(String replicaKmsKeyID) {
            this.replicaKmsKeyID = replicaKmsKeyID;
            return this;
        }

        public final void setReplicaKmsKeyID(String replicaKmsKeyID) {
            this.replicaKmsKeyID = replicaKmsKeyID;
        }

        @Override
        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
