/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for information regarding the access control for replicas.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessControlTranslation implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessControlTranslation.Builder, AccessControlTranslation> {
    private static final SdkField<String> OWNER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AccessControlTranslation::ownerAsString))
            .setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner")
                    .unmarshallLocationName("Owner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String owner;

    private AccessControlTranslation(BuilderImpl builder) {
        this.owner = builder.owner;
    }

    /**
     * <p>
     * The override value for the owner of the replica object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link OwnerOverride#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return The override value for the owner of the replica object.
     * @see OwnerOverride
     */
    public OwnerOverride owner() {
        return OwnerOverride.fromValue(owner);
    }

    /**
     * <p>
     * The override value for the owner of the replica object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link OwnerOverride#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return The override value for the owner of the replica object.
     * @see OwnerOverride
     */
    public String ownerAsString() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessControlTranslation)) {
            return false;
        }
        AccessControlTranslation other = (AccessControlTranslation) obj;
        return Objects.equals(ownerAsString(), other.ownerAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("AccessControlTranslation").add("Owner", ownerAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Owner":
            return Optional.ofNullable(clazz.cast(ownerAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessControlTranslation, T> g) {
        return obj -> g.apply((AccessControlTranslation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessControlTranslation> {
        /**
         * <p>
         * The override value for the owner of the replica object.
         * </p>
         * 
         * @param owner
         *        The override value for the owner of the replica object.
         * @see OwnerOverride
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OwnerOverride
         */
        Builder owner(String owner);

        /**
         * <p>
         * The override value for the owner of the replica object.
         * </p>
         * 
         * @param owner
         *        The override value for the owner of the replica object.
         * @see OwnerOverride
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OwnerOverride
         */
        Builder owner(OwnerOverride owner);
    }

    static final class BuilderImpl implements Builder {
        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessControlTranslation model) {
            owner(model.owner);
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(OwnerOverride owner) {
            this.owner(owner.toString());
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public AccessControlTranslation build() {
            return new AccessControlTranslation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
