/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringConversion;

/**
 * UploadPartRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UploadPartRequestMarshaller implements Marshaller<Request<UploadPartRequest>, UploadPartRequest> {

    public Request<UploadPartRequest> marshall(UploadPartRequest uploadPartRequest) {

        if (uploadPartRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<UploadPartRequest> request = new DefaultRequest<UploadPartRequest>(uploadPartRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (uploadPartRequest.contentLength() != null) {
            request.addHeader("Content-Length", StringConversion.fromLong(uploadPartRequest.contentLength()));
        }

        if (uploadPartRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString(uploadPartRequest.contentMD5()));
        }

        if (uploadPartRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm",
                    StringConversion.fromString(uploadPartRequest.sseCustomerAlgorithm()));
        }

        if (uploadPartRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key",
                    StringConversion.fromString(uploadPartRequest.sseCustomerKey()));
        }

        if (uploadPartRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5",
                    StringConversion.fromString(uploadPartRequest.sseCustomerKeyMD5()));
        }

        if (uploadPartRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString(uploadPartRequest.requestPayerAsString()));
        }

        String uriResourcePath = "/{Bucket}/{Key+}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", uploadPartRequest.bucket());
        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.GREEDY.marshall(uriResourcePath, "Key",
                uploadPartRequest.key());
        request.setResourcePath(uriResourcePath);

        if (uploadPartRequest.partNumber() != null) {
            request.addParameter("partNumber", StringConversion.fromInteger(uploadPartRequest.partNumber()));
        }

        if (uploadPartRequest.uploadId() != null) {
            request.addParameter("uploadId", StringConversion.fromString(uploadPartRequest.uploadId()));
        }

        return request;
    }

}