/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.utils.StringInputStream;

import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.core.util.xml.XmlWriter;

/**
 * PutBucketNotificationConfigurationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketNotificationConfigurationRequestMarshaller implements
        Marshaller<Request<PutBucketNotificationConfigurationRequest>, PutBucketNotificationConfigurationRequest> {

    public Request<PutBucketNotificationConfigurationRequest> marshall(
            PutBucketNotificationConfigurationRequest putBucketNotificationConfigurationRequest) {

        if (putBucketNotificationConfigurationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<PutBucketNotificationConfigurationRequest> request = new DefaultRequest<PutBucketNotificationConfigurationRequest>(
                putBucketNotificationConfigurationRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        String uriResourcePath = "/{Bucket}?notification";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", putBucketNotificationConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            NotificationConfiguration notificationConfiguration = putBucketNotificationConfigurationRequest
                    .notificationConfiguration();
            if (notificationConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("NotificationConfiguration");

                java.util.List<TopicConfiguration> notificationConfigurationTopicConfigurationsList = notificationConfiguration
                        .topicConfigurations();
                if (!notificationConfigurationTopicConfigurationsList.isEmpty()
                        || !(notificationConfigurationTopicConfigurationsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    for (TopicConfiguration notificationConfigurationTopicConfigurationsListValue : notificationConfigurationTopicConfigurationsList) {
                        xmlWriter.startElement("TopicConfiguration");

                        if (notificationConfigurationTopicConfigurationsListValue.id() != null) {
                            xmlWriter.startElement("Id").value(notificationConfigurationTopicConfigurationsListValue.id())
                                    .endElement();
                        }

                        if (notificationConfigurationTopicConfigurationsListValue.topicArn() != null) {
                            xmlWriter.startElement("Topic")
                                    .value(notificationConfigurationTopicConfigurationsListValue.topicArn()).endElement();
                        }

                        java.util.List<String> topicConfigurationEventsList = notificationConfigurationTopicConfigurationsListValue
                                .eventsAsStrings();
                        if (!topicConfigurationEventsList.isEmpty()
                                || !(topicConfigurationEventsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                            for (String topicConfigurationEventsListValue : topicConfigurationEventsList) {
                                xmlWriter.startElement("Event");
                                xmlWriter.value(topicConfigurationEventsListValue);
                                xmlWriter.endElement();
                            }
                        }

                        NotificationConfigurationFilter filter = notificationConfigurationTopicConfigurationsListValue.filter();
                        if (filter != null) {
                            xmlWriter.startElement("Filter");

                            S3KeyFilter key = filter.key();
                            if (key != null) {
                                xmlWriter.startElement("S3Key");

                                java.util.List<FilterRule> s3KeyFilterFilterRulesList = key.filterRules();
                                if (!s3KeyFilterFilterRulesList.isEmpty()
                                        || !(s3KeyFilterFilterRulesList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                                    for (FilterRule s3KeyFilterFilterRulesListValue : s3KeyFilterFilterRulesList) {
                                        xmlWriter.startElement("FilterRule");

                                        if (s3KeyFilterFilterRulesListValue.nameAsString() != null) {
                                            xmlWriter.startElement("Name").value(s3KeyFilterFilterRulesListValue.nameAsString())
                                                    .endElement();
                                        }

                                        if (s3KeyFilterFilterRulesListValue.value() != null) {
                                            xmlWriter.startElement("Value").value(s3KeyFilterFilterRulesListValue.value())
                                                    .endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }

                java.util.List<QueueConfiguration> notificationConfigurationQueueConfigurationsList = notificationConfiguration
                        .queueConfigurations();
                if (!notificationConfigurationQueueConfigurationsList.isEmpty()
                        || !(notificationConfigurationQueueConfigurationsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    for (QueueConfiguration notificationConfigurationQueueConfigurationsListValue : notificationConfigurationQueueConfigurationsList) {
                        xmlWriter.startElement("QueueConfiguration");

                        if (notificationConfigurationQueueConfigurationsListValue.id() != null) {
                            xmlWriter.startElement("Id").value(notificationConfigurationQueueConfigurationsListValue.id())
                                    .endElement();
                        }

                        if (notificationConfigurationQueueConfigurationsListValue.queueArn() != null) {
                            xmlWriter.startElement("Queue")
                                    .value(notificationConfigurationQueueConfigurationsListValue.queueArn()).endElement();
                        }

                        java.util.List<String> queueConfigurationEventsList = notificationConfigurationQueueConfigurationsListValue
                                .eventsAsStrings();
                        if (!queueConfigurationEventsList.isEmpty()
                                || !(queueConfigurationEventsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                            for (String queueConfigurationEventsListValue : queueConfigurationEventsList) {
                                xmlWriter.startElement("Event");
                                xmlWriter.value(queueConfigurationEventsListValue);
                                xmlWriter.endElement();
                            }
                        }

                        NotificationConfigurationFilter filter = notificationConfigurationQueueConfigurationsListValue.filter();
                        if (filter != null) {
                            xmlWriter.startElement("Filter");

                            S3KeyFilter key = filter.key();
                            if (key != null) {
                                xmlWriter.startElement("S3Key");

                                java.util.List<FilterRule> s3KeyFilterFilterRulesList = key.filterRules();
                                if (!s3KeyFilterFilterRulesList.isEmpty()
                                        || !(s3KeyFilterFilterRulesList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                                    for (FilterRule s3KeyFilterFilterRulesListValue : s3KeyFilterFilterRulesList) {
                                        xmlWriter.startElement("FilterRule");

                                        if (s3KeyFilterFilterRulesListValue.nameAsString() != null) {
                                            xmlWriter.startElement("Name").value(s3KeyFilterFilterRulesListValue.nameAsString())
                                                    .endElement();
                                        }

                                        if (s3KeyFilterFilterRulesListValue.value() != null) {
                                            xmlWriter.startElement("Value").value(s3KeyFilterFilterRulesListValue.value())
                                                    .endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }

                java.util.List<LambdaFunctionConfiguration> notificationConfigurationLambdaFunctionConfigurationsList = notificationConfiguration
                        .lambdaFunctionConfigurations();
                if (!notificationConfigurationLambdaFunctionConfigurationsList.isEmpty()
                        || !(notificationConfigurationLambdaFunctionConfigurationsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    for (LambdaFunctionConfiguration notificationConfigurationLambdaFunctionConfigurationsListValue : notificationConfigurationLambdaFunctionConfigurationsList) {
                        xmlWriter.startElement("CloudFunctionConfiguration");

                        if (notificationConfigurationLambdaFunctionConfigurationsListValue.id() != null) {
                            xmlWriter.startElement("Id")
                                    .value(notificationConfigurationLambdaFunctionConfigurationsListValue.id()).endElement();
                        }

                        if (notificationConfigurationLambdaFunctionConfigurationsListValue.lambdaFunctionArn() != null) {
                            xmlWriter.startElement("CloudFunction")
                                    .value(notificationConfigurationLambdaFunctionConfigurationsListValue.lambdaFunctionArn())
                                    .endElement();
                        }

                        java.util.List<String> lambdaFunctionConfigurationEventsList = notificationConfigurationLambdaFunctionConfigurationsListValue
                                .eventsAsStrings();
                        if (!lambdaFunctionConfigurationEventsList.isEmpty()
                                || !(lambdaFunctionConfigurationEventsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                            for (String lambdaFunctionConfigurationEventsListValue : lambdaFunctionConfigurationEventsList) {
                                xmlWriter.startElement("Event");
                                xmlWriter.value(lambdaFunctionConfigurationEventsListValue);
                                xmlWriter.endElement();
                            }
                        }

                        NotificationConfigurationFilter filter = notificationConfigurationLambdaFunctionConfigurationsListValue
                                .filter();
                        if (filter != null) {
                            xmlWriter.startElement("Filter");

                            S3KeyFilter key = filter.key();
                            if (key != null) {
                                xmlWriter.startElement("S3Key");

                                java.util.List<FilterRule> s3KeyFilterFilterRulesList = key.filterRules();
                                if (!s3KeyFilterFilterRulesList.isEmpty()
                                        || !(s3KeyFilterFilterRulesList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                                    for (FilterRule s3KeyFilterFilterRulesListValue : s3KeyFilterFilterRulesList) {
                                        xmlWriter.startElement("FilterRule");

                                        if (s3KeyFilterFilterRulesListValue.nameAsString() != null) {
                                            xmlWriter.startElement("Name").value(s3KeyFilterFilterRulesListValue.nameAsString())
                                                    .endElement();
                                        }

                                        if (s3KeyFilterFilterRulesListValue.value() != null) {
                                            xmlWriter.startElement("Value").value(s3KeyFilterFilterRulesListValue.value())
                                                    .endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF_8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }

        return request;
    }

}