/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.utils.StringInputStream;
import software.amazon.awssdk.core.util.StringConversion;

import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.core.util.xml.XmlWriter;

/**
 * PutBucketLifecycleRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketLifecycleRequestMarshaller implements
        Marshaller<Request<PutBucketLifecycleRequest>, PutBucketLifecycleRequest> {

    public Request<PutBucketLifecycleRequest> marshall(PutBucketLifecycleRequest putBucketLifecycleRequest) {

        if (putBucketLifecycleRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<PutBucketLifecycleRequest> request = new DefaultRequest<PutBucketLifecycleRequest>(putBucketLifecycleRequest,
                "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (putBucketLifecycleRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString(putBucketLifecycleRequest.contentMD5()));
        }

        String uriResourcePath = "/{Bucket}?lifecycle";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", putBucketLifecycleRequest.bucket());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            LifecycleConfiguration lifecycleConfiguration = putBucketLifecycleRequest.lifecycleConfiguration();
            if (lifecycleConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("LifecycleConfiguration");

                java.util.List<Rule> lifecycleConfigurationRulesList = lifecycleConfiguration.rules();
                if (!lifecycleConfigurationRulesList.isEmpty()
                        || !(lifecycleConfigurationRulesList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    for (Rule lifecycleConfigurationRulesListValue : lifecycleConfigurationRulesList) {
                        xmlWriter.startElement("Rule");

                        LifecycleExpiration expiration = lifecycleConfigurationRulesListValue.expiration();
                        if (expiration != null) {
                            xmlWriter.startElement("Expiration");

                            if (expiration.date() != null) {
                                xmlWriter.startElement("Date").value(expiration.date()).endElement();
                            }

                            if (expiration.days() != null) {
                                xmlWriter.startElement("Days").value(expiration.days()).endElement();
                            }

                            if (expiration.expiredObjectDeleteMarker() != null) {
                                xmlWriter.startElement("ExpiredObjectDeleteMarker").value(expiration.expiredObjectDeleteMarker())
                                        .endElement();
                            }
                            xmlWriter.endElement();
                        }

                        if (lifecycleConfigurationRulesListValue.id() != null) {
                            xmlWriter.startElement("ID").value(lifecycleConfigurationRulesListValue.id()).endElement();
                        }

                        if (lifecycleConfigurationRulesListValue.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(lifecycleConfigurationRulesListValue.prefix()).endElement();
                        }

                        if (lifecycleConfigurationRulesListValue.statusAsString() != null) {
                            xmlWriter.startElement("Status").value(lifecycleConfigurationRulesListValue.statusAsString())
                                    .endElement();
                        }

                        Transition transition = lifecycleConfigurationRulesListValue.transition();
                        if (transition != null) {
                            xmlWriter.startElement("Transition");

                            if (transition.date() != null) {
                                xmlWriter.startElement("Date").value(transition.date()).endElement();
                            }

                            if (transition.days() != null) {
                                xmlWriter.startElement("Days").value(transition.days()).endElement();
                            }

                            if (transition.storageClassAsString() != null) {
                                xmlWriter.startElement("StorageClass").value(transition.storageClassAsString()).endElement();
                            }
                            xmlWriter.endElement();
                        }

                        NoncurrentVersionTransition noncurrentVersionTransition = lifecycleConfigurationRulesListValue
                                .noncurrentVersionTransition();
                        if (noncurrentVersionTransition != null) {
                            xmlWriter.startElement("NoncurrentVersionTransition");

                            if (noncurrentVersionTransition.noncurrentDays() != null) {
                                xmlWriter.startElement("NoncurrentDays").value(noncurrentVersionTransition.noncurrentDays())
                                        .endElement();
                            }

                            if (noncurrentVersionTransition.storageClassAsString() != null) {
                                xmlWriter.startElement("StorageClass").value(noncurrentVersionTransition.storageClassAsString())
                                        .endElement();
                            }
                            xmlWriter.endElement();
                        }

                        NoncurrentVersionExpiration noncurrentVersionExpiration = lifecycleConfigurationRulesListValue
                                .noncurrentVersionExpiration();
                        if (noncurrentVersionExpiration != null) {
                            xmlWriter.startElement("NoncurrentVersionExpiration");

                            if (noncurrentVersionExpiration.noncurrentDays() != null) {
                                xmlWriter.startElement("NoncurrentDays").value(noncurrentVersionExpiration.noncurrentDays())
                                        .endElement();
                            }
                            xmlWriter.endElement();
                        }

                        AbortIncompleteMultipartUpload abortIncompleteMultipartUpload = lifecycleConfigurationRulesListValue
                                .abortIncompleteMultipartUpload();
                        if (abortIncompleteMultipartUpload != null) {
                            xmlWriter.startElement("AbortIncompleteMultipartUpload");

                            if (abortIncompleteMultipartUpload.daysAfterInitiation() != null) {
                                xmlWriter.startElement("DaysAfterInitiation")
                                        .value(abortIncompleteMultipartUpload.daysAfterInitiation()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF_8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }

        return request;
    }

}