/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.utils.StringInputStream;
import software.amazon.awssdk.core.util.StringConversion;

import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.core.util.xml.XmlWriter;

/**
 * PutBucketInventoryConfigurationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketInventoryConfigurationRequestMarshaller implements
        Marshaller<Request<PutBucketInventoryConfigurationRequest>, PutBucketInventoryConfigurationRequest> {

    public Request<PutBucketInventoryConfigurationRequest> marshall(
            PutBucketInventoryConfigurationRequest putBucketInventoryConfigurationRequest) {

        if (putBucketInventoryConfigurationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<PutBucketInventoryConfigurationRequest> request = new DefaultRequest<PutBucketInventoryConfigurationRequest>(
                putBucketInventoryConfigurationRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        String uriResourcePath = "/{Bucket}?inventory";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", putBucketInventoryConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);

        if (putBucketInventoryConfigurationRequest.id() != null) {
            request.addParameter("id", StringConversion.fromString(putBucketInventoryConfigurationRequest.id()));
        }

        try {
            StringWriter stringWriter = null;
            InventoryConfiguration inventoryConfiguration = putBucketInventoryConfigurationRequest.inventoryConfiguration();
            if (inventoryConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("InventoryConfiguration");

                InventoryDestination destination = inventoryConfiguration.destination();
                if (destination != null) {
                    xmlWriter.startElement("Destination");

                    InventoryS3BucketDestination s3BucketDestination = destination.s3BucketDestination();
                    if (s3BucketDestination != null) {
                        xmlWriter.startElement("S3BucketDestination");

                        if (s3BucketDestination.accountId() != null) {
                            xmlWriter.startElement("AccountId").value(s3BucketDestination.accountId()).endElement();
                        }

                        if (s3BucketDestination.bucket() != null) {
                            xmlWriter.startElement("Bucket").value(s3BucketDestination.bucket()).endElement();
                        }

                        if (s3BucketDestination.formatAsString() != null) {
                            xmlWriter.startElement("Format").value(s3BucketDestination.formatAsString()).endElement();
                        }

                        if (s3BucketDestination.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(s3BucketDestination.prefix()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                if (inventoryConfiguration.isEnabled() != null) {
                    xmlWriter.startElement("IsEnabled").value(inventoryConfiguration.isEnabled()).endElement();
                }

                InventoryFilter filter = inventoryConfiguration.filter();
                if (filter != null) {
                    xmlWriter.startElement("Filter");

                    if (filter.prefix() != null) {
                        xmlWriter.startElement("Prefix").value(filter.prefix()).endElement();
                    }
                    xmlWriter.endElement();
                }

                if (inventoryConfiguration.id() != null) {
                    xmlWriter.startElement("Id").value(inventoryConfiguration.id()).endElement();
                }

                if (inventoryConfiguration.includedObjectVersionsAsString() != null) {
                    xmlWriter.startElement("IncludedObjectVersions")
                            .value(inventoryConfiguration.includedObjectVersionsAsString()).endElement();
                }

                java.util.List<String> inventoryConfigurationOptionalFieldsList = inventoryConfiguration
                        .optionalFieldsAsStrings();
                if (!inventoryConfigurationOptionalFieldsList.isEmpty()
                        || !(inventoryConfigurationOptionalFieldsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    xmlWriter.startElement("OptionalFields");

                    for (String inventoryConfigurationOptionalFieldsListValue : inventoryConfigurationOptionalFieldsList) {
                        xmlWriter.startElement("Field");
                        xmlWriter.value(inventoryConfigurationOptionalFieldsListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                InventorySchedule schedule = inventoryConfiguration.schedule();
                if (schedule != null) {
                    xmlWriter.startElement("Schedule");

                    if (schedule.frequencyAsString() != null) {
                        xmlWriter.startElement("Frequency").value(schedule.frequencyAsString()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF_8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }

        return request;
    }

}