/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.utils.StringInputStream;
import software.amazon.awssdk.core.util.StringConversion;

import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.core.util.xml.XmlWriter;

/**
 * PutBucketAclRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketAclRequestMarshaller implements Marshaller<Request<PutBucketAclRequest>, PutBucketAclRequest> {

    public Request<PutBucketAclRequest> marshall(PutBucketAclRequest putBucketAclRequest) {

        if (putBucketAclRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<PutBucketAclRequest> request = new DefaultRequest<PutBucketAclRequest>(putBucketAclRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (putBucketAclRequest.aclAsString() != null) {
            request.addHeader("x-amz-acl", StringConversion.fromString(putBucketAclRequest.aclAsString()));
        }

        if (putBucketAclRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString(putBucketAclRequest.contentMD5()));
        }

        if (putBucketAclRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringConversion.fromString(putBucketAclRequest.grantFullControl()));
        }

        if (putBucketAclRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringConversion.fromString(putBucketAclRequest.grantRead()));
        }

        if (putBucketAclRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringConversion.fromString(putBucketAclRequest.grantReadACP()));
        }

        if (putBucketAclRequest.grantWrite() != null) {
            request.addHeader("x-amz-grant-write", StringConversion.fromString(putBucketAclRequest.grantWrite()));
        }

        if (putBucketAclRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringConversion.fromString(putBucketAclRequest.grantWriteACP()));
        }

        String uriResourcePath = "/{Bucket}?acl";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", putBucketAclRequest.bucket());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            AccessControlPolicy accessControlPolicy = putBucketAclRequest.accessControlPolicy();
            if (accessControlPolicy != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("AccessControlPolicy");

                java.util.List<Grant> accessControlPolicyGrantsList = accessControlPolicy.grants();
                if (!accessControlPolicyGrantsList.isEmpty()
                        || !(accessControlPolicyGrantsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    xmlWriter.startElement("AccessControlList");

                    for (Grant accessControlPolicyGrantsListValue : accessControlPolicyGrantsList) {
                        xmlWriter.startElement("Grant");

                        Grantee grantee = accessControlPolicyGrantsListValue.grantee();
                        if (grantee != null) {
                            xmlWriter.startElement("Grantee");

                            if (grantee.displayName() != null) {
                                xmlWriter.startElement("DisplayName").value(grantee.displayName()).endElement();
                            }

                            if (grantee.emailAddress() != null) {
                                xmlWriter.startElement("EmailAddress").value(grantee.emailAddress()).endElement();
                            }

                            if (grantee.id() != null) {
                                xmlWriter.startElement("ID").value(grantee.id()).endElement();
                            }

                            if (grantee.typeAsString() != null) {
                                xmlWriter.startElement("xsi:type").value(grantee.typeAsString()).endElement();
                            }

                            if (grantee.uri() != null) {
                                xmlWriter.startElement("URI").value(grantee.uri()).endElement();
                            }
                            xmlWriter.endElement();
                        }

                        if (accessControlPolicyGrantsListValue.permissionAsString() != null) {
                            xmlWriter.startElement("Permission").value(accessControlPolicyGrantsListValue.permissionAsString())
                                    .endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                Owner owner = accessControlPolicy.owner();
                if (owner != null) {
                    xmlWriter.startElement("Owner");

                    if (owner.displayName() != null) {
                        xmlWriter.startElement("DisplayName").value(owner.displayName()).endElement();
                    }

                    if (owner.id() != null) {
                        xmlWriter.startElement("ID").value(owner.id()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF_8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }

        return request;
    }

}