/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringConversion;

/**
 * ListObjectsV2Request Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListObjectsV2RequestMarshaller implements Marshaller<Request<ListObjectsV2Request>, ListObjectsV2Request> {

    public Request<ListObjectsV2Request> marshall(ListObjectsV2Request listObjectsV2Request) {

        if (listObjectsV2Request == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<ListObjectsV2Request> request = new DefaultRequest<ListObjectsV2Request>(listObjectsV2Request, "S3Client");

        request.setHttpMethod(HttpMethodName.GET);

        if (listObjectsV2Request.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString(listObjectsV2Request.requestPayerAsString()));
        }

        String uriResourcePath = "/{Bucket}?list-type=2";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", listObjectsV2Request.bucket());
        request.setResourcePath(uriResourcePath);

        if (listObjectsV2Request.delimiter() != null) {
            request.addParameter("delimiter", StringConversion.fromString(listObjectsV2Request.delimiter()));
        }

        if (listObjectsV2Request.encodingTypeAsString() != null) {
            request.addParameter("encoding-type", StringConversion.fromString(listObjectsV2Request.encodingTypeAsString()));
        }

        if (listObjectsV2Request.maxKeys() != null) {
            request.addParameter("max-keys", StringConversion.fromInteger(listObjectsV2Request.maxKeys()));
        }

        if (listObjectsV2Request.prefix() != null) {
            request.addParameter("prefix", StringConversion.fromString(listObjectsV2Request.prefix()));
        }

        if (listObjectsV2Request.continuationToken() != null) {
            request.addParameter("continuation-token", StringConversion.fromString(listObjectsV2Request.continuationToken()));
        }

        if (listObjectsV2Request.fetchOwner() != null) {
            request.addParameter("fetch-owner", StringConversion.fromBoolean(listObjectsV2Request.fetchOwner()));
        }

        if (listObjectsV2Request.startAfter() != null) {
            request.addParameter("start-after", StringConversion.fromString(listObjectsV2Request.startAfter()));
        }

        return request;
    }

}