/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringConversion;

/**
 * HeadObjectRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class HeadObjectRequestMarshaller implements Marshaller<Request<HeadObjectRequest>, HeadObjectRequest> {

    public Request<HeadObjectRequest> marshall(HeadObjectRequest headObjectRequest) {

        if (headObjectRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<HeadObjectRequest> request = new DefaultRequest<HeadObjectRequest>(headObjectRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.HEAD);

        if (headObjectRequest.ifMatch() != null) {
            request.addHeader("If-Match", StringConversion.fromString(headObjectRequest.ifMatch()));
        }

        if (headObjectRequest.ifModifiedSince() != null) {
            request.addHeader("If-Modified-Since", StringConversion.fromInstant(headObjectRequest.ifModifiedSince()));
        }

        if (headObjectRequest.ifNoneMatch() != null) {
            request.addHeader("If-None-Match", StringConversion.fromString(headObjectRequest.ifNoneMatch()));
        }

        if (headObjectRequest.ifUnmodifiedSince() != null) {
            request.addHeader("If-Unmodified-Since", StringConversion.fromInstant(headObjectRequest.ifUnmodifiedSince()));
        }

        if (headObjectRequest.range() != null) {
            request.addHeader("Range", StringConversion.fromString(headObjectRequest.range()));
        }

        if (headObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm",
                    StringConversion.fromString(headObjectRequest.sseCustomerAlgorithm()));
        }

        if (headObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key",
                    StringConversion.fromString(headObjectRequest.sseCustomerKey()));
        }

        if (headObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5",
                    StringConversion.fromString(headObjectRequest.sseCustomerKeyMD5()));
        }

        if (headObjectRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString(headObjectRequest.requestPayerAsString()));
        }

        String uriResourcePath = "/{Bucket}/{Key+}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", headObjectRequest.bucket());
        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.GREEDY.marshall(uriResourcePath, "Key",
                headObjectRequest.key());
        request.setResourcePath(uriResourcePath);

        if (headObjectRequest.versionId() != null) {
            request.addParameter("versionId", StringConversion.fromString(headObjectRequest.versionId()));
        }

        if (headObjectRequest.partNumber() != null) {
            request.addParameter("partNumber", StringConversion.fromInteger(headObjectRequest.partNumber()));
        }

        return request;
    }

}