/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

/**
 * DeleteBucketLifecycleRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteBucketLifecycleRequestMarshaller implements
        Marshaller<Request<DeleteBucketLifecycleRequest>, DeleteBucketLifecycleRequest> {

    public Request<DeleteBucketLifecycleRequest> marshall(DeleteBucketLifecycleRequest deleteBucketLifecycleRequest) {

        if (deleteBucketLifecycleRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<DeleteBucketLifecycleRequest> request = new DefaultRequest<DeleteBucketLifecycleRequest>(
                deleteBucketLifecycleRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.DELETE);

        String uriResourcePath = "/{Bucket}?lifecycle";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", deleteBucketLifecycleRequest.bucket());
        request.setResourcePath(uriResourcePath);

        return request;
    }

}