/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * CopyObjectResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CopyObjectResponseUnmarshaller implements Unmarshaller<CopyObjectResponse, StaxUnmarshallerContext> {

    public CopyObjectResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        CopyObjectResponse.Builder copyObjectResponse = CopyObjectResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-expiration");
            copyObjectResponse.expiration(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-copy-source-version-id");
            copyObjectResponse.copySourceVersionId(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-version-id");
            copyObjectResponse.versionId(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption");
            copyObjectResponse.serverSideEncryption(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-customer-algorithm");
            copyObjectResponse.sseCustomerAlgorithm(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-customer-key-MD5");
            copyObjectResponse.sseCustomerKeyMD5(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-aws-kms-key-id");
            copyObjectResponse.ssekmsKeyId(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-request-charged");
            copyObjectResponse.requestCharged(StringUnmarshaller.getInstance().unmarshall(context));

        }

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("CopyObjectResult", targetDepth)) {
                    copyObjectResponse.copyObjectResult(CopyObjectResultUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return copyObjectResponse.build();
    }

    private static final CopyObjectResponseUnmarshaller INSTANCE = new CopyObjectResponseUnmarshaller();

    public static CopyObjectResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
