/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestPaymentConfiguration implements
        ToCopyableBuilder<RequestPaymentConfiguration.Builder, RequestPaymentConfiguration> {
    private final String payer;

    private RequestPaymentConfiguration(BuilderImpl builder) {
        this.payer = builder.payer;
    }

    /**
     * Specifies who pays for the download and request fees.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #payer} will return
     * {@link Payer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #payerAsString}.
     * </p>
     * 
     * @return Specifies who pays for the download and request fees.
     * @see Payer
     */
    public Payer payer() {
        return Payer.fromValue(payer);
    }

    /**
     * Specifies who pays for the download and request fees.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #payer} will return
     * {@link Payer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #payerAsString}.
     * </p>
     * 
     * @return Specifies who pays for the download and request fees.
     * @see Payer
     */
    public String payerAsString() {
        return payer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(payerAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestPaymentConfiguration)) {
            return false;
        }
        RequestPaymentConfiguration other = (RequestPaymentConfiguration) obj;
        return Objects.equals(payerAsString(), other.payerAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("RequestPaymentConfiguration").add("Payer", payerAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Payer":
            return Optional.ofNullable(clazz.cast(payerAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RequestPaymentConfiguration> {
        /**
         * Specifies who pays for the download and request fees.
         * 
         * @param payer
         *        Specifies who pays for the download and request fees.
         * @see Payer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Payer
         */
        Builder payer(String payer);

        /**
         * Specifies who pays for the download and request fees.
         * 
         * @param payer
         *        Specifies who pays for the download and request fees.
         * @see Payer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Payer
         */
        Builder payer(Payer payer);
    }

    static final class BuilderImpl implements Builder {
        private String payer;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestPaymentConfiguration model) {
            payer(model.payer);
        }

        public final String getPayer() {
            return payer;
        }

        @Override
        public final Builder payer(String payer) {
            this.payer = payer;
            return this;
        }

        @Override
        public final Builder payer(Payer payer) {
            this.payer(payer.toString());
            return this;
        }

        public final void setPayer(String payer) {
            this.payer = payer;
        }

        @Override
        public RequestPaymentConfiguration build() {
            return new RequestPaymentConfiguration(this);
        }
    }
}
