/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricsConfiguration implements ToCopyableBuilder<MetricsConfiguration.Builder, MetricsConfiguration> {
    private final String id;

    private final MetricsFilter filter;

    private MetricsConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.filter = builder.filter;
    }

    /**
     * The ID used to identify the metrics configuration.
     * 
     * @return The ID used to identify the metrics configuration.
     */
    public String id() {
        return id;
    }

    /**
     * Specifies a metrics configuration filter. The metrics configuration will only include objects that meet the
     * filter's criteria. A filter must be a prefix, a tag, or a conjunction (MetricsAndOperator).
     * 
     * @return Specifies a metrics configuration filter. The metrics configuration will only include objects that meet
     *         the filter's criteria. A filter must be a prefix, a tag, or a conjunction (MetricsAndOperator).
     */
    public MetricsFilter filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsConfiguration)) {
            return false;
        }
        MetricsConfiguration other = (MetricsConfiguration) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(filter(), other.filter());
    }

    @Override
    public String toString() {
        return ToString.builder("MetricsConfiguration").add("Id", id()).add("Filter", filter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, MetricsConfiguration> {
        /**
         * The ID used to identify the metrics configuration.
         * 
         * @param id
         *        The ID used to identify the metrics configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Specifies a metrics configuration filter. The metrics configuration will only include objects that meet the
         * filter's criteria. A filter must be a prefix, a tag, or a conjunction (MetricsAndOperator).
         * 
         * @param filter
         *        Specifies a metrics configuration filter. The metrics configuration will only include objects that
         *        meet the filter's criteria. A filter must be a prefix, a tag, or a conjunction (MetricsAndOperator).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(MetricsFilter filter);

        /**
         * Specifies a metrics configuration filter. The metrics configuration will only include objects that meet the
         * filter's criteria. A filter must be a prefix, a tag, or a conjunction (MetricsAndOperator). This is a
         * convenience that creates an instance of the {@link MetricsFilter.Builder} avoiding the need to create one
         * manually via {@link MetricsFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricsFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(MetricsFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link MetricsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(MetricsFilter)
         */
        default Builder filter(Consumer<MetricsFilter.Builder> filter) {
            return filter(MetricsFilter.builder().applyMutation(filter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private MetricsFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsConfiguration model) {
            id(model.id);
            filter(model.filter);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final MetricsFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(MetricsFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(MetricsFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public MetricsConfiguration build() {
            return new MetricsConfiguration(this);
        }
    }
}
