/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingEnabled implements ToCopyableBuilder<LoggingEnabled.Builder, LoggingEnabled> {
    private final String targetBucket;

    private final List<TargetGrant> targetGrants;

    private final String targetPrefix;

    private LoggingEnabled(BuilderImpl builder) {
        this.targetBucket = builder.targetBucket;
        this.targetGrants = builder.targetGrants;
        this.targetPrefix = builder.targetPrefix;
    }

    /**
     * Specifies the bucket where you want Amazon S3 to store server access logs. You can have your logs delivered to
     * any bucket that you own, including the same bucket that is being logged. You can also configure multiple buckets
     * to deliver their logs to the same target bucket. In this case you should choose a different TargetPrefix for each
     * source bucket so that the delivered log files can be distinguished by key.
     * 
     * @return Specifies the bucket where you want Amazon S3 to store server access logs. You can have your logs
     *         delivered to any bucket that you own, including the same bucket that is being logged. You can also
     *         configure multiple buckets to deliver their logs to the same target bucket. In this case you should
     *         choose a different TargetPrefix for each source bucket so that the delivered log files can be
     *         distinguished by key.
     */
    public String targetBucket() {
        return targetBucket;
    }

    /**
     * Returns the value of the TargetGrants property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the TargetGrants property for this object.
     */
    public List<TargetGrant> targetGrants() {
        return targetGrants;
    }

    /**
     * This element lets you specify a prefix for the keys that the log files will be stored under.
     * 
     * @return This element lets you specify a prefix for the keys that the log files will be stored under.
     */
    public String targetPrefix() {
        return targetPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetBucket());
        hashCode = 31 * hashCode + Objects.hashCode(targetGrants());
        hashCode = 31 * hashCode + Objects.hashCode(targetPrefix());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingEnabled)) {
            return false;
        }
        LoggingEnabled other = (LoggingEnabled) obj;
        return Objects.equals(targetBucket(), other.targetBucket()) && Objects.equals(targetGrants(), other.targetGrants())
                && Objects.equals(targetPrefix(), other.targetPrefix());
    }

    @Override
    public String toString() {
        return ToString.builder("LoggingEnabled").add("TargetBucket", targetBucket()).add("TargetGrants", targetGrants())
                .add("TargetPrefix", targetPrefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetBucket":
            return Optional.ofNullable(clazz.cast(targetBucket()));
        case "TargetGrants":
            return Optional.ofNullable(clazz.cast(targetGrants()));
        case "TargetPrefix":
            return Optional.ofNullable(clazz.cast(targetPrefix()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, LoggingEnabled> {
        /**
         * Specifies the bucket where you want Amazon S3 to store server access logs. You can have your logs delivered
         * to any bucket that you own, including the same bucket that is being logged. You can also configure multiple
         * buckets to deliver their logs to the same target bucket. In this case you should choose a different
         * TargetPrefix for each source bucket so that the delivered log files can be distinguished by key.
         * 
         * @param targetBucket
         *        Specifies the bucket where you want Amazon S3 to store server access logs. You can have your logs
         *        delivered to any bucket that you own, including the same bucket that is being logged. You can also
         *        configure multiple buckets to deliver their logs to the same target bucket. In this case you should
         *        choose a different TargetPrefix for each source bucket so that the delivered log files can be
         *        distinguished by key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBucket(String targetBucket);

        /**
         * Sets the value of the TargetGrants property for this object.
         *
         * @param targetGrants
         *        The new value for the TargetGrants property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGrants(Collection<TargetGrant> targetGrants);

        /**
         * Sets the value of the TargetGrants property for this object.
         *
         * @param targetGrants
         *        The new value for the TargetGrants property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGrants(TargetGrant... targetGrants);

        /**
         * Sets the value of the TargetGrants property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<TargetGrant>.Builder} avoiding the need to
         * create one manually via {@link List<TargetGrant>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetGrant>.Builder#build()} is called immediately and its
         * result is passed to {@link #targetGrants(List<TargetGrant>)}.
         * 
         * @param targetGrants
         *        a consumer that will call methods on {@link List<TargetGrant>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetGrants(List<TargetGrant>)
         */
        Builder targetGrants(Consumer<TargetGrant.Builder>... targetGrants);

        /**
         * This element lets you specify a prefix for the keys that the log files will be stored under.
         * 
         * @param targetPrefix
         *        This element lets you specify a prefix for the keys that the log files will be stored under.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPrefix(String targetPrefix);
    }

    static final class BuilderImpl implements Builder {
        private String targetBucket;

        private List<TargetGrant> targetGrants = DefaultSdkAutoConstructList.getInstance();

        private String targetPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingEnabled model) {
            targetBucket(model.targetBucket);
            targetGrants(model.targetGrants);
            targetPrefix(model.targetPrefix);
        }

        public final String getTargetBucket() {
            return targetBucket;
        }

        @Override
        public final Builder targetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
            return this;
        }

        public final void setTargetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
        }

        public final Collection<TargetGrant.Builder> getTargetGrants() {
            return targetGrants != null ? targetGrants.stream().map(TargetGrant::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetGrants(Collection<TargetGrant> targetGrants) {
            this.targetGrants = TargetGrantsCopier.copy(targetGrants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGrants(TargetGrant... targetGrants) {
            targetGrants(Arrays.asList(targetGrants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGrants(Consumer<TargetGrant.Builder>... targetGrants) {
            targetGrants(Stream.of(targetGrants).map(c -> TargetGrant.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTargetGrants(Collection<TargetGrant.BuilderImpl> targetGrants) {
            this.targetGrants = TargetGrantsCopier.copyFromBuilder(targetGrants);
        }

        public final String getTargetPrefix() {
            return targetPrefix;
        }

        @Override
        public final Builder targetPrefix(String targetPrefix) {
            this.targetPrefix = targetPrefix;
            return this;
        }

        public final void setTargetPrefix(String targetPrefix) {
            this.targetPrefix = targetPrefix;
        }

        @Override
        public LoggingEnabled build() {
            return new LoggingEnabled(this);
        }
    }
}
