/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBucketInventoryConfigurationsResponse extends S3Response implements
        ToCopyableBuilder<ListBucketInventoryConfigurationsResponse.Builder, ListBucketInventoryConfigurationsResponse> {
    private final String continuationToken;

    private final List<InventoryConfiguration> inventoryConfigurationList;

    private final Boolean isTruncated;

    private final String nextContinuationToken;

    private ListBucketInventoryConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.continuationToken = builder.continuationToken;
        this.inventoryConfigurationList = builder.inventoryConfigurationList;
        this.isTruncated = builder.isTruncated;
        this.nextContinuationToken = builder.nextContinuationToken;
    }

    /**
     * If sent in the request, the marker that is used as a starting point for this inventory configuration list
     * response.
     * 
     * @return If sent in the request, the marker that is used as a starting point for this inventory configuration list
     *         response.
     */
    public String continuationToken() {
        return continuationToken;
    }

    /**
     * The list of inventory configurations for a bucket.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of inventory configurations for a bucket.
     */
    public List<InventoryConfiguration> inventoryConfigurationList() {
        return inventoryConfigurationList;
    }

    /**
     * Indicates whether the returned list of inventory configurations is truncated in this response. A value of true
     * indicates that the list is truncated.
     * 
     * @return Indicates whether the returned list of inventory configurations is truncated in this response. A value of
     *         true indicates that the list is truncated.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * The marker used to continue this inventory configuration listing. Use the NextContinuationToken from this
     * response to continue the listing in a subsequent request. The continuation token is an opaque value that Amazon
     * S3 understands.
     * 
     * @return The marker used to continue this inventory configuration listing. Use the NextContinuationToken from this
     *         response to continue the listing in a subsequent request. The continuation token is an opaque value that
     *         Amazon S3 understands.
     */
    public String nextContinuationToken() {
        return nextContinuationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(inventoryConfigurationList());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(nextContinuationToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketInventoryConfigurationsResponse)) {
            return false;
        }
        ListBucketInventoryConfigurationsResponse other = (ListBucketInventoryConfigurationsResponse) obj;
        return Objects.equals(continuationToken(), other.continuationToken())
                && Objects.equals(inventoryConfigurationList(), other.inventoryConfigurationList())
                && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(nextContinuationToken(), other.nextContinuationToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListBucketInventoryConfigurationsResponse").add("ContinuationToken", continuationToken())
                .add("InventoryConfigurationList", inventoryConfigurationList()).add("IsTruncated", isTruncated())
                .add("NextContinuationToken", nextContinuationToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContinuationToken":
            return Optional.ofNullable(clazz.cast(continuationToken()));
        case "InventoryConfigurationList":
            return Optional.ofNullable(clazz.cast(inventoryConfigurationList()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "NextContinuationToken":
            return Optional.ofNullable(clazz.cast(nextContinuationToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Response.Builder, CopyableBuilder<Builder, ListBucketInventoryConfigurationsResponse> {
        /**
         * If sent in the request, the marker that is used as a starting point for this inventory configuration list
         * response.
         * 
         * @param continuationToken
         *        If sent in the request, the marker that is used as a starting point for this inventory configuration
         *        list response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);

        /**
         * The list of inventory configurations for a bucket.
         * 
         * @param inventoryConfigurationList
         *        The list of inventory configurations for a bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inventoryConfigurationList(Collection<InventoryConfiguration> inventoryConfigurationList);

        /**
         * The list of inventory configurations for a bucket.
         * 
         * @param inventoryConfigurationList
         *        The list of inventory configurations for a bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inventoryConfigurationList(InventoryConfiguration... inventoryConfigurationList);

        /**
         * The list of inventory configurations for a bucket. This is a convenience that creates an instance of the
         * {@link List<InventoryConfiguration>.Builder} avoiding the need to create one manually via {@link List
         * <InventoryConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InventoryConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #inventoryConfigurationList(List<InventoryConfiguration>)}.
         * 
         * @param inventoryConfigurationList
         *        a consumer that will call methods on {@link List<InventoryConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inventoryConfigurationList(List<InventoryConfiguration>)
         */
        Builder inventoryConfigurationList(Consumer<InventoryConfiguration.Builder>... inventoryConfigurationList);

        /**
         * Indicates whether the returned list of inventory configurations is truncated in this response. A value of
         * true indicates that the list is truncated.
         * 
         * @param isTruncated
         *        Indicates whether the returned list of inventory configurations is truncated in this response. A value
         *        of true indicates that the list is truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * The marker used to continue this inventory configuration listing. Use the NextContinuationToken from this
         * response to continue the listing in a subsequent request. The continuation token is an opaque value that
         * Amazon S3 understands.
         * 
         * @param nextContinuationToken
         *        The marker used to continue this inventory configuration listing. Use the NextContinuationToken from
         *        this response to continue the listing in a subsequent request. The continuation token is an opaque
         *        value that Amazon S3 understands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextContinuationToken(String nextContinuationToken);
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private String continuationToken;

        private List<InventoryConfiguration> inventoryConfigurationList = DefaultSdkAutoConstructList.getInstance();

        private Boolean isTruncated;

        private String nextContinuationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketInventoryConfigurationsResponse model) {
            super(model);
            continuationToken(model.continuationToken);
            inventoryConfigurationList(model.inventoryConfigurationList);
            isTruncated(model.isTruncated);
            nextContinuationToken(model.nextContinuationToken);
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final Collection<InventoryConfiguration.Builder> getInventoryConfigurationList() {
            return inventoryConfigurationList != null ? inventoryConfigurationList.stream()
                    .map(InventoryConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inventoryConfigurationList(Collection<InventoryConfiguration> inventoryConfigurationList) {
            this.inventoryConfigurationList = InventoryConfigurationListCopier.copy(inventoryConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inventoryConfigurationList(InventoryConfiguration... inventoryConfigurationList) {
            inventoryConfigurationList(Arrays.asList(inventoryConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inventoryConfigurationList(Consumer<InventoryConfiguration.Builder>... inventoryConfigurationList) {
            inventoryConfigurationList(Stream.of(inventoryConfigurationList)
                    .map(c -> InventoryConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInventoryConfigurationList(Collection<InventoryConfiguration.BuilderImpl> inventoryConfigurationList) {
            this.inventoryConfigurationList = InventoryConfigurationListCopier.copyFromBuilder(inventoryConfigurationList);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextContinuationToken() {
            return nextContinuationToken;
        }

        @Override
        public final Builder nextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
            return this;
        }

        public final void setNextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
        }

        @Override
        public ListBucketInventoryConfigurationsResponse build() {
            return new ListBucketInventoryConfigurationsResponse(this);
        }
    }
}
