/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBucketAnalyticsConfigurationsRequest extends S3Request implements
        ToCopyableBuilder<ListBucketAnalyticsConfigurationsRequest.Builder, ListBucketAnalyticsConfigurationsRequest> {
    private final String bucket;

    private final String continuationToken;

    private ListBucketAnalyticsConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.continuationToken = builder.continuationToken;
    }

    /**
     * The name of the bucket from which analytics configurations are retrieved.
     * 
     * @return The name of the bucket from which analytics configurations are retrieved.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * The ContinuationToken that represents a placeholder from where this request should begin.
     * 
     * @return The ContinuationToken that represents a placeholder from where this request should begin.
     */
    public String continuationToken() {
        return continuationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(continuationToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketAnalyticsConfigurationsRequest)) {
            return false;
        }
        ListBucketAnalyticsConfigurationsRequest other = (ListBucketAnalyticsConfigurationsRequest) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(continuationToken(), other.continuationToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListBucketAnalyticsConfigurationsRequest").add("Bucket", bucket())
                .add("ContinuationToken", continuationToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "ContinuationToken":
            return Optional.ofNullable(clazz.cast(continuationToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Request.Builder, CopyableBuilder<Builder, ListBucketAnalyticsConfigurationsRequest> {
        /**
         * The name of the bucket from which analytics configurations are retrieved.
         * 
         * @param bucket
         *        The name of the bucket from which analytics configurations are retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * The ContinuationToken that represents a placeholder from where this request should begin.
         * 
         * @param continuationToken
         *        The ContinuationToken that represents a placeholder from where this request should begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String bucket;

        private String continuationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketAnalyticsConfigurationsRequest model) {
            super(model);
            bucket(model.bucket);
            continuationToken(model.continuationToken);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBucketAnalyticsConfigurationsRequest build() {
            return new ListBucketAnalyticsConfigurationsRequest(this);
        }
    }
}
