/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InventoryS3BucketDestination implements
        ToCopyableBuilder<InventoryS3BucketDestination.Builder, InventoryS3BucketDestination> {
    private final String accountId;

    private final String bucket;

    private final String format;

    private final String prefix;

    private InventoryS3BucketDestination(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.bucket = builder.bucket;
        this.format = builder.format;
        this.prefix = builder.prefix;
    }

    /**
     * The ID of the account that owns the destination bucket.
     * 
     * @return The ID of the account that owns the destination bucket.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * The Amazon resource name (ARN) of the bucket where inventory results will be published.
     * 
     * @return The Amazon resource name (ARN) of the bucket where inventory results will be published.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Specifies the output format of the inventory results.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link InventoryFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Specifies the output format of the inventory results.
     * @see InventoryFormat
     */
    public InventoryFormat format() {
        return InventoryFormat.fromValue(format);
    }

    /**
     * Specifies the output format of the inventory results.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link InventoryFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Specifies the output format of the inventory results.
     * @see InventoryFormat
     */
    public String formatAsString() {
        return format;
    }

    /**
     * The prefix that is prepended to all inventory results.
     * 
     * @return The prefix that is prepended to all inventory results.
     */
    public String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryS3BucketDestination)) {
            return false;
        }
        InventoryS3BucketDestination other = (InventoryS3BucketDestination) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(bucket(), other.bucket())
                && Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(prefix(), other.prefix());
    }

    @Override
    public String toString() {
        return ToString.builder("InventoryS3BucketDestination").add("AccountId", accountId()).add("Bucket", bucket())
                .add("Format", formatAsString()).add("Prefix", prefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InventoryS3BucketDestination> {
        /**
         * The ID of the account that owns the destination bucket.
         * 
         * @param accountId
         *        The ID of the account that owns the destination bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * The Amazon resource name (ARN) of the bucket where inventory results will be published.
         * 
         * @param bucket
         *        The Amazon resource name (ARN) of the bucket where inventory results will be published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Specifies the output format of the inventory results.
         * 
         * @param format
         *        Specifies the output format of the inventory results.
         * @see InventoryFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryFormat
         */
        Builder format(String format);

        /**
         * Specifies the output format of the inventory results.
         * 
         * @param format
         *        Specifies the output format of the inventory results.
         * @see InventoryFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryFormat
         */
        Builder format(InventoryFormat format);

        /**
         * The prefix that is prepended to all inventory results.
         * 
         * @param prefix
         *        The prefix that is prepended to all inventory results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String bucket;

        private String format;

        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryS3BucketDestination model) {
            accountId(model.accountId);
            bucket(model.bucket);
            format(model.format);
            prefix(model.prefix);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(InventoryFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public InventoryS3BucketDestination build() {
            return new InventoryS3BucketDestination(this);
        }
    }
}
