/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketLifecycleResponse extends S3Response implements
        ToCopyableBuilder<GetBucketLifecycleResponse.Builder, GetBucketLifecycleResponse> {
    private final List<Rule> rules;

    private GetBucketLifecycleResponse(BuilderImpl builder) {
        super(builder);
        this.rules = builder.rules;
    }

    /**
     * Returns the value of the Rules property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Rules property for this object.
     */
    public List<Rule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketLifecycleResponse)) {
            return false;
        }
        GetBucketLifecycleResponse other = (GetBucketLifecycleResponse) obj;
        return Objects.equals(rules(), other.rules());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBucketLifecycleResponse").add("Rules", rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Response.Builder, CopyableBuilder<Builder, GetBucketLifecycleResponse> {
        /**
         * Sets the value of the Rules property for this object.
         *
         * @param rules
         *        The new value for the Rules property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         * Sets the value of the Rules property for this object.
         *
         * @param rules
         *        The new value for the Rules property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);

        /**
         * Sets the value of the Rules property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Rule>.Builder} avoiding the need to create
         * one manually via {@link List<Rule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Rule>.Builder#build()} is called immediately and its result
         * is passed to {@link #rules(List<Rule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<Rule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<Rule>)
         */
        Builder rules(Consumer<Rule.Builder>... rules);
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketLifecycleResponse model) {
            super(model);
            rules(model.rules);
        }

        public final Collection<Rule.Builder> getRules() {
            return rules != null ? rules.stream().map(Rule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> Rule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RulesCopier.copyFromBuilder(rules);
        }

        @Override
        public GetBucketLifecycleResponse build() {
            return new GetBucketLifecycleResponse(this);
        }
    }
}
