/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBucketRequest extends S3Request implements
        ToCopyableBuilder<CreateBucketRequest.Builder, CreateBucketRequest> {
    private final String acl;

    private final String bucket;

    private final CreateBucketConfiguration createBucketConfiguration;

    private final String grantFullControl;

    private final String grantRead;

    private final String grantReadACP;

    private final String grantWrite;

    private final String grantWriteACP;

    private CreateBucketRequest(BuilderImpl builder) {
        super(builder);
        this.acl = builder.acl;
        this.bucket = builder.bucket;
        this.createBucketConfiguration = builder.createBucketConfiguration;
        this.grantFullControl = builder.grantFullControl;
        this.grantRead = builder.grantRead;
        this.grantReadACP = builder.grantReadACP;
        this.grantWrite = builder.grantWrite;
        this.grantWriteACP = builder.grantWriteACP;
    }

    /**
     * The canned ACL to apply to the bucket.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #acl} will return
     * {@link BucketCannedACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aclAsString}.
     * </p>
     * 
     * @return The canned ACL to apply to the bucket.
     * @see BucketCannedACL
     */
    public BucketCannedACL acl() {
        return BucketCannedACL.fromValue(acl);
    }

    /**
     * The canned ACL to apply to the bucket.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #acl} will return
     * {@link BucketCannedACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aclAsString}.
     * </p>
     * 
     * @return The canned ACL to apply to the bucket.
     * @see BucketCannedACL
     */
    public String aclAsString() {
        return acl;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Returns the value of the CreateBucketConfiguration property for this object.
     * 
     * @return The value of the CreateBucketConfiguration property for this object.
     */
    public CreateBucketConfiguration createBucketConfiguration() {
        return createBucketConfiguration;
    }

    /**
     * Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
     * 
     * @return Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
     */
    public String grantFullControl() {
        return grantFullControl;
    }

    /**
     * Allows grantee to list the objects in the bucket.
     * 
     * @return Allows grantee to list the objects in the bucket.
     */
    public String grantRead() {
        return grantRead;
    }

    /**
     * Allows grantee to read the bucket ACL.
     * 
     * @return Allows grantee to read the bucket ACL.
     */
    public String grantReadACP() {
        return grantReadACP;
    }

    /**
     * Allows grantee to create, overwrite, and delete any object in the bucket.
     * 
     * @return Allows grantee to create, overwrite, and delete any object in the bucket.
     */
    public String grantWrite() {
        return grantWrite;
    }

    /**
     * Allows grantee to write the ACL for the applicable bucket.
     * 
     * @return Allows grantee to write the ACL for the applicable bucket.
     */
    public String grantWriteACP() {
        return grantWriteACP;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aclAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(createBucketConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(grantFullControl());
        hashCode = 31 * hashCode + Objects.hashCode(grantRead());
        hashCode = 31 * hashCode + Objects.hashCode(grantReadACP());
        hashCode = 31 * hashCode + Objects.hashCode(grantWrite());
        hashCode = 31 * hashCode + Objects.hashCode(grantWriteACP());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBucketRequest)) {
            return false;
        }
        CreateBucketRequest other = (CreateBucketRequest) obj;
        return Objects.equals(aclAsString(), other.aclAsString()) && Objects.equals(bucket(), other.bucket())
                && Objects.equals(createBucketConfiguration(), other.createBucketConfiguration())
                && Objects.equals(grantFullControl(), other.grantFullControl()) && Objects.equals(grantRead(), other.grantRead())
                && Objects.equals(grantReadACP(), other.grantReadACP()) && Objects.equals(grantWrite(), other.grantWrite())
                && Objects.equals(grantWriteACP(), other.grantWriteACP());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateBucketRequest").add("ACL", aclAsString()).add("Bucket", bucket())
                .add("CreateBucketConfiguration", createBucketConfiguration()).add("GrantFullControl", grantFullControl())
                .add("GrantRead", grantRead()).add("GrantReadACP", grantReadACP()).add("GrantWrite", grantWrite())
                .add("GrantWriteACP", grantWriteACP()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ACL":
            return Optional.ofNullable(clazz.cast(aclAsString()));
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "CreateBucketConfiguration":
            return Optional.ofNullable(clazz.cast(createBucketConfiguration()));
        case "GrantFullControl":
            return Optional.ofNullable(clazz.cast(grantFullControl()));
        case "GrantRead":
            return Optional.ofNullable(clazz.cast(grantRead()));
        case "GrantReadACP":
            return Optional.ofNullable(clazz.cast(grantReadACP()));
        case "GrantWrite":
            return Optional.ofNullable(clazz.cast(grantWrite()));
        case "GrantWriteACP":
            return Optional.ofNullable(clazz.cast(grantWriteACP()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Request.Builder, CopyableBuilder<Builder, CreateBucketRequest> {
        /**
         * The canned ACL to apply to the bucket.
         * 
         * @param acl
         *        The canned ACL to apply to the bucket.
         * @see BucketCannedACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketCannedACL
         */
        Builder acl(String acl);

        /**
         * The canned ACL to apply to the bucket.
         * 
         * @param acl
         *        The canned ACL to apply to the bucket.
         * @see BucketCannedACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketCannedACL
         */
        Builder acl(BucketCannedACL acl);

        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Sets the value of the CreateBucketConfiguration property for this object.
         *
         * @param createBucketConfiguration
         *        The new value for the CreateBucketConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createBucketConfiguration(CreateBucketConfiguration createBucketConfiguration);

        /**
         * Sets the value of the CreateBucketConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link CreateBucketConfiguration.Builder} avoiding the
         * need to create one manually via {@link CreateBucketConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateBucketConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #createBucketConfiguration(CreateBucketConfiguration)}.
         * 
         * @param createBucketConfiguration
         *        a consumer that will call methods on {@link CreateBucketConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createBucketConfiguration(CreateBucketConfiguration)
         */
        default Builder createBucketConfiguration(Consumer<CreateBucketConfiguration.Builder> createBucketConfiguration) {
            return createBucketConfiguration(CreateBucketConfiguration.builder().applyMutation(createBucketConfiguration).build());
        }

        /**
         * Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
         * 
         * @param grantFullControl
         *        Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantFullControl(String grantFullControl);

        /**
         * Allows grantee to list the objects in the bucket.
         * 
         * @param grantRead
         *        Allows grantee to list the objects in the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantRead(String grantRead);

        /**
         * Allows grantee to read the bucket ACL.
         * 
         * @param grantReadACP
         *        Allows grantee to read the bucket ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantReadACP(String grantReadACP);

        /**
         * Allows grantee to create, overwrite, and delete any object in the bucket.
         * 
         * @param grantWrite
         *        Allows grantee to create, overwrite, and delete any object in the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantWrite(String grantWrite);

        /**
         * Allows grantee to write the ACL for the applicable bucket.
         * 
         * @param grantWriteACP
         *        Allows grantee to write the ACL for the applicable bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantWriteACP(String grantWriteACP);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String acl;

        private String bucket;

        private CreateBucketConfiguration createBucketConfiguration;

        private String grantFullControl;

        private String grantRead;

        private String grantReadACP;

        private String grantWrite;

        private String grantWriteACP;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBucketRequest model) {
            super(model);
            acl(model.acl);
            bucket(model.bucket);
            createBucketConfiguration(model.createBucketConfiguration);
            grantFullControl(model.grantFullControl);
            grantRead(model.grantRead);
            grantReadACP(model.grantReadACP);
            grantWrite(model.grantWrite);
            grantWriteACP(model.grantWriteACP);
        }

        public final String getACL() {
            return acl;
        }

        @Override
        public final Builder acl(String acl) {
            this.acl = acl;
            return this;
        }

        @Override
        public final Builder acl(BucketCannedACL acl) {
            this.acl(acl.toString());
            return this;
        }

        public final void setACL(String acl) {
            this.acl = acl;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final CreateBucketConfiguration.Builder getCreateBucketConfiguration() {
            return createBucketConfiguration != null ? createBucketConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder createBucketConfiguration(CreateBucketConfiguration createBucketConfiguration) {
            this.createBucketConfiguration = createBucketConfiguration;
            return this;
        }

        public final void setCreateBucketConfiguration(CreateBucketConfiguration.BuilderImpl createBucketConfiguration) {
            this.createBucketConfiguration = createBucketConfiguration != null ? createBucketConfiguration.build() : null;
        }

        public final String getGrantFullControl() {
            return grantFullControl;
        }

        @Override
        public final Builder grantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
            return this;
        }

        public final void setGrantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
        }

        public final String getGrantRead() {
            return grantRead;
        }

        @Override
        public final Builder grantRead(String grantRead) {
            this.grantRead = grantRead;
            return this;
        }

        public final void setGrantRead(String grantRead) {
            this.grantRead = grantRead;
        }

        public final String getGrantReadACP() {
            return grantReadACP;
        }

        @Override
        public final Builder grantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
            return this;
        }

        public final void setGrantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
        }

        public final String getGrantWrite() {
            return grantWrite;
        }

        @Override
        public final Builder grantWrite(String grantWrite) {
            this.grantWrite = grantWrite;
            return this;
        }

        public final void setGrantWrite(String grantWrite) {
            this.grantWrite = grantWrite;
        }

        public final String getGrantWriteACP() {
            return grantWriteACP;
        }

        @Override
        public final Builder grantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
            return this;
        }

        public final void setGrantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBucketRequest build() {
            return new CreateBucketRequest(this);
        }
    }
}
