/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyticsConfiguration implements ToCopyableBuilder<AnalyticsConfiguration.Builder, AnalyticsConfiguration> {
    private final String id;

    private final AnalyticsFilter filter;

    private final StorageClassAnalysis storageClassAnalysis;

    private AnalyticsConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.filter = builder.filter;
        this.storageClassAnalysis = builder.storageClassAnalysis;
    }

    /**
     * The identifier used to represent an analytics configuration.
     * 
     * @return The identifier used to represent an analytics configuration.
     */
    public String id() {
        return id;
    }

    /**
     * The filter used to describe a set of objects for analyses. A filter must have exactly one prefix, one tag, or one
     * conjunction (AnalyticsAndOperator). If no filter is provided, all objects will be considered in any analysis.
     * 
     * @return The filter used to describe a set of objects for analyses. A filter must have exactly one prefix, one
     *         tag, or one conjunction (AnalyticsAndOperator). If no filter is provided, all objects will be considered
     *         in any analysis.
     */
    public AnalyticsFilter filter() {
        return filter;
    }

    /**
     * If present, it indicates that data related to access patterns will be collected and made available to analyze the
     * tradeoffs between different storage classes.
     * 
     * @return If present, it indicates that data related to access patterns will be collected and made available to
     *         analyze the tradeoffs between different storage classes.
     */
    public StorageClassAnalysis storageClassAnalysis() {
        return storageClassAnalysis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(storageClassAnalysis());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsConfiguration)) {
            return false;
        }
        AnalyticsConfiguration other = (AnalyticsConfiguration) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(filter(), other.filter())
                && Objects.equals(storageClassAnalysis(), other.storageClassAnalysis());
    }

    @Override
    public String toString() {
        return ToString.builder("AnalyticsConfiguration").add("Id", id()).add("Filter", filter())
                .add("StorageClassAnalysis", storageClassAnalysis()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "StorageClassAnalysis":
            return Optional.ofNullable(clazz.cast(storageClassAnalysis()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AnalyticsConfiguration> {
        /**
         * The identifier used to represent an analytics configuration.
         * 
         * @param id
         *        The identifier used to represent an analytics configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The filter used to describe a set of objects for analyses. A filter must have exactly one prefix, one tag, or
         * one conjunction (AnalyticsAndOperator). If no filter is provided, all objects will be considered in any
         * analysis.
         * 
         * @param filter
         *        The filter used to describe a set of objects for analyses. A filter must have exactly one prefix, one
         *        tag, or one conjunction (AnalyticsAndOperator). If no filter is provided, all objects will be
         *        considered in any analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(AnalyticsFilter filter);

        /**
         * The filter used to describe a set of objects for analyses. A filter must have exactly one prefix, one tag, or
         * one conjunction (AnalyticsAndOperator). If no filter is provided, all objects will be considered in any
         * analysis. This is a convenience that creates an instance of the {@link AnalyticsFilter.Builder} avoiding the
         * need to create one manually via {@link AnalyticsFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalyticsFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(AnalyticsFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link AnalyticsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(AnalyticsFilter)
         */
        default Builder filter(Consumer<AnalyticsFilter.Builder> filter) {
            return filter(AnalyticsFilter.builder().applyMutation(filter).build());
        }

        /**
         * If present, it indicates that data related to access patterns will be collected and made available to analyze
         * the tradeoffs between different storage classes.
         * 
         * @param storageClassAnalysis
         *        If present, it indicates that data related to access patterns will be collected and made available to
         *        analyze the tradeoffs between different storage classes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageClassAnalysis(StorageClassAnalysis storageClassAnalysis);

        /**
         * If present, it indicates that data related to access patterns will be collected and made available to analyze
         * the tradeoffs between different storage classes. This is a convenience that creates an instance of the
         * {@link StorageClassAnalysis.Builder} avoiding the need to create one manually via
         * {@link StorageClassAnalysis#builder()}.
         *
         * When the {@link Consumer} completes, {@link StorageClassAnalysis.Builder#build()} is called immediately and
         * its result is passed to {@link #storageClassAnalysis(StorageClassAnalysis)}.
         * 
         * @param storageClassAnalysis
         *        a consumer that will call methods on {@link StorageClassAnalysis.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageClassAnalysis(StorageClassAnalysis)
         */
        default Builder storageClassAnalysis(Consumer<StorageClassAnalysis.Builder> storageClassAnalysis) {
            return storageClassAnalysis(StorageClassAnalysis.builder().applyMutation(storageClassAnalysis).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private AnalyticsFilter filter;

        private StorageClassAnalysis storageClassAnalysis;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsConfiguration model) {
            id(model.id);
            filter(model.filter);
            storageClassAnalysis(model.storageClassAnalysis);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final AnalyticsFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(AnalyticsFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(AnalyticsFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final StorageClassAnalysis.Builder getStorageClassAnalysis() {
            return storageClassAnalysis != null ? storageClassAnalysis.toBuilder() : null;
        }

        @Override
        public final Builder storageClassAnalysis(StorageClassAnalysis storageClassAnalysis) {
            this.storageClassAnalysis = storageClassAnalysis;
            return this;
        }

        public final void setStorageClassAnalysis(StorageClassAnalysis.BuilderImpl storageClassAnalysis) {
            this.storageClassAnalysis = storageClassAnalysis != null ? storageClassAnalysis.build() : null;
        }

        @Override
        public AnalyticsConfiguration build() {
            return new AnalyticsConfiguration(this);
        }
    }
}
