/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3;

import static software.amazon.awssdk.utils.FunctionalUtils.runAndLogError;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.http.response.DefaultErrorResponseHandler;
import software.amazon.awssdk.awscore.http.response.StaxResponseHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAclRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAclResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.GetBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLocationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLoggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse;
import software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.GetBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse;
import software.amazon.awssdk.services.s3.model.GetBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.GetObjectAclRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAclResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTorrentResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ListPartsRequest;
import software.amazon.awssdk.services.s3.model.ListPartsResponse;
import software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketAclRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAclResponse;
import software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.PutBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleRequest;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleResponse;
import software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest;
import software.amazon.awssdk.services.s3.model.PutBucketLoggingResponse;
import software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentResponse;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningResponse;
import software.amazon.awssdk.services.s3.model.PutBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.PutBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.PutObjectAclRequest;
import software.amazon.awssdk.services.s3.model.PutObjectAclResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.RestoreObjectRequest;
import software.amazon.awssdk.services.s3.model.RestoreObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.services.s3.model.UploadPartCopyRequest;
import software.amazon.awssdk.services.s3.model.UploadPartCopyResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsPublisher;
import software.amazon.awssdk.services.s3.paginators.ListObjectVersionsPublisher;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Publisher;
import software.amazon.awssdk.services.s3.paginators.ListPartsPublisher;
import software.amazon.awssdk.services.s3.transform.AbortMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.AbortMultipartUploadResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.BucketAlreadyExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.s3.transform.BucketAlreadyOwnedByYouExceptionUnmarshaller;
import software.amazon.awssdk.services.s3.transform.CompleteMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CompleteMultipartUploadResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.CopyObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CopyObjectResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.CreateBucketRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CreateBucketResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.CreateMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CreateMultipartUploadResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketAnalyticsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketAnalyticsConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketCorsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketCorsResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketInventoryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketInventoryConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketLifecycleRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketLifecycleResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketMetricsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketMetricsConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketReplicationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketTaggingResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketWebsiteRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketWebsiteResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectTaggingResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectsResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketAccelerateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketAccelerateConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketAclResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketAnalyticsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketAnalyticsConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketCorsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketCorsResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketInventoryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketInventoryConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLifecycleConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLifecycleRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLifecycleResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLocationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLocationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLoggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLoggingResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketMetricsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketMetricsConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketNotificationConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketNotificationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketNotificationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketReplicationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketRequestPaymentRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketRequestPaymentResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketTaggingResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketVersioningRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketVersioningResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketWebsiteRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketWebsiteResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectAclResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectTaggingResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectTorrentRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectTorrentResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.HeadBucketRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.HeadBucketResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.HeadObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.HeadObjectResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketAnalyticsConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketAnalyticsConfigurationsResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketInventoryConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketInventoryConfigurationsResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketMetricsConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketMetricsConfigurationsResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketsResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.ListMultipartUploadsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListMultipartUploadsResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.ListObjectVersionsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListObjectVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.ListObjectsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListObjectsResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.ListObjectsV2RequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListObjectsV2ResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.ListPartsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListPartsResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.NoSuchBucketExceptionUnmarshaller;
import software.amazon.awssdk.services.s3.transform.NoSuchKeyExceptionUnmarshaller;
import software.amazon.awssdk.services.s3.transform.NoSuchUploadExceptionUnmarshaller;
import software.amazon.awssdk.services.s3.transform.ObjectAlreadyInActiveTierErrorExceptionUnmarshaller;
import software.amazon.awssdk.services.s3.transform.ObjectNotInActiveTierErrorExceptionUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketAccelerateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketAccelerateConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketAclResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketAnalyticsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketAnalyticsConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketCorsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketCorsResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketInventoryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketInventoryConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketLifecycleConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketLifecycleRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketLifecycleResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketLoggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketLoggingResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketMetricsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketMetricsConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketNotificationConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketNotificationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketNotificationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketReplicationResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketRequestPaymentRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketRequestPaymentResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketTaggingResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketVersioningRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketVersioningResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketWebsiteRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketWebsiteResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectAclResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectTaggingResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.RestoreObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.RestoreObjectResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.StandardS3ExceptionUnmarshaller;
import software.amazon.awssdk.services.s3.transform.UploadPartCopyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.UploadPartCopyResponseUnmarshaller;
import software.amazon.awssdk.services.s3.transform.UploadPartRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.UploadPartResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link S3AsyncClient}.
 *
 * @see S3AsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultS3AsyncClient implements S3AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultS3AsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final List<Unmarshaller<AwsServiceException, Node>> exceptionUnmarshallers;

    protected DefaultS3AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.exceptionUnmarshallers = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Aborts a multipart upload.
     * </p>
     * <p>
     * To verify that all parts have been removed, so you don't get charged for the part storage, you should call the
     * List Parts operation and ensure the parts list is empty.
     * </p>
     *
     * @param abortMultipartUploadRequest
     * @return A Java Future containing the result of the AbortMultipartUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchUploadException The specified multipart upload does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.AbortMultipartUpload
     */
    @Override
    public CompletableFuture<AbortMultipartUploadResponse> abortMultipartUpload(
            AbortMultipartUploadRequest abortMultipartUploadRequest) {
        try {

            StaxResponseHandler<AbortMultipartUploadResponse> responseHandler = new StaxResponseHandler<AbortMultipartUploadResponse>(
                    new AbortMultipartUploadResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<AbortMultipartUploadRequest, AbortMultipartUploadResponse>()
                    .withMarshaller(new AbortMultipartUploadRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(abortMultipartUploadRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Completes a multipart upload by assembling previously uploaded parts.
     *
     * @param completeMultipartUploadRequest
     * @return A Java Future containing the result of the CompleteMultipartUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.CompleteMultipartUpload
     */
    @Override
    public CompletableFuture<CompleteMultipartUploadResponse> completeMultipartUpload(
            CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        try {

            StaxResponseHandler<CompleteMultipartUploadResponse> responseHandler = new StaxResponseHandler<CompleteMultipartUploadResponse>(
                    new CompleteMultipartUploadResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<CompleteMultipartUploadRequest, CompleteMultipartUploadResponse>()
                            .withMarshaller(new CompleteMultipartUploadRequestMarshaller()).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(completeMultipartUploadRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a copy of an object that is already stored in Amazon S3.
     *
     * @param copyObjectRequest
     * @return A Java Future containing the result of the CopyObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ObjectNotInActiveTierErrorException The source object of the COPY operation is not in the active tier
     *         and is only stored in Amazon Glacier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.CopyObject
     */
    @Override
    public CompletableFuture<CopyObjectResponse> copyObject(CopyObjectRequest copyObjectRequest) {
        try {

            StaxResponseHandler<CopyObjectResponse> responseHandler = new StaxResponseHandler<CopyObjectResponse>(
                    new CopyObjectResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<CopyObjectRequest, CopyObjectResponse>()
                    .withMarshaller(new CopyObjectRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(copyObjectRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a new bucket.
     *
     * @param createBucketRequest
     * @return A Java Future containing the result of the CreateBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BucketAlreadyExistsException The requested bucket name is not available. The bucket namespace is
     *         shared by all users of the system. Please select a different name and try again.</li>
     *         <li>BucketAlreadyOwnedByYouException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.CreateBucket
     */
    @Override
    public CompletableFuture<CreateBucketResponse> createBucket(CreateBucketRequest createBucketRequest) {
        try {

            StaxResponseHandler<CreateBucketResponse> responseHandler = new StaxResponseHandler<CreateBucketResponse>(
                    new CreateBucketResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<CreateBucketRequest, CreateBucketResponse>()
                    .withMarshaller(new CreateBucketRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createBucketRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initiates a multipart upload and returns an upload ID.
     * </p>
     * <p>
     * <b>Note:</b> After you initiate multipart upload and upload one or more parts, you must either complete or abort
     * multipart upload in order to stop getting charged for storage of the uploaded parts. Only after you either
     * complete or abort multipart upload, Amazon S3 frees up the parts storage and stops charging you for the parts
     * storage.
     * </p>
     *
     * @param createMultipartUploadRequest
     * @return A Java Future containing the result of the CreateMultipartUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.CreateMultipartUpload
     */
    @Override
    public CompletableFuture<CreateMultipartUploadResponse> createMultipartUpload(
            CreateMultipartUploadRequest createMultipartUploadRequest) {
        try {

            StaxResponseHandler<CreateMultipartUploadResponse> responseHandler = new StaxResponseHandler<CreateMultipartUploadResponse>(
                    new CreateMultipartUploadResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<CreateMultipartUploadRequest, CreateMultipartUploadResponse>()
                    .withMarshaller(new CreateMultipartUploadRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createMultipartUploadRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes the bucket. All objects (including all object versions and Delete Markers) in the bucket must be deleted
     * before the bucket itself can be deleted.
     *
     * @param deleteBucketRequest
     * @return A Java Future containing the result of the DeleteBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.DeleteBucket
     */
    @Override
    public CompletableFuture<DeleteBucketResponse> deleteBucket(DeleteBucketRequest deleteBucketRequest) {
        try {

            StaxResponseHandler<DeleteBucketResponse> responseHandler = new StaxResponseHandler<DeleteBucketResponse>(
                    new DeleteBucketResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<DeleteBucketRequest, DeleteBucketResponse>()
                    .withMarshaller(new DeleteBucketRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteBucketRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes an analytics configuration for the bucket (specified by the analytics configuration ID).
     *
     * @param deleteBucketAnalyticsConfigurationRequest
     * @return A Java Future containing the result of the DeleteBucketAnalyticsConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.DeleteBucketAnalyticsConfiguration
     */
    @Override
    public CompletableFuture<DeleteBucketAnalyticsConfigurationResponse> deleteBucketAnalyticsConfiguration(
            DeleteBucketAnalyticsConfigurationRequest deleteBucketAnalyticsConfigurationRequest) {
        try {

            StaxResponseHandler<DeleteBucketAnalyticsConfigurationResponse> responseHandler = new StaxResponseHandler<DeleteBucketAnalyticsConfigurationResponse>(
                    new DeleteBucketAnalyticsConfigurationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteBucketAnalyticsConfigurationRequest, DeleteBucketAnalyticsConfigurationResponse>()
                            .withMarshaller(new DeleteBucketAnalyticsConfigurationRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteBucketAnalyticsConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes the cors configuration information set for the bucket.
     *
     * @param deleteBucketCorsRequest
     * @return A Java Future containing the result of the DeleteBucketCors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.DeleteBucketCors
     */
    @Override
    public CompletableFuture<DeleteBucketCorsResponse> deleteBucketCors(DeleteBucketCorsRequest deleteBucketCorsRequest) {
        try {

            StaxResponseHandler<DeleteBucketCorsResponse> responseHandler = new StaxResponseHandler<DeleteBucketCorsResponse>(
                    new DeleteBucketCorsResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<DeleteBucketCorsRequest, DeleteBucketCorsResponse>()
                    .withMarshaller(new DeleteBucketCorsRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteBucketCorsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes an inventory configuration (identified by the inventory ID) from the bucket.
     *
     * @param deleteBucketInventoryConfigurationRequest
     * @return A Java Future containing the result of the DeleteBucketInventoryConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.DeleteBucketInventoryConfiguration
     */
    @Override
    public CompletableFuture<DeleteBucketInventoryConfigurationResponse> deleteBucketInventoryConfiguration(
            DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest) {
        try {

            StaxResponseHandler<DeleteBucketInventoryConfigurationResponse> responseHandler = new StaxResponseHandler<DeleteBucketInventoryConfigurationResponse>(
                    new DeleteBucketInventoryConfigurationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteBucketInventoryConfigurationRequest, DeleteBucketInventoryConfigurationResponse>()
                            .withMarshaller(new DeleteBucketInventoryConfigurationRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteBucketInventoryConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes the lifecycle configuration from the bucket.
     *
     * @param deleteBucketLifecycleRequest
     * @return A Java Future containing the result of the DeleteBucketLifecycle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.DeleteBucketLifecycle
     */
    @Override
    public CompletableFuture<DeleteBucketLifecycleResponse> deleteBucketLifecycle(
            DeleteBucketLifecycleRequest deleteBucketLifecycleRequest) {
        try {

            StaxResponseHandler<DeleteBucketLifecycleResponse> responseHandler = new StaxResponseHandler<DeleteBucketLifecycleResponse>(
                    new DeleteBucketLifecycleResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<DeleteBucketLifecycleRequest, DeleteBucketLifecycleResponse>()
                    .withMarshaller(new DeleteBucketLifecycleRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteBucketLifecycleRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a metrics configuration (specified by the metrics configuration ID) from the bucket.
     *
     * @param deleteBucketMetricsConfigurationRequest
     * @return A Java Future containing the result of the DeleteBucketMetricsConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.DeleteBucketMetricsConfiguration
     */
    @Override
    public CompletableFuture<DeleteBucketMetricsConfigurationResponse> deleteBucketMetricsConfiguration(
            DeleteBucketMetricsConfigurationRequest deleteBucketMetricsConfigurationRequest) {
        try {

            StaxResponseHandler<DeleteBucketMetricsConfigurationResponse> responseHandler = new StaxResponseHandler<DeleteBucketMetricsConfigurationResponse>(
                    new DeleteBucketMetricsConfigurationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteBucketMetricsConfigurationRequest, DeleteBucketMetricsConfigurationResponse>()
                            .withMarshaller(new DeleteBucketMetricsConfigurationRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteBucketMetricsConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes the policy from the bucket.
     *
     * @param deleteBucketPolicyRequest
     * @return A Java Future containing the result of the DeleteBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.DeleteBucketPolicy
     */
    @Override
    public CompletableFuture<DeleteBucketPolicyResponse> deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) {
        try {

            StaxResponseHandler<DeleteBucketPolicyResponse> responseHandler = new StaxResponseHandler<DeleteBucketPolicyResponse>(
                    new DeleteBucketPolicyResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<DeleteBucketPolicyRequest, DeleteBucketPolicyResponse>()
                    .withMarshaller(new DeleteBucketPolicyRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteBucketPolicyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes the replication configuration from the bucket.
     *
     * @param deleteBucketReplicationRequest
     * @return A Java Future containing the result of the DeleteBucketReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.DeleteBucketReplication
     */
    @Override
    public CompletableFuture<DeleteBucketReplicationResponse> deleteBucketReplication(
            DeleteBucketReplicationRequest deleteBucketReplicationRequest) {
        try {

            StaxResponseHandler<DeleteBucketReplicationResponse> responseHandler = new StaxResponseHandler<DeleteBucketReplicationResponse>(
                    new DeleteBucketReplicationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteBucketReplicationRequest, DeleteBucketReplicationResponse>()
                            .withMarshaller(new DeleteBucketReplicationRequestMarshaller()).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteBucketReplicationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes the tags from the bucket.
     *
     * @param deleteBucketTaggingRequest
     * @return A Java Future containing the result of the DeleteBucketTagging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.DeleteBucketTagging
     */
    @Override
    public CompletableFuture<DeleteBucketTaggingResponse> deleteBucketTagging(
            DeleteBucketTaggingRequest deleteBucketTaggingRequest) {
        try {

            StaxResponseHandler<DeleteBucketTaggingResponse> responseHandler = new StaxResponseHandler<DeleteBucketTaggingResponse>(
                    new DeleteBucketTaggingResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<DeleteBucketTaggingRequest, DeleteBucketTaggingResponse>()
                    .withMarshaller(new DeleteBucketTaggingRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteBucketTaggingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * This operation removes the website configuration from the bucket.
     *
     * @param deleteBucketWebsiteRequest
     * @return A Java Future containing the result of the DeleteBucketWebsite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.DeleteBucketWebsite
     */
    @Override
    public CompletableFuture<DeleteBucketWebsiteResponse> deleteBucketWebsite(
            DeleteBucketWebsiteRequest deleteBucketWebsiteRequest) {
        try {

            StaxResponseHandler<DeleteBucketWebsiteResponse> responseHandler = new StaxResponseHandler<DeleteBucketWebsiteResponse>(
                    new DeleteBucketWebsiteResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<DeleteBucketWebsiteRequest, DeleteBucketWebsiteResponse>()
                    .withMarshaller(new DeleteBucketWebsiteRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteBucketWebsiteRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Removes the null version (if there is one) of an object and inserts a delete marker, which becomes the latest
     * version of the object. If there isn't a null version, Amazon S3 does not remove any objects.
     *
     * @param deleteObjectRequest
     * @return A Java Future containing the result of the DeleteObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.DeleteObject
     */
    @Override
    public CompletableFuture<DeleteObjectResponse> deleteObject(DeleteObjectRequest deleteObjectRequest) {
        try {

            StaxResponseHandler<DeleteObjectResponse> responseHandler = new StaxResponseHandler<DeleteObjectResponse>(
                    new DeleteObjectResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<DeleteObjectRequest, DeleteObjectResponse>()
                    .withMarshaller(new DeleteObjectRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteObjectRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Removes the tag-set from an existing object.
     *
     * @param deleteObjectTaggingRequest
     * @return A Java Future containing the result of the DeleteObjectTagging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.DeleteObjectTagging
     */
    @Override
    public CompletableFuture<DeleteObjectTaggingResponse> deleteObjectTagging(
            DeleteObjectTaggingRequest deleteObjectTaggingRequest) {
        try {

            StaxResponseHandler<DeleteObjectTaggingResponse> responseHandler = new StaxResponseHandler<DeleteObjectTaggingResponse>(
                    new DeleteObjectTaggingResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<DeleteObjectTaggingRequest, DeleteObjectTaggingResponse>()
                    .withMarshaller(new DeleteObjectTaggingRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteObjectTaggingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * This operation enables you to delete multiple objects from a bucket using a single HTTP request. You may specify
     * up to 1000 keys.
     *
     * @param deleteObjectsRequest
     * @return A Java Future containing the result of the DeleteObjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.DeleteObjects
     */
    @Override
    public CompletableFuture<DeleteObjectsResponse> deleteObjects(DeleteObjectsRequest deleteObjectsRequest) {
        try {

            StaxResponseHandler<DeleteObjectsResponse> responseHandler = new StaxResponseHandler<DeleteObjectsResponse>(
                    new DeleteObjectsResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<DeleteObjectsRequest, DeleteObjectsResponse>()
                    .withMarshaller(new DeleteObjectsRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteObjectsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the accelerate configuration of a bucket.
     *
     * @param getBucketAccelerateConfigurationRequest
     * @return A Java Future containing the result of the GetBucketAccelerateConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketAccelerateConfiguration
     */
    @Override
    public CompletableFuture<GetBucketAccelerateConfigurationResponse> getBucketAccelerateConfiguration(
            GetBucketAccelerateConfigurationRequest getBucketAccelerateConfigurationRequest) {
        try {

            StaxResponseHandler<GetBucketAccelerateConfigurationResponse> responseHandler = new StaxResponseHandler<GetBucketAccelerateConfigurationResponse>(
                    new GetBucketAccelerateConfigurationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<GetBucketAccelerateConfigurationRequest, GetBucketAccelerateConfigurationResponse>()
                            .withMarshaller(new GetBucketAccelerateConfigurationRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getBucketAccelerateConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Gets the access control policy for the bucket.
     *
     * @param getBucketAclRequest
     * @return A Java Future containing the result of the GetBucketAcl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketAcl
     */
    @Override
    public CompletableFuture<GetBucketAclResponse> getBucketAcl(GetBucketAclRequest getBucketAclRequest) {
        try {

            StaxResponseHandler<GetBucketAclResponse> responseHandler = new StaxResponseHandler<GetBucketAclResponse>(
                    new GetBucketAclResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<GetBucketAclRequest, GetBucketAclResponse>()
                    .withMarshaller(new GetBucketAclRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBucketAclRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Gets an analytics configuration for the bucket (specified by the analytics configuration ID).
     *
     * @param getBucketAnalyticsConfigurationRequest
     * @return A Java Future containing the result of the GetBucketAnalyticsConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketAnalyticsConfiguration
     */
    @Override
    public CompletableFuture<GetBucketAnalyticsConfigurationResponse> getBucketAnalyticsConfiguration(
            GetBucketAnalyticsConfigurationRequest getBucketAnalyticsConfigurationRequest) {
        try {

            StaxResponseHandler<GetBucketAnalyticsConfigurationResponse> responseHandler = new StaxResponseHandler<GetBucketAnalyticsConfigurationResponse>(
                    new GetBucketAnalyticsConfigurationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<GetBucketAnalyticsConfigurationRequest, GetBucketAnalyticsConfigurationResponse>()
                            .withMarshaller(new GetBucketAnalyticsConfigurationRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getBucketAnalyticsConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the cors configuration for the bucket.
     *
     * @param getBucketCorsRequest
     * @return A Java Future containing the result of the GetBucketCors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketCors
     */
    @Override
    public CompletableFuture<GetBucketCorsResponse> getBucketCors(GetBucketCorsRequest getBucketCorsRequest) {
        try {

            StaxResponseHandler<GetBucketCorsResponse> responseHandler = new StaxResponseHandler<GetBucketCorsResponse>(
                    new GetBucketCorsResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<GetBucketCorsRequest, GetBucketCorsResponse>()
                    .withMarshaller(new GetBucketCorsRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBucketCorsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns an inventory configuration (identified by the inventory ID) from the bucket.
     *
     * @param getBucketInventoryConfigurationRequest
     * @return A Java Future containing the result of the GetBucketInventoryConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketInventoryConfiguration
     */
    @Override
    public CompletableFuture<GetBucketInventoryConfigurationResponse> getBucketInventoryConfiguration(
            GetBucketInventoryConfigurationRequest getBucketInventoryConfigurationRequest) {
        try {

            StaxResponseHandler<GetBucketInventoryConfigurationResponse> responseHandler = new StaxResponseHandler<GetBucketInventoryConfigurationResponse>(
                    new GetBucketInventoryConfigurationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<GetBucketInventoryConfigurationRequest, GetBucketInventoryConfigurationResponse>()
                            .withMarshaller(new GetBucketInventoryConfigurationRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getBucketInventoryConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deprecated, see the GetBucketLifecycleConfiguration operation.
     *
     * @param getBucketLifecycleRequest
     * @return A Java Future containing the result of the GetBucketLifecycle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketLifecycle
     */
    @Override
    public CompletableFuture<GetBucketLifecycleResponse> getBucketLifecycle(GetBucketLifecycleRequest getBucketLifecycleRequest) {
        try {

            StaxResponseHandler<GetBucketLifecycleResponse> responseHandler = new StaxResponseHandler<GetBucketLifecycleResponse>(
                    new GetBucketLifecycleResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<GetBucketLifecycleRequest, GetBucketLifecycleResponse>()
                    .withMarshaller(new GetBucketLifecycleRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBucketLifecycleRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the lifecycle configuration information set on the bucket.
     *
     * @param getBucketLifecycleConfigurationRequest
     * @return A Java Future containing the result of the GetBucketLifecycleConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketLifecycleConfiguration
     */
    @Override
    public CompletableFuture<GetBucketLifecycleConfigurationResponse> getBucketLifecycleConfiguration(
            GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) {
        try {

            StaxResponseHandler<GetBucketLifecycleConfigurationResponse> responseHandler = new StaxResponseHandler<GetBucketLifecycleConfigurationResponse>(
                    new GetBucketLifecycleConfigurationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<GetBucketLifecycleConfigurationRequest, GetBucketLifecycleConfigurationResponse>()
                            .withMarshaller(new GetBucketLifecycleConfigurationRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getBucketLifecycleConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the region the bucket resides in.
     *
     * @param getBucketLocationRequest
     * @return A Java Future containing the result of the GetBucketLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketLocation
     */
    @Override
    public CompletableFuture<GetBucketLocationResponse> getBucketLocation(GetBucketLocationRequest getBucketLocationRequest) {
        try {

            StaxResponseHandler<GetBucketLocationResponse> responseHandler = new StaxResponseHandler<GetBucketLocationResponse>(
                    new GetBucketLocationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<GetBucketLocationRequest, GetBucketLocationResponse>()
                    .withMarshaller(new GetBucketLocationRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBucketLocationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the logging status of a bucket and the permissions users have to view and modify that status. To use GET,
     * you must be the bucket owner.
     *
     * @param getBucketLoggingRequest
     * @return A Java Future containing the result of the GetBucketLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketLogging
     */
    @Override
    public CompletableFuture<GetBucketLoggingResponse> getBucketLogging(GetBucketLoggingRequest getBucketLoggingRequest) {
        try {

            StaxResponseHandler<GetBucketLoggingResponse> responseHandler = new StaxResponseHandler<GetBucketLoggingResponse>(
                    new GetBucketLoggingResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<GetBucketLoggingRequest, GetBucketLoggingResponse>()
                    .withMarshaller(new GetBucketLoggingRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBucketLoggingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Gets a metrics configuration (specified by the metrics configuration ID) from the bucket.
     *
     * @param getBucketMetricsConfigurationRequest
     * @return A Java Future containing the result of the GetBucketMetricsConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketMetricsConfiguration
     */
    @Override
    public CompletableFuture<GetBucketMetricsConfigurationResponse> getBucketMetricsConfiguration(
            GetBucketMetricsConfigurationRequest getBucketMetricsConfigurationRequest) {
        try {

            StaxResponseHandler<GetBucketMetricsConfigurationResponse> responseHandler = new StaxResponseHandler<GetBucketMetricsConfigurationResponse>(
                    new GetBucketMetricsConfigurationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<GetBucketMetricsConfigurationRequest, GetBucketMetricsConfigurationResponse>()
                            .withMarshaller(new GetBucketMetricsConfigurationRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getBucketMetricsConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deprecated, see the GetBucketNotificationConfiguration operation.
     *
     * @param getBucketNotificationRequest
     * @return A Java Future containing the result of the GetBucketNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketNotification
     */
    @Override
    public CompletableFuture<GetBucketNotificationResponse> getBucketNotification(
            GetBucketNotificationRequest getBucketNotificationRequest) {
        try {

            StaxResponseHandler<GetBucketNotificationResponse> responseHandler = new StaxResponseHandler<GetBucketNotificationResponse>(
                    new GetBucketNotificationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<GetBucketNotificationRequest, GetBucketNotificationResponse>()
                    .withMarshaller(new GetBucketNotificationRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBucketNotificationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the notification configuration of a bucket.
     *
     * @param getBucketNotificationConfigurationRequest
     * @return A Java Future containing the result of the GetBucketNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketNotificationConfiguration
     */
    @Override
    public CompletableFuture<GetBucketNotificationConfigurationResponse> getBucketNotificationConfiguration(
            GetBucketNotificationConfigurationRequest getBucketNotificationConfigurationRequest) {
        try {

            StaxResponseHandler<GetBucketNotificationConfigurationResponse> responseHandler = new StaxResponseHandler<GetBucketNotificationConfigurationResponse>(
                    new GetBucketNotificationConfigurationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<GetBucketNotificationConfigurationRequest, GetBucketNotificationConfigurationResponse>()
                            .withMarshaller(new GetBucketNotificationConfigurationRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getBucketNotificationConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the policy of a specified bucket.
     *
     * @param getBucketPolicyRequest
     * @return A Java Future containing the result of the GetBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketPolicy
     */
    @Override
    public CompletableFuture<GetBucketPolicyResponse> getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) {
        try {
            HttpResponseHandler<GetBucketPolicyResponse> responseHandler = (response, __) -> new GetBucketPolicyResponseUnmarshaller()
                    .unmarshall(response);

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<GetBucketPolicyRequest, GetBucketPolicyResponse>()
                    .withMarshaller(new GetBucketPolicyRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBucketPolicyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the replication configuration of a bucket.
     *
     * @param getBucketReplicationRequest
     * @return A Java Future containing the result of the GetBucketReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketReplication
     */
    @Override
    public CompletableFuture<GetBucketReplicationResponse> getBucketReplication(
            GetBucketReplicationRequest getBucketReplicationRequest) {
        try {

            StaxResponseHandler<GetBucketReplicationResponse> responseHandler = new StaxResponseHandler<GetBucketReplicationResponse>(
                    new GetBucketReplicationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<GetBucketReplicationRequest, GetBucketReplicationResponse>()
                    .withMarshaller(new GetBucketReplicationRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBucketReplicationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the request payment configuration of a bucket.
     *
     * @param getBucketRequestPaymentRequest
     * @return A Java Future containing the result of the GetBucketRequestPayment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketRequestPayment
     */
    @Override
    public CompletableFuture<GetBucketRequestPaymentResponse> getBucketRequestPayment(
            GetBucketRequestPaymentRequest getBucketRequestPaymentRequest) {
        try {

            StaxResponseHandler<GetBucketRequestPaymentResponse> responseHandler = new StaxResponseHandler<GetBucketRequestPaymentResponse>(
                    new GetBucketRequestPaymentResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<GetBucketRequestPaymentRequest, GetBucketRequestPaymentResponse>()
                            .withMarshaller(new GetBucketRequestPaymentRequestMarshaller()).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getBucketRequestPaymentRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the tag set associated with the bucket.
     *
     * @param getBucketTaggingRequest
     * @return A Java Future containing the result of the GetBucketTagging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketTagging
     */
    @Override
    public CompletableFuture<GetBucketTaggingResponse> getBucketTagging(GetBucketTaggingRequest getBucketTaggingRequest) {
        try {

            StaxResponseHandler<GetBucketTaggingResponse> responseHandler = new StaxResponseHandler<GetBucketTaggingResponse>(
                    new GetBucketTaggingResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<GetBucketTaggingRequest, GetBucketTaggingResponse>()
                    .withMarshaller(new GetBucketTaggingRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBucketTaggingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the versioning state of a bucket.
     *
     * @param getBucketVersioningRequest
     * @return A Java Future containing the result of the GetBucketVersioning operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketVersioning
     */
    @Override
    public CompletableFuture<GetBucketVersioningResponse> getBucketVersioning(
            GetBucketVersioningRequest getBucketVersioningRequest) {
        try {

            StaxResponseHandler<GetBucketVersioningResponse> responseHandler = new StaxResponseHandler<GetBucketVersioningResponse>(
                    new GetBucketVersioningResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<GetBucketVersioningRequest, GetBucketVersioningResponse>()
                    .withMarshaller(new GetBucketVersioningRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBucketVersioningRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the website configuration for a bucket.
     *
     * @param getBucketWebsiteRequest
     * @return A Java Future containing the result of the GetBucketWebsite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetBucketWebsite
     */
    @Override
    public CompletableFuture<GetBucketWebsiteResponse> getBucketWebsite(GetBucketWebsiteRequest getBucketWebsiteRequest) {
        try {

            StaxResponseHandler<GetBucketWebsiteResponse> responseHandler = new StaxResponseHandler<GetBucketWebsiteResponse>(
                    new GetBucketWebsiteResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<GetBucketWebsiteRequest, GetBucketWebsiteResponse>()
                    .withMarshaller(new GetBucketWebsiteRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBucketWebsiteRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves objects from Amazon S3.
     *
     * @param getObjectRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows 'Object data.'.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchKeyException The specified key does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetObject
     */
    @Override
    public <ReturnT> CompletableFuture<ReturnT> getObject(GetObjectRequest getObjectRequest,
            AsyncResponseTransformer<GetObjectResponse, ReturnT> asyncResponseTransformer) {
        try {

            HttpResponseHandler<GetObjectResponse> responseHandler = StaxResponseHandler
                    .createStreamingResponseHandler(new GetObjectResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(
                            new ClientExecutionParams<GetObjectRequest, GetObjectResponse>()
                                    .withMarshaller(new GetObjectRequestMarshaller()).withResponseHandler(responseHandler)
                                    .withErrorResponseHandler(errorResponseHandler).withInput(getObjectRequest),
                            asyncResponseTransformer).whenComplete((r, e) -> {
                        if (e != null) {
                            asyncResponseTransformer.exceptionOccurred(e);
                        }
                    });
        } catch (Throwable t) {
            runAndLogError(log, "Exception thrown in exceptionOccurred callback, ignoring",
                    () -> asyncResponseTransformer.exceptionOccurred(t));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the access control list (ACL) of an object.
     *
     * @param getObjectAclRequest
     * @return A Java Future containing the result of the GetObjectAcl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchKeyException The specified key does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetObjectAcl
     */
    @Override
    public CompletableFuture<GetObjectAclResponse> getObjectAcl(GetObjectAclRequest getObjectAclRequest) {
        try {

            StaxResponseHandler<GetObjectAclResponse> responseHandler = new StaxResponseHandler<GetObjectAclResponse>(
                    new GetObjectAclResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<GetObjectAclRequest, GetObjectAclResponse>()
                    .withMarshaller(new GetObjectAclRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getObjectAclRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the tag-set of an object.
     *
     * @param getObjectTaggingRequest
     * @return A Java Future containing the result of the GetObjectTagging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetObjectTagging
     */
    @Override
    public CompletableFuture<GetObjectTaggingResponse> getObjectTagging(GetObjectTaggingRequest getObjectTaggingRequest) {
        try {

            StaxResponseHandler<GetObjectTaggingResponse> responseHandler = new StaxResponseHandler<GetObjectTaggingResponse>(
                    new GetObjectTaggingResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<GetObjectTaggingRequest, GetObjectTaggingResponse>()
                    .withMarshaller(new GetObjectTaggingRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getObjectTaggingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Return torrent files from a bucket.
     *
     * @param getObjectTorrentRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows ''.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.GetObjectTorrent
     */
    @Override
    public <ReturnT> CompletableFuture<ReturnT> getObjectTorrent(GetObjectTorrentRequest getObjectTorrentRequest,
            AsyncResponseTransformer<GetObjectTorrentResponse, ReturnT> asyncResponseTransformer) {
        try {

            HttpResponseHandler<GetObjectTorrentResponse> responseHandler = StaxResponseHandler
                    .createStreamingResponseHandler(new GetObjectTorrentResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(
                    new ClientExecutionParams<GetObjectTorrentRequest, GetObjectTorrentResponse>()
                            .withMarshaller(new GetObjectTorrentRequestMarshaller()).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getObjectTorrentRequest),
                    asyncResponseTransformer).whenComplete((r, e) -> {
                if (e != null) {
                    asyncResponseTransformer.exceptionOccurred(e);
                }
            });
        } catch (Throwable t) {
            runAndLogError(log, "Exception thrown in exceptionOccurred callback, ignoring",
                    () -> asyncResponseTransformer.exceptionOccurred(t));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * This operation is useful to determine if a bucket exists and you have permission to access it.
     *
     * @param headBucketRequest
     * @return A Java Future containing the result of the HeadBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchBucketException The specified bucket does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.HeadBucket
     */
    @Override
    public CompletableFuture<HeadBucketResponse> headBucket(HeadBucketRequest headBucketRequest) {
        try {

            StaxResponseHandler<HeadBucketResponse> responseHandler = new StaxResponseHandler<HeadBucketResponse>(
                    new HeadBucketResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<HeadBucketRequest, HeadBucketResponse>()
                    .withMarshaller(new HeadBucketRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(headBucketRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * The HEAD operation retrieves metadata from an object without returning the object itself. This operation is
     * useful if you're only interested in an object's metadata. To use HEAD, you must have READ access to the object.
     *
     * @param headObjectRequest
     * @return A Java Future containing the result of the HeadObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchKeyException The specified key does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.HeadObject
     */
    @Override
    public CompletableFuture<HeadObjectResponse> headObject(HeadObjectRequest headObjectRequest) {
        try {

            StaxResponseHandler<HeadObjectResponse> responseHandler = new StaxResponseHandler<HeadObjectResponse>(
                    new HeadObjectResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<HeadObjectRequest, HeadObjectResponse>()
                    .withMarshaller(new HeadObjectRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(headObjectRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the analytics configurations for the bucket.
     *
     * @param listBucketAnalyticsConfigurationsRequest
     * @return A Java Future containing the result of the ListBucketAnalyticsConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.ListBucketAnalyticsConfigurations
     */
    @Override
    public CompletableFuture<ListBucketAnalyticsConfigurationsResponse> listBucketAnalyticsConfigurations(
            ListBucketAnalyticsConfigurationsRequest listBucketAnalyticsConfigurationsRequest) {
        try {

            StaxResponseHandler<ListBucketAnalyticsConfigurationsResponse> responseHandler = new StaxResponseHandler<ListBucketAnalyticsConfigurationsResponse>(
                    new ListBucketAnalyticsConfigurationsResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<ListBucketAnalyticsConfigurationsRequest, ListBucketAnalyticsConfigurationsResponse>()
                            .withMarshaller(new ListBucketAnalyticsConfigurationsRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listBucketAnalyticsConfigurationsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns a list of inventory configurations for the bucket.
     *
     * @param listBucketInventoryConfigurationsRequest
     * @return A Java Future containing the result of the ListBucketInventoryConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.ListBucketInventoryConfigurations
     */
    @Override
    public CompletableFuture<ListBucketInventoryConfigurationsResponse> listBucketInventoryConfigurations(
            ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest) {
        try {

            StaxResponseHandler<ListBucketInventoryConfigurationsResponse> responseHandler = new StaxResponseHandler<ListBucketInventoryConfigurationsResponse>(
                    new ListBucketInventoryConfigurationsResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<ListBucketInventoryConfigurationsRequest, ListBucketInventoryConfigurationsResponse>()
                            .withMarshaller(new ListBucketInventoryConfigurationsRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listBucketInventoryConfigurationsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the metrics configurations for the bucket.
     *
     * @param listBucketMetricsConfigurationsRequest
     * @return A Java Future containing the result of the ListBucketMetricsConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.ListBucketMetricsConfigurations
     */
    @Override
    public CompletableFuture<ListBucketMetricsConfigurationsResponse> listBucketMetricsConfigurations(
            ListBucketMetricsConfigurationsRequest listBucketMetricsConfigurationsRequest) {
        try {

            StaxResponseHandler<ListBucketMetricsConfigurationsResponse> responseHandler = new StaxResponseHandler<ListBucketMetricsConfigurationsResponse>(
                    new ListBucketMetricsConfigurationsResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<ListBucketMetricsConfigurationsRequest, ListBucketMetricsConfigurationsResponse>()
                            .withMarshaller(new ListBucketMetricsConfigurationsRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listBucketMetricsConfigurationsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns a list of all buckets owned by the authenticated sender of the request.
     *
     * @param listBucketsRequest
     * @return A Java Future containing the result of the ListBuckets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.ListBuckets
     */
    @Override
    public CompletableFuture<ListBucketsResponse> listBuckets(ListBucketsRequest listBucketsRequest) {
        try {

            StaxResponseHandler<ListBucketsResponse> responseHandler = new StaxResponseHandler<ListBucketsResponse>(
                    new ListBucketsResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<ListBucketsRequest, ListBucketsResponse>()
                    .withMarshaller(new ListBucketsRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listBucketsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * This operation lists in-progress multipart uploads.
     *
     * @param listMultipartUploadsRequest
     * @return A Java Future containing the result of the ListMultipartUploads operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.ListMultipartUploads
     */
    @Override
    public CompletableFuture<ListMultipartUploadsResponse> listMultipartUploads(
            ListMultipartUploadsRequest listMultipartUploadsRequest) {
        try {

            StaxResponseHandler<ListMultipartUploadsResponse> responseHandler = new StaxResponseHandler<ListMultipartUploadsResponse>(
                    new ListMultipartUploadsResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<ListMultipartUploadsRequest, ListMultipartUploadsResponse>()
                    .withMarshaller(new ListMultipartUploadsRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listMultipartUploadsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * This operation lists in-progress multipart uploads.<br/>
     * <p>
     * This is a variant of
     * {@link #listMultipartUploads(software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsPublisher publisher = client.listMultipartUploadsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsPublisher publisher = client.listMultipartUploadsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultipartUploads(software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMultipartUploadsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.ListMultipartUploads
     */
    public ListMultipartUploadsPublisher listMultipartUploadsPaginator(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        return new ListMultipartUploadsPublisher(this, applyPaginatorUserAgent(listMultipartUploadsRequest));
    }

    /**
     * Returns metadata about all of the versions of objects in a bucket.
     *
     * @param listObjectVersionsRequest
     * @return A Java Future containing the result of the ListObjectVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.ListObjectVersions
     */
    @Override
    public CompletableFuture<ListObjectVersionsResponse> listObjectVersions(ListObjectVersionsRequest listObjectVersionsRequest) {
        try {

            StaxResponseHandler<ListObjectVersionsResponse> responseHandler = new StaxResponseHandler<ListObjectVersionsResponse>(
                    new ListObjectVersionsResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<ListObjectVersionsRequest, ListObjectVersionsResponse>()
                    .withMarshaller(new ListObjectVersionsRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listObjectVersionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns metadata about all of the versions of objects in a bucket.<br/>
     * <p>
     * This is a variant of
     * {@link #listObjectVersions(software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectVersionsPublisher publisher = client.listObjectVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectVersionsPublisher publisher = client.listObjectVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectVersions(software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listObjectVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.ListObjectVersions
     */
    public ListObjectVersionsPublisher listObjectVersionsPaginator(ListObjectVersionsRequest listObjectVersionsRequest) {
        return new ListObjectVersionsPublisher(this, applyPaginatorUserAgent(listObjectVersionsRequest));
    }

    /**
     * Returns some or all (up to 1000) of the objects in a bucket. You can use the request parameters as selection
     * criteria to return a subset of the objects in a bucket.
     *
     * @param listObjectsRequest
     * @return A Java Future containing the result of the ListObjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchBucketException The specified bucket does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.ListObjects
     */
    @Override
    public CompletableFuture<ListObjectsResponse> listObjects(ListObjectsRequest listObjectsRequest) {
        try {

            StaxResponseHandler<ListObjectsResponse> responseHandler = new StaxResponseHandler<ListObjectsResponse>(
                    new ListObjectsResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<ListObjectsRequest, ListObjectsResponse>()
                    .withMarshaller(new ListObjectsRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listObjectsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns some or all (up to 1000) of the objects in a bucket. You can use the request parameters as selection
     * criteria to return a subset of the objects in a bucket. Note: ListObjectsV2 is the revised List Objects API and
     * we recommend you use this revised API for new application development.
     *
     * @param listObjectsV2Request
     * @return A Java Future containing the result of the ListObjectsV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchBucketException The specified bucket does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.ListObjectsV2
     */
    @Override
    public CompletableFuture<ListObjectsV2Response> listObjectsV2(ListObjectsV2Request listObjectsV2Request) {
        try {

            StaxResponseHandler<ListObjectsV2Response> responseHandler = new StaxResponseHandler<ListObjectsV2Response>(
                    new ListObjectsV2ResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<ListObjectsV2Request, ListObjectsV2Response>()
                    .withMarshaller(new ListObjectsV2RequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listObjectsV2Request));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns some or all (up to 1000) of the objects in a bucket. You can use the request parameters as selection
     * criteria to return a subset of the objects in a bucket. Note: ListObjectsV2 is the revised List Objects API and
     * we recommend you use this revised API for new application development.<br/>
     * <p>
     * This is a variant of {@link #listObjectsV2(software.amazon.awssdk.services.s3.model.ListObjectsV2Request)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectsV2Publisher publisher = client.listObjectsV2Paginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectsV2Publisher publisher = client.listObjectsV2Paginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3.model.ListObjectsV2Response>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3.model.ListObjectsV2Response response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectsV2(software.amazon.awssdk.services.s3.model.ListObjectsV2Request)} operation.</b>
     * </p>
     *
     * @param listObjectsV2Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchBucketException The specified bucket does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.ListObjectsV2
     */
    public ListObjectsV2Publisher listObjectsV2Paginator(ListObjectsV2Request listObjectsV2Request) {
        return new ListObjectsV2Publisher(this, applyPaginatorUserAgent(listObjectsV2Request));
    }

    /**
     * Lists the parts that have been uploaded for a specific multipart upload.
     *
     * @param listPartsRequest
     * @return A Java Future containing the result of the ListParts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.ListParts
     */
    @Override
    public CompletableFuture<ListPartsResponse> listParts(ListPartsRequest listPartsRequest) {
        try {

            StaxResponseHandler<ListPartsResponse> responseHandler = new StaxResponseHandler<ListPartsResponse>(
                    new ListPartsResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<ListPartsRequest, ListPartsResponse>()
                    .withMarshaller(new ListPartsRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listPartsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the parts that have been uploaded for a specific multipart upload.<br/>
     * <p>
     * This is a variant of {@link #listParts(software.amazon.awssdk.services.s3.model.ListPartsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListPartsPublisher publisher = client.listPartsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListPartsPublisher publisher = client.listPartsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3.model.ListPartsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3.model.ListPartsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParts(software.amazon.awssdk.services.s3.model.ListPartsRequest)} operation.</b>
     * </p>
     *
     * @param listPartsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.ListParts
     */
    public ListPartsPublisher listPartsPaginator(ListPartsRequest listPartsRequest) {
        return new ListPartsPublisher(this, applyPaginatorUserAgent(listPartsRequest));
    }

    /**
     * Sets the accelerate configuration of an existing bucket.
     *
     * @param putBucketAccelerateConfigurationRequest
     * @return A Java Future containing the result of the PutBucketAccelerateConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketAccelerateConfiguration
     */
    @Override
    public CompletableFuture<PutBucketAccelerateConfigurationResponse> putBucketAccelerateConfiguration(
            PutBucketAccelerateConfigurationRequest putBucketAccelerateConfigurationRequest) {
        try {

            StaxResponseHandler<PutBucketAccelerateConfigurationResponse> responseHandler = new StaxResponseHandler<PutBucketAccelerateConfigurationResponse>(
                    new PutBucketAccelerateConfigurationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<PutBucketAccelerateConfigurationRequest, PutBucketAccelerateConfigurationResponse>()
                            .withMarshaller(new PutBucketAccelerateConfigurationRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putBucketAccelerateConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Sets the permissions on a bucket using access control lists (ACL).
     *
     * @param putBucketAclRequest
     * @return A Java Future containing the result of the PutBucketAcl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketAcl
     */
    @Override
    public CompletableFuture<PutBucketAclResponse> putBucketAcl(PutBucketAclRequest putBucketAclRequest) {
        try {

            StaxResponseHandler<PutBucketAclResponse> responseHandler = new StaxResponseHandler<PutBucketAclResponse>(
                    new PutBucketAclResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<PutBucketAclRequest, PutBucketAclResponse>()
                    .withMarshaller(new PutBucketAclRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putBucketAclRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Sets an analytics configuration for the bucket (specified by the analytics configuration ID).
     *
     * @param putBucketAnalyticsConfigurationRequest
     * @return A Java Future containing the result of the PutBucketAnalyticsConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketAnalyticsConfiguration
     */
    @Override
    public CompletableFuture<PutBucketAnalyticsConfigurationResponse> putBucketAnalyticsConfiguration(
            PutBucketAnalyticsConfigurationRequest putBucketAnalyticsConfigurationRequest) {
        try {

            StaxResponseHandler<PutBucketAnalyticsConfigurationResponse> responseHandler = new StaxResponseHandler<PutBucketAnalyticsConfigurationResponse>(
                    new PutBucketAnalyticsConfigurationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<PutBucketAnalyticsConfigurationRequest, PutBucketAnalyticsConfigurationResponse>()
                            .withMarshaller(new PutBucketAnalyticsConfigurationRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putBucketAnalyticsConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Sets the cors configuration for a bucket.
     *
     * @param putBucketCorsRequest
     * @return A Java Future containing the result of the PutBucketCors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketCors
     */
    @Override
    public CompletableFuture<PutBucketCorsResponse> putBucketCors(PutBucketCorsRequest putBucketCorsRequest) {
        try {

            StaxResponseHandler<PutBucketCorsResponse> responseHandler = new StaxResponseHandler<PutBucketCorsResponse>(
                    new PutBucketCorsResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<PutBucketCorsRequest, PutBucketCorsResponse>()
                    .withMarshaller(new PutBucketCorsRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putBucketCorsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Adds an inventory configuration (identified by the inventory ID) from the bucket.
     *
     * @param putBucketInventoryConfigurationRequest
     * @return A Java Future containing the result of the PutBucketInventoryConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketInventoryConfiguration
     */
    @Override
    public CompletableFuture<PutBucketInventoryConfigurationResponse> putBucketInventoryConfiguration(
            PutBucketInventoryConfigurationRequest putBucketInventoryConfigurationRequest) {
        try {

            StaxResponseHandler<PutBucketInventoryConfigurationResponse> responseHandler = new StaxResponseHandler<PutBucketInventoryConfigurationResponse>(
                    new PutBucketInventoryConfigurationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<PutBucketInventoryConfigurationRequest, PutBucketInventoryConfigurationResponse>()
                            .withMarshaller(new PutBucketInventoryConfigurationRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putBucketInventoryConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deprecated, see the PutBucketLifecycleConfiguration operation.
     *
     * @param putBucketLifecycleRequest
     * @return A Java Future containing the result of the PutBucketLifecycle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketLifecycle
     */
    @Override
    public CompletableFuture<PutBucketLifecycleResponse> putBucketLifecycle(PutBucketLifecycleRequest putBucketLifecycleRequest) {
        try {

            StaxResponseHandler<PutBucketLifecycleResponse> responseHandler = new StaxResponseHandler<PutBucketLifecycleResponse>(
                    new PutBucketLifecycleResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<PutBucketLifecycleRequest, PutBucketLifecycleResponse>()
                    .withMarshaller(new PutBucketLifecycleRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putBucketLifecycleRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Sets lifecycle configuration for your bucket. If a lifecycle configuration exists, it replaces it.
     *
     * @param putBucketLifecycleConfigurationRequest
     * @return A Java Future containing the result of the PutBucketLifecycleConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketLifecycleConfiguration
     */
    @Override
    public CompletableFuture<PutBucketLifecycleConfigurationResponse> putBucketLifecycleConfiguration(
            PutBucketLifecycleConfigurationRequest putBucketLifecycleConfigurationRequest) {
        try {

            StaxResponseHandler<PutBucketLifecycleConfigurationResponse> responseHandler = new StaxResponseHandler<PutBucketLifecycleConfigurationResponse>(
                    new PutBucketLifecycleConfigurationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<PutBucketLifecycleConfigurationRequest, PutBucketLifecycleConfigurationResponse>()
                            .withMarshaller(new PutBucketLifecycleConfigurationRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putBucketLifecycleConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Set the logging parameters for a bucket and to specify permissions for who can view and modify the logging
     * parameters. To set the logging status of a bucket, you must be the bucket owner.
     *
     * @param putBucketLoggingRequest
     * @return A Java Future containing the result of the PutBucketLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketLogging
     */
    @Override
    public CompletableFuture<PutBucketLoggingResponse> putBucketLogging(PutBucketLoggingRequest putBucketLoggingRequest) {
        try {

            StaxResponseHandler<PutBucketLoggingResponse> responseHandler = new StaxResponseHandler<PutBucketLoggingResponse>(
                    new PutBucketLoggingResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<PutBucketLoggingRequest, PutBucketLoggingResponse>()
                    .withMarshaller(new PutBucketLoggingRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putBucketLoggingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Sets a metrics configuration (specified by the metrics configuration ID) for the bucket.
     *
     * @param putBucketMetricsConfigurationRequest
     * @return A Java Future containing the result of the PutBucketMetricsConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketMetricsConfiguration
     */
    @Override
    public CompletableFuture<PutBucketMetricsConfigurationResponse> putBucketMetricsConfiguration(
            PutBucketMetricsConfigurationRequest putBucketMetricsConfigurationRequest) {
        try {

            StaxResponseHandler<PutBucketMetricsConfigurationResponse> responseHandler = new StaxResponseHandler<PutBucketMetricsConfigurationResponse>(
                    new PutBucketMetricsConfigurationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<PutBucketMetricsConfigurationRequest, PutBucketMetricsConfigurationResponse>()
                            .withMarshaller(new PutBucketMetricsConfigurationRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putBucketMetricsConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deprecated, see the PutBucketNotificationConfiguraiton operation.
     *
     * @param putBucketNotificationRequest
     * @return A Java Future containing the result of the PutBucketNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketNotification
     */
    @Override
    public CompletableFuture<PutBucketNotificationResponse> putBucketNotification(
            PutBucketNotificationRequest putBucketNotificationRequest) {
        try {

            StaxResponseHandler<PutBucketNotificationResponse> responseHandler = new StaxResponseHandler<PutBucketNotificationResponse>(
                    new PutBucketNotificationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<PutBucketNotificationRequest, PutBucketNotificationResponse>()
                    .withMarshaller(new PutBucketNotificationRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putBucketNotificationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Enables notifications of specified events for a bucket.
     *
     * @param putBucketNotificationConfigurationRequest
     * @return A Java Future containing the result of the PutBucketNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketNotificationConfiguration
     */
    @Override
    public CompletableFuture<PutBucketNotificationConfigurationResponse> putBucketNotificationConfiguration(
            PutBucketNotificationConfigurationRequest putBucketNotificationConfigurationRequest) {
        try {

            StaxResponseHandler<PutBucketNotificationConfigurationResponse> responseHandler = new StaxResponseHandler<PutBucketNotificationConfigurationResponse>(
                    new PutBucketNotificationConfigurationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<PutBucketNotificationConfigurationRequest, PutBucketNotificationConfigurationResponse>()
                            .withMarshaller(new PutBucketNotificationConfigurationRequestMarshaller())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putBucketNotificationConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Replaces a policy on a bucket. If the bucket already has a policy, the one in this request completely replaces
     * it.
     *
     * @param putBucketPolicyRequest
     * @return A Java Future containing the result of the PutBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketPolicy
     */
    @Override
    public CompletableFuture<PutBucketPolicyResponse> putBucketPolicy(PutBucketPolicyRequest putBucketPolicyRequest) {
        try {

            StaxResponseHandler<PutBucketPolicyResponse> responseHandler = new StaxResponseHandler<PutBucketPolicyResponse>(
                    new PutBucketPolicyResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<PutBucketPolicyRequest, PutBucketPolicyResponse>()
                    .withMarshaller(new PutBucketPolicyRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putBucketPolicyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a new replication configuration (or replaces an existing one, if present).
     *
     * @param putBucketReplicationRequest
     * @return A Java Future containing the result of the PutBucketReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketReplication
     */
    @Override
    public CompletableFuture<PutBucketReplicationResponse> putBucketReplication(
            PutBucketReplicationRequest putBucketReplicationRequest) {
        try {

            StaxResponseHandler<PutBucketReplicationResponse> responseHandler = new StaxResponseHandler<PutBucketReplicationResponse>(
                    new PutBucketReplicationResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<PutBucketReplicationRequest, PutBucketReplicationResponse>()
                    .withMarshaller(new PutBucketReplicationRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putBucketReplicationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Sets the request payment configuration for a bucket. By default, the bucket owner pays for downloads from the
     * bucket. This configuration parameter enables the bucket owner (only) to specify that the person requesting the
     * download will be charged for the download. Documentation on requester pays buckets can be found at
     * http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html
     *
     * @param putBucketRequestPaymentRequest
     * @return A Java Future containing the result of the PutBucketRequestPayment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketRequestPayment
     */
    @Override
    public CompletableFuture<PutBucketRequestPaymentResponse> putBucketRequestPayment(
            PutBucketRequestPaymentRequest putBucketRequestPaymentRequest) {
        try {

            StaxResponseHandler<PutBucketRequestPaymentResponse> responseHandler = new StaxResponseHandler<PutBucketRequestPaymentResponse>(
                    new PutBucketRequestPaymentResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<PutBucketRequestPaymentRequest, PutBucketRequestPaymentResponse>()
                            .withMarshaller(new PutBucketRequestPaymentRequestMarshaller()).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putBucketRequestPaymentRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Sets the tags for a bucket.
     *
     * @param putBucketTaggingRequest
     * @return A Java Future containing the result of the PutBucketTagging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketTagging
     */
    @Override
    public CompletableFuture<PutBucketTaggingResponse> putBucketTagging(PutBucketTaggingRequest putBucketTaggingRequest) {
        try {

            StaxResponseHandler<PutBucketTaggingResponse> responseHandler = new StaxResponseHandler<PutBucketTaggingResponse>(
                    new PutBucketTaggingResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<PutBucketTaggingRequest, PutBucketTaggingResponse>()
                    .withMarshaller(new PutBucketTaggingRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putBucketTaggingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Sets the versioning state of an existing bucket. To set the versioning state, you must be the bucket owner.
     *
     * @param putBucketVersioningRequest
     * @return A Java Future containing the result of the PutBucketVersioning operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketVersioning
     */
    @Override
    public CompletableFuture<PutBucketVersioningResponse> putBucketVersioning(
            PutBucketVersioningRequest putBucketVersioningRequest) {
        try {

            StaxResponseHandler<PutBucketVersioningResponse> responseHandler = new StaxResponseHandler<PutBucketVersioningResponse>(
                    new PutBucketVersioningResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<PutBucketVersioningRequest, PutBucketVersioningResponse>()
                    .withMarshaller(new PutBucketVersioningRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putBucketVersioningRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Set the website configuration for a bucket.
     *
     * @param putBucketWebsiteRequest
     * @return A Java Future containing the result of the PutBucketWebsite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutBucketWebsite
     */
    @Override
    public CompletableFuture<PutBucketWebsiteResponse> putBucketWebsite(PutBucketWebsiteRequest putBucketWebsiteRequest) {
        try {

            StaxResponseHandler<PutBucketWebsiteResponse> responseHandler = new StaxResponseHandler<PutBucketWebsiteResponse>(
                    new PutBucketWebsiteResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<PutBucketWebsiteRequest, PutBucketWebsiteResponse>()
                    .withMarshaller(new PutBucketWebsiteRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putBucketWebsiteRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Adds an object to a bucket.
     *
     * @param putObjectRequest
     * @param requestBody
     *        Functional interface that can be implemented to produce the request content in a non-blocking manner. The
     *        size of the content is expected to be known up front. See {@link AsyncRequestBody} for specific details on
     *        implementing this interface as well as links to precanned implementations for common scenarios like
     *        uploading from a file. The service documentation for the request content is as follows 'Object data.'
     * @return A Java Future containing the result of the PutObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutObject
     */
    @Override
    public CompletableFuture<PutObjectResponse> putObject(PutObjectRequest putObjectRequest, AsyncRequestBody requestBody) {
        try {

            StaxResponseHandler<PutObjectResponse> responseHandler = new StaxResponseHandler<PutObjectResponse>(
                    new PutObjectResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler
                    .execute(new ClientExecutionParams<PutObjectRequest, PutObjectResponse>()
                            .withMarshaller(new PutObjectRequestMarshaller()).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withAsyncRequestBody(requestBody)
                            .withInput(putObjectRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * uses the acl subresource to set the access control list (ACL) permissions for an object that already exists in a
     * bucket
     *
     * @param putObjectAclRequest
     * @return A Java Future containing the result of the PutObjectAcl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchKeyException The specified key does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutObjectAcl
     */
    @Override
    public CompletableFuture<PutObjectAclResponse> putObjectAcl(PutObjectAclRequest putObjectAclRequest) {
        try {

            StaxResponseHandler<PutObjectAclResponse> responseHandler = new StaxResponseHandler<PutObjectAclResponse>(
                    new PutObjectAclResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<PutObjectAclRequest, PutObjectAclResponse>()
                    .withMarshaller(new PutObjectAclRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putObjectAclRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Sets the supplied tag-set to an object that already exists in a bucket
     *
     * @param putObjectTaggingRequest
     * @return A Java Future containing the result of the PutObjectTagging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.PutObjectTagging
     */
    @Override
    public CompletableFuture<PutObjectTaggingResponse> putObjectTagging(PutObjectTaggingRequest putObjectTaggingRequest) {
        try {

            StaxResponseHandler<PutObjectTaggingResponse> responseHandler = new StaxResponseHandler<PutObjectTaggingResponse>(
                    new PutObjectTaggingResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<PutObjectTaggingRequest, PutObjectTaggingResponse>()
                    .withMarshaller(new PutObjectTaggingRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putObjectTaggingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Restores an archived copy of an object back into Amazon S3
     *
     * @param restoreObjectRequest
     * @return A Java Future containing the result of the RestoreObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ObjectAlreadyInActiveTierErrorException This operation is not allowed against this storage tier</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.RestoreObject
     */
    @Override
    public CompletableFuture<RestoreObjectResponse> restoreObject(RestoreObjectRequest restoreObjectRequest) {
        try {

            StaxResponseHandler<RestoreObjectResponse> responseHandler = new StaxResponseHandler<RestoreObjectResponse>(
                    new RestoreObjectResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<RestoreObjectRequest, RestoreObjectResponse>()
                    .withMarshaller(new RestoreObjectRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(restoreObjectRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Uploads a part in a multipart upload.
     * </p>
     * <p>
     * <b>Note:</b> After you initiate multipart upload and upload one or more parts, you must either complete or abort
     * multipart upload in order to stop getting charged for storage of the uploaded parts. Only after you either
     * complete or abort multipart upload, Amazon S3 frees up the parts storage and stops charging you for the parts
     * storage.
     * </p>
     *
     * @param uploadPartRequest
     * @param requestBody
     *        Functional interface that can be implemented to produce the request content in a non-blocking manner. The
     *        size of the content is expected to be known up front. See {@link AsyncRequestBody} for specific details on
     *        implementing this interface as well as links to precanned implementations for common scenarios like
     *        uploading from a file. The service documentation for the request content is as follows 'Object data.'
     * @return A Java Future containing the result of the UploadPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.UploadPart
     */
    @Override
    public CompletableFuture<UploadPartResponse> uploadPart(UploadPartRequest uploadPartRequest, AsyncRequestBody requestBody) {
        try {

            StaxResponseHandler<UploadPartResponse> responseHandler = new StaxResponseHandler<UploadPartResponse>(
                    new UploadPartResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<UploadPartRequest, UploadPartResponse>()
                    .withMarshaller(new UploadPartRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withAsyncRequestBody(requestBody)
                    .withInput(uploadPartRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Uploads a part by copying data from an existing object as data source.
     *
     * @param uploadPartCopyRequest
     * @return A Java Future containing the result of the UploadPartCopy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample S3AsyncClient.UploadPartCopy
     */
    @Override
    public CompletableFuture<UploadPartCopyResponse> uploadPartCopy(UploadPartCopyRequest uploadPartCopyRequest) {
        try {

            StaxResponseHandler<UploadPartCopyResponse> responseHandler = new StaxResponseHandler<UploadPartCopyResponse>(
                    new UploadPartCopyResponseUnmarshaller());

            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

            return clientHandler.execute(new ClientExecutionParams<UploadPartCopyRequest, UploadPartCopyResponse>()
                    .withMarshaller(new UploadPartCopyRequestMarshaller()).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(uploadPartCopyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private List<Unmarshaller<AwsServiceException, Node>> init() {
        List<Unmarshaller<AwsServiceException, Node>> unmarshallers = new ArrayList<>();
        unmarshallers.add(new NoSuchUploadExceptionUnmarshaller());
        unmarshallers.add(new ObjectAlreadyInActiveTierErrorExceptionUnmarshaller());
        unmarshallers.add(new BucketAlreadyExistsExceptionUnmarshaller());
        unmarshallers.add(new NoSuchBucketExceptionUnmarshaller());
        unmarshallers.add(new ObjectNotInActiveTierErrorExceptionUnmarshaller());
        unmarshallers.add(new BucketAlreadyOwnedByYouExceptionUnmarshaller());
        unmarshallers.add(new NoSuchKeyExceptionUnmarshaller());
        unmarshallers.add(new StandardS3ExceptionUnmarshaller(S3Exception.class));
        return unmarshallers;
    }

    private <T extends S3Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
