/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.xpath.XPath;
import org.w3c.dom.Node;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.runtime.transform.AbstractErrorUnmarshaller;
import software.amazon.awssdk.core.util.XpathUtils;
import software.amazon.awssdk.utils.StringUtils;

public abstract class S3ExceptionUnmarshaller
extends AbstractErrorUnmarshaller<AwsServiceException, Node> {
    private final String errorCode;

    S3ExceptionUnmarshaller(Class<? extends AwsServiceException> exceptionClass, String errorCode) {
        super(exceptionClass);
        this.errorCode = errorCode;
    }

    public AwsServiceException unmarshall(Node in) throws Exception {
        XPath xpath = XpathUtils.xpath();
        String error = XpathUtils.asString((String)"Error/Code", (Node)in, (XPath)xpath);
        String requestId = XpathUtils.asString((String)"Error/RequestId", (Node)in, (XPath)xpath);
        String message = XpathUtils.asString((String)"Error/Message", (Node)in, (XPath)xpath);
        if (this.errorCode != null && !StringUtils.equals((String)error, (String)this.errorCode)) {
            return null;
        }
        AwsServiceException exception = (AwsServiceException)this.newException(message);
        exception.errorCode(this.errorCode);
        exception.requestId(requestId);
        return exception;
    }
}

