/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.Md5Utils;
import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.XmlWriter;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.RequestPaymentConfiguration;

public class PutBucketRequestPaymentRequestMarshaller
implements Marshaller<Request<PutBucketRequestPaymentRequest>, PutBucketRequestPaymentRequest> {
    public Request<PutBucketRequestPaymentRequest> marshall(PutBucketRequestPaymentRequest putBucketRequestPaymentRequest) {
        if (putBucketRequestPaymentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)putBucketRequestPaymentRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketRequestPaymentRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString((String)putBucketRequestPaymentRequest.contentMD5()));
        }
        String uriResourcePath = "/{Bucket}?requestPayment";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketRequestPaymentRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            RequestPaymentConfiguration requestPaymentConfiguration = putBucketRequestPaymentRequest.requestPaymentConfiguration();
            if (requestPaymentConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("RequestPaymentConfiguration");
                if (requestPaymentConfiguration.payerAsString() != null) {
                    xmlWriter.startElement("Payer").value(requestPaymentConfiguration.payerAsString()).endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

