/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest;

public class GetObjectTorrentRequestMarshaller
implements Marshaller<Request<GetObjectTorrentRequest>, GetObjectTorrentRequest> {
    public Request<GetObjectTorrentRequest> marshall(GetObjectTorrentRequest getObjectTorrentRequest) {
        if (getObjectTorrentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getObjectTorrentRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        if (getObjectTorrentRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)getObjectTorrentRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}?torrent";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getObjectTorrentRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", getObjectTorrentRequest.key());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

