/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.transform.CompletedPartUnmarshaller;

public class CompletedMultipartUploadUnmarshaller
implements Unmarshaller<CompletedMultipartUpload, StaxUnmarshallerContext> {
    private static final CompletedMultipartUploadUnmarshaller INSTANCE = new CompletedMultipartUploadUnmarshaller();

    public CompletedMultipartUpload unmarshall(StaxUnmarshallerContext context) throws Exception {
        CompletedMultipartUpload.Builder completedMultipartUpload;
        block5: {
            completedMultipartUpload = CompletedMultipartUpload.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<CompletedPart> parts = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    completedMultipartUpload.parts(parts);
                    break block5;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (!context.testExpression("Part", targetDepth)) continue;
                    if (parts == null) {
                        parts = new ArrayList<CompletedPart>();
                    }
                    parts.add(CompletedPartUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            completedMultipartUpload.parts(parts);
        }
        return (CompletedMultipartUpload)completedMultipartUpload.build();
    }

    public static CompletedMultipartUploadUnmarshaller getInstance() {
        return INSTANCE;
    }
}

